/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.googlechat.client;

import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import io.gitlab.jfronny.googlechat.GoogleChat;
import io.gitlab.jfronny.googlechat.GoogleChatConfig;
import io.gitlab.jfronny.libjf.config.api.v2.ConfigHolder;
import io.gitlab.jfronny.libjf.config.api.v2.ConfigInstance;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2196;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class GoogleChatClient
implements ClientModInitializer {
    public void onInitializeClient() {
        ConfigInstance ci = ConfigHolder.getInstance().get("google-chat");
        if (ci != null && FabricLoader.getInstance().isModLoaded("fabric-key-binding-api-v1") && FabricLoader.getInstance().isModLoaded("fabric-lifecycle-events-v1")) {
            GoogleChatClient.setupKeybind(ci);
        }
    }

    private static void setupKeybind(@NotNull ConfigInstance ci) {
        class_304 keyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.google-chat.toggle", class_3675.class_307.field_1668, -1, class_304.class_11900.field_62557));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (keyBinding.method_1436()) {
                GoogleChatConfig.General.enabled = !GoogleChatConfig.General.enabled;
                ci.write();
            }
        });
    }

    public static <S> Optional<String> reconstitute(String source, CommandContextBuilder<S> results) {
        StringBuilder builder = new StringBuilder();
        block5: for (ParsedCommandNode node : results.getNodes()) {
            CommandNode commandNode;
            Objects.requireNonNull(node.getNode());
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ArgumentCommandNode.class, LiteralCommandNode.class, RootCommandNode.class}, (Object)commandNode, n)) {
                case 0: {
                    ArgumentCommandNode arg = (ArgumentCommandNode)commandNode;
                    ParsedArgument pa = (ParsedArgument)results.getArguments().get(arg.getName());
                    String datum = pa.getRange().get(source);
                    Object object = pa.getResult();
                    if (object instanceof class_2196.class_2197) {
                        class_2196.class_2197 fmt = (class_2196.class_2197)object;
                        builder.append(fmt.comp_2653());
                    } else {
                        builder.append(datum);
                    }
                    builder.append(' ');
                    continue block5;
                }
                case 1: {
                    LiteralCommandNode lit = (LiteralCommandNode)commandNode;
                    builder.append(lit.getLiteral());
                    builder.append(' ');
                    continue block5;
                }
                case 2: {
                    RootCommandNode root = (RootCommandNode)commandNode;
                    continue block5;
                }
            }
            return Optional.empty();
        }
        if (GoogleChatConfig.Advanced.debugLogs) {
            GoogleChat.LOGGER.info("Reconstituted command: {0} from {1}", new Object[]{builder.substring(0, builder.length() - 1), source});
        }
        return Optional.of(builder.substring(0, builder.length() - 1));
    }
}

