/*
 * Decompiled with CFR 0.152.
 */
package org.ayamemc.ayamepaperdoll.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.tabs.TabManager;
import net.minecraft.client.gui.components.tabs.TabNavigationBar;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.ArrayUtils;
import org.ayamemc.ayamepaperdoll.AyamePaperDoll;
import org.ayamemc.ayamepaperdoll.CommonInterfaceInstances;
import org.ayamemc.ayamepaperdoll.config.ConfigWidgetRegistry;
import org.ayamemc.ayamepaperdoll.config.Configs;
import org.ayamemc.ayamepaperdoll.config.VisualConfigEditorScreen;
import org.ayamemc.ayamepaperdoll.config.model.ConfigOption;
import org.ayamemc.ayamepaperdoll.config.view.ListWidget;
import org.ayamemc.ayamepaperdoll.config.view.Tab;
import org.ayamemc.ayamepaperdoll.hud.PaperDollRenderer;
import org.jetbrains.annotations.NotNull;

public class ConfigScreen
extends Screen {
    private static final int TAB_BUTTON_HEIGHT = 24;
    private static final int ENTRY_HEIGHT = 30;
    private static final int LIST_WIDTH_OFFSET = -50;
    private final Screen lastScreen;
    private final PaperDollRenderer previewHud;
    private final TabManager tabManager;
    private final List<ListWidget> listWidgets;
    private final List<? extends ConfigOption<?>> options;
    private Tab[] tabs;
    private TabNavigationBar tabNav;

    public ConfigScreen(Screen lastScreen, List<? extends ConfigOption<?>> options) {
        super(Component.nullToEmpty((String)"Config Screen"));
        while (lastScreen instanceof ConfigScreen) {
            ConfigScreen configScreen = (ConfigScreen)lastScreen;
            lastScreen = configScreen.lastScreen;
        }
        this.lastScreen = lastScreen;
        this.previewHud = PaperDollRenderer.getInstance();
        this.tabManager = new TabManager(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        }, x$0 -> this.removeWidget((GuiEventListener)x$0));
        this.options = options;
        this.listWidgets = new ArrayList<ListWidget>();
    }

    protected void init() {
        this.tabs = this.generateTabs();
        this.tabNav = TabNavigationBar.builder((TabManager)this.tabManager, (int)this.width).addTabs((net.minecraft.client.gui.components.tabs.Tab[])this.tabs).build();
        this.addRenderableWidget((GuiEventListener)this.tabNav);
        int tabIdx = AyamePaperDoll.CONFIGS.lastConfigTabIdx.getValue();
        if (tabIdx < 0 || tabIdx >= this.tabs.length) {
            tabIdx = 0;
            AyamePaperDoll.CONFIGS.lastConfigTabIdx.setValue(0);
        }
        this.tabNav.selectTab(tabIdx, false);
        this.repositionElements();
    }

    private Tab[] generateTabs() {
        ArrayList<Tab> tabs = new ArrayList<Tab>();
        HashMap<ResourceLocation, ListWidget> categoryLists = new HashMap<ResourceLocation, ListWidget>();
        for (ConfigOption<?> option : this.options) {
            if (option.getCategory().equals((Object)Configs.HIDDEN_CATEGORY)) continue;
            Optional<ListWidget.ListEntry> configEntryOptioal = ConfigWidgetRegistry.DEFAULT.getConfigEntry(option);
            if (configEntryOptioal.isEmpty()) {
                AyamePaperDoll.LOGGER.error("Could not find widget for option {}", (Object)option.getId());
                continue;
            }
            StringWidget label = new StringWidget(option.getName(), this.minecraft.font);
            label.setTooltip(Tooltip.create((Component)option.getDescription()));
            ResourceLocation category = option.getCategory();
            if (!categoryLists.containsKey(category)) {
                Tab tab = new Tab((Component)Component.translatable((String)"config.%s.category.%s".formatted(category.getNamespace(), category.getPath())));
                ListWidget list = new ListWidget(this.width, this.height - 24, 24, 30);
                this.listWidgets.add(list);
                tab.addChild((AbstractWidget)list);
                tabs.add(tab);
                categoryLists.put(category, list);
            }
            ((ListWidget)categoryLists.get(category)).addEntry(configEntryOptioal.get());
            if (option.getId().equals((Object)AyamePaperDoll.path("display_paperdoll"))) {
                ((ListWidget)categoryLists.get(category)).addEntry(this.getPresetsConfigEntry());
            }
            if (!option.getId().equals((Object)AyamePaperDoll.path("display_paperdoll"))) continue;
            ((ListWidget)categoryLists.get(category)).addEntry(this.getVisualConfigEditorLabelEntry());
        }
        if (tabs.isEmpty()) {
            tabs.add(new Tab(Component.nullToEmpty((String)"")));
        }
        return (Tab[])tabs.toArray(Tab[]::new);
    }

    protected void repositionElements() {
        if (this.tabNav == null) {
            return;
        }
        this.tabNav.setWidth(this.width);
        this.tabNav.arrangeElements();
        for (ListWidget listWidget : this.listWidgets) {
            listWidget.setSize(this.width, this.height - 24);
            listWidget.setRowWidth(this.width + -50);
        }
    }

    public void onClose() {
        AyamePaperDoll.CONFIGS.lastConfigTabIdx.setValue(ArrayUtils.indexOf((Object[])this.tabs, (Object)this.tabManager.getCurrentTab()));
        this.minecraft.setScreen(this.lastScreen);
        AyamePaperDoll.CONFIG_PERSISTENCE.save(AyamePaperDoll.CONFIGS.getOptions());
    }

    protected void renderBlurredBackground(GuiGraphics guiGraphics) {
        if (this.minecraft.level == null || !AyamePaperDoll.CONFIGS.disableConfigScreenBlur.getValue().booleanValue()) {
            super.renderBlurredBackground(guiGraphics);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        if (this.minecraft.level != null) {
            this.previewHud.render(this.minecraft.getDeltaTracker().getGameTimeDeltaPartialTick(true), guiGraphics);
            guiGraphics.pose().translate(0.0f, 0.0f);
        }
        super.render(guiGraphics, mouseX, mouseY, delta);
    }

    public boolean isPauseScreen() {
        return AyamePaperDoll.CONFIGS.pauseGameOnConfigScreen.getValue();
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        if (keyEvent.key() == CommonInterfaceInstances.keyHelper.getBoundKeyOf(AyamePaperDoll.OPEN_CONFIG_GUI).getValue() && this.shouldCloseOnEsc()) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyEvent);
    }

    private ListWidget.ListEntry getPresetsConfigEntry() {
        int buttonWidth = 70;
        int gap = 10;
        int buttonHeight = 20;
        int labelYOffset = 7;
        final StringWidget presetLabel = new StringWidget((Component)Component.translatable((String)"config.%s.option.presets".formatted("ayame_paperdoll")), this.minecraft.font);
        presetLabel.setTooltip(Tooltip.create((Component)Component.translatable((String)"config.%s.option.presets.desc".formatted("ayame_paperdoll"))));
        final ConfigWidgetRegistry.ConfigButton topLeft = new ConfigWidgetRegistry.ConfigButton(70, 20, this.getPresetText("top_left"), this.getPresetPressAction(AyamePaperDoll.CONFIGS.topLeft));
        final ConfigWidgetRegistry.ConfigButton topRight = new ConfigWidgetRegistry.ConfigButton(70, 20, this.getPresetText("top_right"), this.getPresetPressAction(AyamePaperDoll.CONFIGS.topRight));
        final ConfigWidgetRegistry.ConfigButton bottomLeft = new ConfigWidgetRegistry.ConfigButton(70, 20, this.getPresetText("bottom_left"), this.getPresetPressAction(AyamePaperDoll.CONFIGS.bottomLeft));
        final ConfigWidgetRegistry.ConfigButton bottomRight = new ConfigWidgetRegistry.ConfigButton(70, 20, this.getPresetText("bottom_right"), this.getPresetPressAction(AyamePaperDoll.CONFIGS.bottomRight));
        final List<ConfigWidgetRegistry.ConfigButton> children = List.of(presetLabel, topLeft, topRight, bottomLeft, bottomRight);
        return new ListWidget.ListEntry(this){

            @NotNull
            public List<? extends NarratableEntry> narratables() {
                return children;
            }

            @NotNull
            public List<? extends GuiEventListener> children() {
                return children;
            }

            public void renderContent(GuiGraphics context, int i, int j, boolean hovered, float tickDelta) {
                presetLabel.setPosition(this.getContentX(), this.getContentY() + 7);
                topLeft.setPosition(this.getContentX() + this.getContentWidth() - 280 - 30, this.getContentY());
                topRight.setPosition(this.getContentX() + this.getContentWidth() - 210 - 20, this.getContentY());
                bottomLeft.setPosition(this.getContentX() + this.getContentWidth() - 140 - 10, this.getContentY());
                bottomRight.setPosition(this.getContentX() + this.getContentWidth() - 70, this.getContentY());
                for (AbstractWidget child : children) {
                    child.render(context, i, j, tickDelta);
                }
            }
        };
    }

    private ListWidget.ListEntry getVisualConfigEditorLabelEntry() {
        int buttonWidth = 140;
        int buttonHeight = 20;
        final ConfigWidgetRegistry.ConfigButton visualConfigEditorButton = new ConfigWidgetRegistry.ConfigButton(140, 20, this.getButtonText("visual_config_editor"), button -> this.minecraft.setScreen((Screen)new VisualConfigEditorScreen(this)));
        if (this.minecraft.level == null) {
            visualConfigEditorButton.active = false;
            visualConfigEditorButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"config.%s.option.visual_config_editor_not_available.desc".formatted("ayame_paperdoll"))));
        } else {
            visualConfigEditorButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"config.%s.option.visual_config_editor.desc".formatted("ayame_paperdoll"))));
        }
        final List<ConfigWidgetRegistry.ConfigButton> children = List.of(visualConfigEditorButton);
        return new ListWidget.ListEntry(this){

            public void renderContent(GuiGraphics guiGraphics, int i, int j, boolean bl, float f) {
                visualConfigEditorButton.setPosition((this.getContentX() + this.getContentWidth() - 140) / 2, this.getContentY());
                for (AbstractWidget child : children) {
                    child.render(guiGraphics, i, j, f);
                }
            }

            @NotNull
            public List<? extends NarratableEntry> narratables() {
                return children;
            }

            @NotNull
            public List<? extends GuiEventListener> children() {
                return children;
            }
        };
    }

    private Component getPresetText(String text) {
        return Component.translatable((String)"config.%s.presets.%s".formatted("ayame_paperdoll", text));
    }

    private Component getButtonText(String text) {
        return Component.translatable((String)"config.%s.button.%s".formatted("ayame_paperdoll", text));
    }

    private Button.OnPress getPresetPressAction(Configs.Presets presets) {
        return ignored -> {
            presets.load();
            int tabIdx = ArrayUtils.indexOf((Object[])this.tabs, (Object)this.tabManager.getCurrentTab());
            this.clearWidgets();
            this.listWidgets.clear();
            this.init();
            this.tabNav.selectTab(tabIdx, false);
        };
    }
}

