/*
 * Decompiled with CFR 0.152.
 */
package org.ayamemc.ayamepaperdoll.config;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.ayamemc.ayamepaperdoll.AyamePaperDoll;
import org.ayamemc.ayamepaperdoll.config.model.ConfigOption;
import org.ayamemc.ayamepaperdoll.config.model.RangedConfigOption;
import org.ayamemc.ayamepaperdoll.config.view.ListWidget;
import org.ayamemc.ayamepaperdoll.config.view.Retextured;
import org.jetbrains.annotations.NotNull;

public class ConfigWidgetRegistry {
    public static final int RESET_BUTTON_WIDTH = 50;
    public static final ConfigWidgetRegistry DEFAULT = new ConfigWidgetRegistry();
    private static final String ON_LANGKEY = "config.%s.on".formatted("ayame_paperdoll");
    private static final String OFF_LANGKEY = "config.%s.off".formatted("ayame_paperdoll");
    private static final String RESET_LANGKEY = "config.%s.reset".formatted("ayame_paperdoll");
    private static final int WIDGET_WIDTH = 150;
    private static final int WIDGET_HEIGHT = 20;
    private final List<OptionWidgetEntry<?, ?>> defaultWidgets = new ArrayList();

    private ConfigWidgetRegistry() {
        this.defaultWidgets.add(new OptionWidgetEntry<Boolean, ConfigOption>(Boolean.class, ConfigOption.class, ConfigWidgetRegistry::getOnOffButton));
        this.defaultWidgets.add(new OptionWidgetEntry<Enum, ConfigOption>(Enum.class, ConfigOption.class, ConfigWidgetRegistry::getEnumCycleButton));
        this.defaultWidgets.add(new OptionWidgetEntry<Double, RangedConfigOption>(Double.class, RangedConfigOption.class, ConfigWidgetRegistry::getDoubleSlider));
        this.defaultWidgets.add(new OptionWidgetEntry<Integer, RangedConfigOption>(Integer.class, RangedConfigOption.class, ConfigWidgetRegistry::getIntegerSlider));
        this.defaultWidgets.add(new OptionWidgetEntry<String, ConfigOption>(String.class, ConfigOption.class, ConfigWidgetRegistry::getStringField));
    }

    private static <T> Button getResetButton(ConfigOption<T> option, ConfigValueUpdater<T> setter) {
        ConfigButton reset = new ConfigButton(50, 20, (Component)Component.translatable((String)RESET_LANGKEY), self -> setter.setValue(option.getDefaultValue()));
        reset.active = !option.isValueDefault();
        return reset;
    }

    private static ListWidget.ListEntry getStringField(ConfigOption<String> option) {
        ConfigValueUpdater<String> setter = new ConfigValueUpdater<String>();
        ConfigTextField field = new ConfigTextField(150, 20);
        field.setValue(option.getValue());
        field.setResponder(setter::setValue);
        Button reset = ConfigWidgetRegistry.getResetButton(option, setter);
        setter.setUpdateHandler(val -> {
            option.setValue((String)val);
            field.setValue((String)option.getValue());
            reset.active = !option.isValueDefault();
        });
        return new ConfigEntry(option.getName(), Tooltip.create((Component)option.getDescription()), (AbstractWidget)field, reset);
    }

    private static ListWidget.ListEntry getDoubleSlider(RangedConfigOption<Double> option) {
        ConfigValueUpdater<Double> setter = new ConfigValueUpdater<Double>();
        ConfigSlider slider = new ConfigSlider(150, 20, ((Double)option.getValue() - option.getMin()) / (option.getMax() - option.getMin()), val -> setter.setValue(Mth.lerp((double)val, (double)((Double)option.getMin()), (double)((Double)option.getMax()))), val -> Component.nullToEmpty((String)"%.2f".formatted(option.getValue())));
        Button reset = ConfigWidgetRegistry.getResetButton(option, setter);
        setter.setUpdateHandler(val -> {
            option.setValue((Double)val);
            slider.setValueNoEvent(((Double)option.getValue() - (Double)option.getMin()) / ((Double)option.getMax() - (Double)option.getMin()));
            reset.active = !option.isValueDefault();
        });
        return new ConfigEntry(option.getName(), Tooltip.create((Component)option.getDescription()), (AbstractWidget)slider, reset);
    }

    private static ListWidget.ListEntry getIntegerSlider(RangedConfigOption<Integer> option) {
        ConfigValueUpdater<Integer> setter = new ConfigValueUpdater<Integer>();
        double steps = option.getMax() - option.getMin();
        ConfigSlider slider = new ConfigSlider(150, 20, (double)((Integer)option.getValue() - option.getMin()) / steps, val -> setter.setValue((int)Math.round(val * steps) + (Integer)option.getMin()), val -> Component.nullToEmpty((String)Integer.toString((Integer)option.getValue())));
        Button reset = ConfigWidgetRegistry.getResetButton(option, setter);
        setter.setUpdateHandler(val -> {
            option.setValue((Integer)val);
            slider.setValueNoEvent((double)((Integer)option.getValue() - (Integer)option.getMin()) / steps);
            reset.active = !option.isValueDefault();
        });
        return new ConfigEntry(option.getName(), Tooltip.create((Component)option.getDescription()), (AbstractWidget)slider, reset);
    }

    private static ListWidget.ListEntry getOnOffButton(ConfigOption<Boolean> option) {
        ConfigValueUpdater<Boolean> setter = new ConfigValueUpdater<Boolean>();
        ConfigButton btn = new ConfigButton(150, 20, (Component)Component.translatable((String)(option.getValue() != false ? ON_LANGKEY : OFF_LANGKEY)), self -> setter.setValue((Boolean)option.getValue() == false));
        Button reset = ConfigWidgetRegistry.getResetButton(option, setter);
        setter.setUpdateHandler(val -> {
            option.setValue((Boolean)val);
            btn.setMessage((Component)Component.translatable((String)((Boolean)option.getValue() != false ? ON_LANGKEY : OFF_LANGKEY)));
            reset.active = !option.isValueDefault();
        });
        return new ConfigEntry(option.getName(), Tooltip.create((Component)option.getDescription()), (AbstractWidget)btn, reset);
    }

    private static <T extends Enum<?>> ListWidget.ListEntry getEnumCycleButton(ConfigOption<T> option) {
        ConfigValueUpdater<Enum> setter = new ConfigValueUpdater<Enum>();
        Enum[] values = (Enum[])option.getType().getEnumConstants();
        Component[] translations = new Component[values.length];
        for (int i = 0; i < values.length; ++i) {
            translations[i] = Component.translatable((String)"config.%s.enum.%s.%s".formatted("ayame_paperdoll", option.getType().getSimpleName(), values[i].name()));
        }
        ConfigButton btn = new ConfigButton(150, 20, translations[((Enum)option.getValue()).ordinal()], self -> setter.setValue(values[(((Enum)option.getValue()).ordinal() + 1) % values.length]));
        Button reset = ConfigWidgetRegistry.getResetButton(option, setter);
        setter.setUpdateHandler(val -> {
            option.setValue(val);
            btn.setMessage(translations[((Enum)option.getValue()).ordinal()]);
            reset.active = !option.isValueDefault();
        });
        return new ConfigEntry(option.getName(), Tooltip.create((Component)option.getDescription()), (AbstractWidget)btn, reset);
    }

    public <T, U extends ConfigOption<T>> Optional<ListWidget.ListEntry> getConfigEntry(U option) {
        for (OptionWidgetEntry<?, ?> entry : this.defaultWidgets) {
            if (!entry.type.isAssignableFrom(option.getType())) continue;
            OptionWidgetEntry<?, ?> entryCast = entry;
            return Optional.of(entryCast.widgetProvider.apply(option));
        }
        return Optional.empty();
    }

    record OptionWidgetEntry<T, U extends ConfigOption<T>>(Class<T> type, Class<U> optionType, Function<U, ListWidget.ListEntry> widgetProvider) {
    }

    public static class ConfigButton
    extends Button
    implements Retextured {
        public ConfigButton(int width, int height, Component message, Button.OnPress action) {
            super(0, 0, width, height, message, action, DEFAULT_NARRATION);
        }

        @Override
        public ResourceLocation retexture(ResourceLocation oldTexture) {
            return AyamePaperDoll.path(oldTexture.getPath());
        }
    }

    private static class ConfigValueUpdater<T> {
        private Consumer<T> updateHandler = null;
        private boolean preventUpdates = false;

        private ConfigValueUpdater() {
        }

        public void setUpdateHandler(Consumer<T> updateHandler) {
            this.updateHandler = updateHandler;
        }

        public void setValue(T newValue) {
            if (this.preventUpdates || this.updateHandler == null) {
                return;
            }
            this.preventUpdates = true;
            this.updateHandler.accept(newValue);
            this.preventUpdates = false;
        }
    }

    private static class ConfigTextField
    extends EditBox
    implements Retextured {
        public ConfigTextField(int width, int height) {
            super(Minecraft.getInstance().font, width, height, (Component)Component.empty());
        }

        @Override
        public ResourceLocation retexture(ResourceLocation oldTexture) {
            return AyamePaperDoll.path(oldTexture.getPath());
        }
    }

    private static class ConfigEntry
    extends ListWidget.ListEntry {
        private static final int LABEL_Y_OFFSET = 7;
        private static final int GAP_WIDTH = 10;
        private final List<AbstractWidget> children;
        private final StringWidget label;
        private final AbstractWidget widget;
        private final Button reset;

        private ConfigEntry(Component label, Tooltip labelTooltip, AbstractWidget widget, Button resetButton) {
            StringWidget labelWidget = new StringWidget(label, Minecraft.getInstance().font);
            labelWidget.setTooltip(labelTooltip);
            this.label = labelWidget;
            this.widget = widget;
            this.reset = resetButton;
            this.children = ImmutableList.of((Object)this.widget, (Object)this.reset);
        }

        public List<? extends NarratableEntry> narratables() {
            return this.children;
        }

        public List<? extends GuiEventListener> children() {
            return this.children;
        }

        public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.label.setPosition(this.getContentX(), this.getContentY() + 7);
            this.reset.setPosition(this.getContentX() + this.getContentWidth() - this.reset.getWidth(), this.getContentY());
            this.widget.setPosition(this.getContentX() + this.getContentWidth() - this.reset.getWidth() - this.widget.getWidth() - 10, this.getContentY());
            this.widget.render(guiGraphics, mouseX, mouseY, tickDelta);
            this.reset.render(guiGraphics, mouseX, mouseY, tickDelta);
            this.label.render(guiGraphics, mouseX, mouseY, tickDelta);
        }
    }

    private static class ConfigSlider
    extends AbstractSliderButton
    implements Retextured {
        @NotNull
        private final Consumer<Double> changeListener;
        @NotNull
        private final Function<Double, Component> messageProvider;

        public ConfigSlider(int width, int height, double value, @NotNull Consumer<Double> changeListener, @NotNull Function<Double, Component> messageProvider) {
            super(0, 0, width, height, (Component)Component.empty(), value);
            this.changeListener = changeListener;
            this.messageProvider = messageProvider;
            this.updateMessage();
        }

        @Override
        public ResourceLocation retexture(ResourceLocation oldTexture) {
            return AyamePaperDoll.path(oldTexture.getPath());
        }

        protected void applyValue() {
            this.changeListener.accept(this.value);
        }

        protected void updateMessage() {
            this.setMessage(this.messageProvider.apply(this.value));
        }

        public void setValueNoEvent(double value) {
            this.value = value;
            this.updateMessage();
        }
    }
}

