/*
 * Decompiled with CFR 0.152.
 */
package org.ayamemc.ayamepaperdoll.config.model;

import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.ayamemc.ayamepaperdoll.AyamePaperDoll;
import org.ayamemc.ayamepaperdoll.config.model.ConfigOption;
import org.jetbrains.annotations.NotNull;

public class SimpleOption<T>
implements ConfigOption<T> {
    @NotNull
    private final T defaultValue;
    private final ResourceLocation category;
    private final ResourceLocation id;
    private final Component name;
    private final Component description;
    private final Class<T> type;
    @NotNull
    private T value;

    public SimpleOption(ResourceLocation category, ResourceLocation id, @NotNull T defaultValue) {
        this.category = category;
        this.id = id;
        this.name = Component.translatable((String)"config.%s.option.%s".formatted(id.getNamespace(), id.getPath()));
        this.description = Component.translatable((String)"config.%s.option.%s.desc".formatted(id.getNamespace(), id.getPath()));
        this.defaultValue = defaultValue;
        this.value = this.defaultValue;
        this.type = defaultValue.getClass();
    }

    @Override
    public T validate(T oldValue, T newValue) {
        if (newValue == null) {
            AyamePaperDoll.LOGGER.warn("The new value for option {} is null, reset to the old value", (Object)this.getId().toString());
            return oldValue;
        }
        return newValue;
    }

    @Override
    public boolean setValue(T value) {
        T validated = this.validate(this.value, value);
        if (!Objects.equals(value, this.value)) {
            this.value = validated;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public T getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public ResourceLocation getCategory() {
        return this.category;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public Component getName() {
        return this.name;
    }

    @Override
    public Component getDescription() {
        return this.description;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }
}

