/*
 * Decompiled with CFR 0.152.
 */
package org.ayamemc.ayamepaperdoll.hud;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.geom.Rectangle2D;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import org.ayamemc.ayamepaperdoll.AyamePaperDoll;
import org.ayamemc.ayamepaperdoll.config.Configs;
import org.ayamemc.ayamepaperdoll.hud.DataBackup;
import org.ayamemc.ayamepaperdoll.mixininterface.GuiGraphicsInterface;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class PaperDollRenderer {
    private static final List<DataBackup.DataBackupEntry<LivingEntity, ?>> LIVINGENTITY_BACKUP_ENTRIES = ImmutableList.of(new DataBackup.DataBackupEntry<LivingEntity, Pose>(Entity::getPose, Entity::setPose), new DataBackup.DataBackupEntry<LivingEntity, Boolean>(Entity::isCrouching, (e, flag) -> {
        if (e instanceof LocalPlayer) {
            LocalPlayer player = (LocalPlayer)e;
            player.crouching = flag;
        }
    }), new DataBackup.DataBackupEntry<LivingEntity, Float>(e -> Float.valueOf(e.swimAmount), (e, pitch) -> {
        e.swimAmount = pitch.floatValue();
    }), new DataBackup.DataBackupEntry<LivingEntity, Float>(e -> Float.valueOf(e.swimAmountO), (e, pitch) -> {
        e.swimAmountO = pitch.floatValue();
    }), new DataBackup.DataBackupEntry<LivingEntity, Boolean>(LivingEntity::isFallFlying, (e, flag) -> e.setSharedFlag(7, flag.booleanValue())), new DataBackup.DataBackupEntry<LivingEntity, Integer>(LivingEntity::getFallFlyingTicks, (e, ticks) -> {
        e.fallFlyTicks = ticks;
    }), new DataBackup.DataBackupEntry<LivingEntity, Entity>(Entity::getVehicle, (e, vehicle) -> {
        e.vehicle = vehicle;
    }), new DataBackup.DataBackupEntry<LivingEntity, Float>(e -> Float.valueOf(e.yBodyRotO), (e, yaw) -> {
        e.yBodyRotO = yaw.floatValue();
    }), new DataBackup.DataBackupEntry<LivingEntity, Float>(e -> Float.valueOf(e.yBodyRot), (e, yaw) -> {
        e.yBodyRot = yaw.floatValue();
    }), new DataBackup.DataBackupEntry<LivingEntity, Float>(e -> Float.valueOf(e.yHeadRotO), (e, yaw) -> {
        e.yHeadRotO = yaw.floatValue();
    }), new DataBackup.DataBackupEntry<LivingEntity, Float>(e -> Float.valueOf(e.yHeadRot), (e, yaw) -> {
        e.yHeadRot = yaw.floatValue();
    }), new DataBackup.DataBackupEntry<LivingEntity, Float>(e -> Float.valueOf(e.xRotO), (e, pitch) -> {
        e.xRotO = pitch.floatValue();
    }), (Object[])new DataBackup.DataBackupEntry[]{new DataBackup.DataBackupEntry<LivingEntity, Float>(Entity::getXRot, Entity::setXRot), new DataBackup.DataBackupEntry<LivingEntity, Float>(e -> Float.valueOf(e.attackAnim), (e, prog) -> {
        e.attackAnim = prog.floatValue();
    }), new DataBackup.DataBackupEntry<LivingEntity, Float>(e -> Float.valueOf(e.oAttackAnim), (e, prog) -> {
        e.oAttackAnim = prog.floatValue();
    }), new DataBackup.DataBackupEntry<LivingEntity, Integer>(e -> e.hurtTime, (e, time) -> {
        e.hurtTime = time;
    }), new DataBackup.DataBackupEntry<LivingEntity, Integer>(Entity::getRemainingFireTicks, Entity::setRemainingFireTicks), new DataBackup.DataBackupEntry<LivingEntity, Boolean>(e -> e.getSharedFlag(0), (e, flag) -> e.setSharedFlag(0, flag.booleanValue()))});
    private static final PaperDollRenderer instance = new PaperDollRenderer();
    private final Minecraft minecraft = Minecraft.getInstance();
    private Rectangle2D.Double currentRenderBounds;

    private PaperDollRenderer() {
    }

    public static PaperDollRenderer getInstance() {
        return instance;
    }

    private static int getLight(Entity entity, float tickDelta) {
        if (AyamePaperDoll.CONFIGS.useWorldLight.getValue().booleanValue()) {
            Level world = entity.level();
            int blockLight = world.getBrightness(LightLayer.BLOCK, BlockPos.containing((Position)entity.getEyePosition(tickDelta)));
            int skyLight = world.getBrightness(LightLayer.SKY, BlockPos.containing((Position)entity.getEyePosition(tickDelta)));
            int min = (Integer)AyamePaperDoll.CONFIGS.worldLightMin.getValue();
            blockLight = Mth.clamp((int)blockLight, (int)min, (int)15);
            skyLight = Mth.clamp((int)skyLight, (int)min, (int)15);
            return LightTexture.pack((int)blockLight, (int)skyLight);
        }
        return LightTexture.pack((int)15, (int)15);
    }

    private static float getFallFlyingLeaning(LivingEntity entity, float partialTicks) {
        float ticks = partialTicks + (float)entity.getFallFlyingTicks();
        return Mth.clamp((float)(ticks * ticks / 100.0f), (float)0.0f, (float)1.0f);
    }

    public static boolean shouldLockRotationYaw() {
        Configs.RotationMode rotationUnlock = AyamePaperDoll.CONFIGS.rotationMode.getValue();
        return rotationUnlock == Configs.RotationMode.LOCK;
    }

    public void render(float partialTicks, GuiGraphics guiGraphics) {
        if (this.minecraft.level == null || this.minecraft.player == null || !AyamePaperDoll.CONFIGS.displayPaperDoll.getValue().booleanValue()) {
            return;
        }
        LivingEntity targetEntity = (LivingEntity)this.minecraft.level.players().stream().filter(p -> p.getName().getString().equals(AyamePaperDoll.CONFIGS.playerName.getValue())).findFirst().orElse((AbstractClientPlayer)this.minecraft.player);
        if (AyamePaperDoll.CONFIGS.spectatorAutoSwitch.getValue().booleanValue() && this.minecraft.player.isSpectator()) {
            Entity cameraEntity = this.minecraft.getCameraEntity();
            if (cameraEntity instanceof LivingEntity) {
                LivingEntity livingEntity;
                targetEntity = livingEntity = (LivingEntity)cameraEntity;
            } else if (cameraEntity != null) {
                return;
            }
        }
        int scaledWidth = this.minecraft.getWindow().getGuiScaledWidth();
        int scaledHeight = this.minecraft.getWindow().getGuiScaledHeight();
        Configs.PoseOffsetMethod poseOffsetMethod = AyamePaperDoll.CONFIGS.poseOffsetMethod.getValue();
        DataBackup<LivingEntity> backup = new DataBackup<LivingEntity>(targetEntity, LIVINGENTITY_BACKUP_ENTRIES);
        backup.save();
        this.transformEntity(targetEntity, partialTicks, poseOffsetMethod == Configs.PoseOffsetMethod.FORCE_STANDING);
        DataBackup<LivingEntity> vehicleBackup = null;
        if (AyamePaperDoll.CONFIGS.renderVehicle.getValue().booleanValue() && poseOffsetMethod != Configs.PoseOffsetMethod.FORCE_STANDING && targetEntity.isPassenger()) {
            Entity vehicle = targetEntity.getVehicle();
            assert (vehicle != null);
            float yawLerped = vehicle.getViewYRot(partialTicks);
            if (vehicle instanceof LivingEntity) {
                LivingEntity livingVehicle = (LivingEntity)vehicle;
                vehicleBackup = new DataBackup<LivingEntity>(livingVehicle, LIVINGENTITY_BACKUP_ENTRIES);
                vehicleBackup.save();
                this.transformEntity(livingVehicle, partialTicks, false);
            }
            this.performRendering(vehicle, (Double)AyamePaperDoll.CONFIGS.offsetX.getValue() * (double)scaledWidth, (Double)AyamePaperDoll.CONFIGS.offsetY.getValue() * (double)scaledHeight, (Double)AyamePaperDoll.CONFIGS.size.getValue() * (double)scaledHeight, true, vehicle.getPosition(partialTicks).subtract(targetEntity.getPosition(partialTicks)).yRot((float)Math.toRadians(yawLerped + 180.0f)).toVector3f(), (Double)AyamePaperDoll.CONFIGS.lightDegree.getValue(), partialTicks, guiGraphics);
        }
        this.performRendering((Entity)targetEntity, (Double)AyamePaperDoll.CONFIGS.offsetX.getValue() * (double)scaledWidth, (Double)AyamePaperDoll.CONFIGS.offsetY.getValue() * (double)scaledHeight, (Double)AyamePaperDoll.CONFIGS.size.getValue() * (double)scaledHeight, false, new Vector3f(0.0f, (float)this.getPoseOffsetY(targetEntity, partialTicks, poseOffsetMethod), 0.0f), (Double)AyamePaperDoll.CONFIGS.lightDegree.getValue(), partialTicks, guiGraphics);
        if (vehicleBackup != null) {
            vehicleBackup.restore();
        }
        backup.restore();
    }

    private double getPoseOffsetY(LivingEntity targetEntity, float partialTicks, Configs.PoseOffsetMethod poseOffsetMethod) {
        if (poseOffsetMethod == Configs.PoseOffsetMethod.AUTO) {
            float defaultPlayerEyeHeight = 1.62f;
            float defaultPlayerSwimmingBBHeight = 0.6f;
            float eyeHeightRatio = 0.85f;
            if (targetEntity.isFallFlying()) {
                return (1.62f - targetEntity.getEyeHeight()) * PaperDollRenderer.getFallFlyingLeaning(targetEntity, partialTicks);
            }
            if (targetEntity.isAutoSpinAttack()) {
                return 1.2119999647140502;
            }
            if (targetEntity.isVisuallySwimming()) {
                return targetEntity.getSwimAmount(partialTicks) <= 0.0f ? 0.0 : (double)(1.62f - targetEntity.getEyeHeight());
            }
            if (!targetEntity.isVisuallySwimming() && targetEntity.getSwimAmount(partialTicks) > 0.0f) {
                return 1.1864999622106551 * (double)targetEntity.getSwimAmount(partialTicks);
            }
            return 1.62f - targetEntity.getEyeHeight();
        }
        if (poseOffsetMethod == Configs.PoseOffsetMethod.MANUAL) {
            if (targetEntity.isFallFlying()) {
                return (Double)AyamePaperDoll.CONFIGS.elytraOffsetY.getValue() * (double)PaperDollRenderer.getFallFlyingLeaning(targetEntity, partialTicks);
            }
            if (targetEntity.isVisuallySwimming() && targetEntity.getSwimAmount(partialTicks) > 0.0f || targetEntity.isAutoSpinAttack()) {
                return (Double)AyamePaperDoll.CONFIGS.swimCrawlOffsetY.getValue();
            }
            if (!targetEntity.isVisuallySwimming() && targetEntity.getSwimAmount(partialTicks) > 0.0f) {
                return (Double)AyamePaperDoll.CONFIGS.swimCrawlOffsetY.getValue() * (double)targetEntity.getSwimAmount(partialTicks);
            }
            if (targetEntity.isCrouching()) {
                return (Double)AyamePaperDoll.CONFIGS.sneakOffsetY.getValue();
            }
        }
        return 0.0;
    }

    private void transformEntity(LivingEntity targetEntity, float partialTicks, boolean forceStanding) {
        if (!(targetEntity.isSwimming() || targetEntity.isFallFlying() || targetEntity.isVisuallyCrawling())) {
            targetEntity.setPose(targetEntity.isCrouching() ? Pose.CROUCHING : Pose.STANDING);
        }
        if (forceStanding) {
            if (targetEntity instanceof LocalPlayer) {
                LocalPlayer player = (LocalPlayer)targetEntity;
                player.crouching = false;
            }
            targetEntity.vehicle = null;
            targetEntity.swimAmount = 0.0f;
            targetEntity.swimAmountO = 0.0f;
            targetEntity.setSharedFlag(7, false);
            targetEntity.fallFlyTicks = 0;
        }
        float headLerp = Mth.lerp((float)partialTicks, (float)targetEntity.yHeadRotO, (float)targetEntity.yHeadRot);
        double headYaw = (Double)AyamePaperDoll.CONFIGS.headYaw.getValue();
        double headYawRange = (Double)AyamePaperDoll.CONFIGS.headYawRange.getValue();
        double bodyYaw = (Double)AyamePaperDoll.CONFIGS.bodyYaw.getValue();
        double bodyYawRange = (Double)AyamePaperDoll.CONFIGS.bodyYawRange.getValue();
        double pitch = (Double)AyamePaperDoll.CONFIGS.pitch.getValue();
        double pitchRange = (Double)AyamePaperDoll.CONFIGS.pitchRange.getValue();
        float headClamp = (float)Mth.clamp((double)headLerp, (double)(headYaw - headYawRange), (double)(headYaw + headYawRange));
        float bodyLerp = Mth.lerp((float)partialTicks, (float)targetEntity.yBodyRotO, (float)targetEntity.yBodyRot);
        float diff = headLerp - bodyLerp;
        float bodyClamp = (float)Mth.clamp((double)Mth.wrapDegrees((float)(headClamp - diff)), (double)(bodyYaw - bodyYawRange), (double)(bodyYaw + bodyYawRange));
        float pitchClamp = (float)(Mth.clamp((double)Mth.lerp((float)partialTicks, (float)targetEntity.xRotO, (float)targetEntity.getXRot()), (double)(-pitchRange), (double)pitchRange) + pitch);
        Configs.RotationMode rotationMode = AyamePaperDoll.CONFIGS.rotationMode.getValue();
        if (rotationMode == Configs.RotationMode.LOCK) {
            targetEntity.yHeadRot = targetEntity.yHeadRotO = 180.0f - headClamp;
        }
        if (rotationMode == Configs.RotationMode.LOCK) {
            targetEntity.yBodyRot = targetEntity.yBodyRotO = 180.0f - bodyClamp;
        }
        targetEntity.xRotO = pitchClamp;
        targetEntity.setXRot(targetEntity.xRotO);
        if (!AyamePaperDoll.CONFIGS.swingHands.getValue().booleanValue()) {
            targetEntity.attackAnim = 0.0f;
            targetEntity.oAttackAnim = 0.0f;
        }
        if (!AyamePaperDoll.CONFIGS.hurtFlash.getValue().booleanValue()) {
            targetEntity.hurtTime = 0;
        }
        targetEntity.setRemainingFireTicks(0);
        targetEntity.setSharedFlag(0, false);
    }

    private void performRendering(Entity targetEntity, double posX, double posY, double size, boolean boat, Vector3f offset, double lightDegree, float partialTicks, GuiGraphics guiGraphics) {
        EntityRenderDispatcher entityRenderDispatcher = this.minecraft.getEntityRenderDispatcher();
        EntityRenderer entityRenderer = entityRenderDispatcher.getRenderer(targetEntity);
        EntityRenderState state = entityRenderer.createRenderState(targetEntity, partialTicks);
        state.lightCoords = PaperDollRenderer.getLight(targetEntity, partialTicks);
        state.hitboxesRenderState = null;
        state.shadowPieces.clear();
        state.outlineColor = 0;
        Quaternionf pose = new Quaternionf().rotateZ((float)Math.PI).rotateY((float)Math.PI);
        Quaternionf configRot = new Quaternionf().rotateXYZ((float)Math.toRadians((Double)AyamePaperDoll.CONFIGS.rotationX.getValue()), (float)Math.toRadians((Double)AyamePaperDoll.CONFIGS.rotationY.getValue()), (float)Math.toRadians((Double)AyamePaperDoll.CONFIGS.rotationZ.getValue()));
        pose.mul((Quaternionfc)configRot).rotateY((float)Math.toRadians(lightDegree + 180.0));
        if (targetEntity instanceof Boat) {
            pose.rotateY((float)Math.toRadians(180.0));
        }
        ((GuiGraphicsInterface)guiGraphics).submitModeRenderState(state, offset, pose, new Quaternionf((Quaternionfc)configRot).conjugate(), (int)posX, (int)posY, (float)size, boat);
    }

    public Rectangle2D.Double getRenderBounds() {
        return this.currentRenderBounds;
    }

    public static class PaperDollPoseStack
    extends PoseStack
    implements LockedPaperDoll {
    }

    public static interface LockedPaperDoll {
    }
}

