/*
 *     Highly configurable PaperDoll mod. Forked from Extra Player Renderer.
 *     Copyright (C) 2024-2025  LucunJi(Original author), HappyRespawnanchor
 *
 *     This file is part of Ayame PaperDoll.
 *
 *     Ayame PaperDoll is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Lesser General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     Ayame PaperDoll is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU Lesser General Public License for more details.
 *
 *     You should have received a copy of the GNU Lesser General Public License
 *     along with Ayame PaperDoll.  If not, see <https://www.gnu.org/licenses/>.
 */

package org.ayamemc.ayamepaperdoll;

import org.ayamemc.ayamepaperdoll.config.Configs;
import org.ayamemc.ayamepaperdoll.config.persistence.ConfigPersistence;
import org.ayamemc.ayamepaperdoll.config.persistence.GsonConfigPersistence;
import org.lwjgl.glfw.GLFW;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.nio.file.Path;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_3675;

public final class AyamePaperDoll {
    public static final String MOD_ID = "ayame_paperdoll";
    public static final String MOD_NAME = "Ayame PaperDoll";
    public static final Logger LOGGER = LoggerFactory.getLogger(MOD_NAME);
    public static boolean identifier = false;
    public static final class_304.class_11900 CATEGORY = class_304.class_11900.method_74698(path("keys"));
    public static final class_304 SHOW_PAPERDOLL_KEY = new class_304(
            "key.%s.showPaperDoll".formatted(MOD_ID),
            class_3675.class_307.field_1668,
            GLFW.GLFW_KEY_F8,
            CATEGORY);
    public static final class_304 OPEN_CONFIG_GUI = new class_304(
            "key.%s.openConfigGui".formatted(MOD_ID),
            class_3675.class_307.field_1668,
            class_3675.field_16237.method_1444(),
            CATEGORY);

    public static final Configs CONFIGS = new Configs();
    public static final ConfigPersistence CONFIG_PERSISTENCE = new GsonConfigPersistence(Path.of("config/" + MOD_ID + "_v0.json"));

    public static class_2960 path(String path) {
        return class_2960.method_60655(MOD_ID, path);
    }

    public static void init() {
        // Write common init code here.
        CONFIG_PERSISTENCE.load(AyamePaperDoll.CONFIGS.getOptions());
    }
}
