/*
 *     Highly configurable PaperDoll mod. Forked from Extra Player Renderer.
 *     Copyright (C) 2024-2025  LucunJi(Original author), HappyRespawnanchor
 *
 *     This file is part of Ayame PaperDoll.
 *
 *     Ayame PaperDoll is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Lesser General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     Ayame PaperDoll is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU Lesser General Public License for more details.
 *
 *     You should have received a copy of the GNU Lesser General Public License
 *     along with Ayame PaperDoll.  If not, see <https://www.gnu.org/licenses/>.
 */

package org.ayamemc.ayamepaperdoll.config;

import org.apache.commons.lang3.ArrayUtils;
import org.ayamemc.ayamepaperdoll.AyamePaperDoll;
import org.ayamemc.ayamepaperdoll.CommonInterfaceInstances;
import org.ayamemc.ayamepaperdoll.config.ConfigWidgetRegistry.ConfigButton;
import org.ayamemc.ayamepaperdoll.config.model.ConfigOption;
import org.ayamemc.ayamepaperdoll.config.view.ListWidget;
import org.ayamemc.ayamepaperdoll.config.view.Tab;
import org.ayamemc.ayamepaperdoll.hud.PaperDollRenderer;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_11908;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_6379;
import net.minecraft.class_7842;
import net.minecraft.class_7919;
import net.minecraft.class_8088;
import net.minecraft.class_8089;


public class ConfigScreen extends class_437 {
    private static final int TAB_BUTTON_HEIGHT = 24;
    private static final int ENTRY_HEIGHT = 30;
    private static final int LIST_WIDTH_OFFSET = -50;

    private final class_437 lastScreen;

    private final PaperDollRenderer previewHud;
    private final class_8088 tabManager;
    private final List<ListWidget> listWidgets;
    private final List<? extends ConfigOption<?>> options;
    private Tab[] tabs;
    private class_8089 tabNav;

    public ConfigScreen(class_437 lastScreen, List<? extends ConfigOption<?>> options) {
        super(class_2561.method_30163("Config Screen"));

        // 确保 lastScreen 是非 ConfigScreen 的实例
        while (lastScreen instanceof ConfigScreen configScreen) {
            lastScreen = configScreen.lastScreen;
        }

        this.lastScreen = lastScreen;
        this.previewHud = PaperDollRenderer.getInstance();
        this.tabManager = new class_8088(this::method_37063, this::method_37066);
        this.options = options;
        this.listWidgets = new ArrayList<>();
    }

    @Override
    protected void method_25426() {
        this.tabs = generateTabs();
        this.method_37063(this.tabNav = class_8089
                .method_48623(this.tabManager, this.field_22789)
                .method_48631(tabs).method_48627());

        int tabIdx = AyamePaperDoll.CONFIGS.lastConfigTabIdx.getValue();
        if (tabIdx < 0 || tabIdx >= tabs.length)
            AyamePaperDoll.CONFIGS.lastConfigTabIdx.setValue(tabIdx = 0); // will be saved when screen closes
        this.tabNav.method_48987(tabIdx, false);
        this.method_48640();
    }

    private Tab[] generateTabs() {
        var tabs = new ArrayList<Tab>();
        var categoryLists = new HashMap<class_2960, ListWidget>();
        for (var option : options) {
            if (option.getCategory().equals(Configs.HIDDEN_CATEGORY)) continue;
            var configEntryOptioal = ConfigWidgetRegistry.DEFAULT.getConfigEntry(option);
            if (configEntryOptioal.isEmpty()) {
                AyamePaperDoll.LOGGER.error("Could not find widget for option {}", option.getId());
                continue;
            }
            //noinspection DataFlowIssue
            var label = new class_7842(option.getName(), this.field_22787.field_1772);
            label.method_47400(class_7919.method_47407(option.getDescription()));

            var category = option.getCategory();
            if (!categoryLists.containsKey(category)) {
                var tab = new Tab(class_2561.method_43471("config.%s.category.%s".formatted(category.method_12836(), category.method_12832())));
                var list = new ListWidget(this.field_22789, this.field_22790 - TAB_BUTTON_HEIGHT, TAB_BUTTON_HEIGHT, ENTRY_HEIGHT);
                this.listWidgets.add(list);
                tab.addChild(list);
                tabs.add(tab);
                categoryLists.put(category, list);
            }
            categoryLists.get(category).addEntry(configEntryOptioal.get());

            if (option.getId().equals(AyamePaperDoll.path("display_paperdoll"))) {
                categoryLists.get(category).addEntry(this.getPresetsConfigEntry());
            }
            if (option.getId().equals(AyamePaperDoll.path("display_paperdoll"))) {
                categoryLists.get(category).addEntry(this.getVisualConfigEditorLabelEntry());
            }
        }

        if (tabs.isEmpty()) tabs.add(new Tab(class_2561.method_30163("")));
        return tabs.toArray(Tab[]::new);
    }

    @Override
    protected void method_48640() {
        if (this.tabNav == null) return;

        this.tabNav.method_48618(this.field_22789);
        this.tabNav.method_49613();
        for (var listWidget : this.listWidgets) {
            listWidget.method_55445(this.field_22789, this.field_22790 - TAB_BUTTON_HEIGHT);
            listWidget.setRowWidth(this.field_22789 + LIST_WIDTH_OFFSET);
        }
    }

    @Override
    public void method_25419() {
        // -1 will become 0 after validation
        AyamePaperDoll.CONFIGS.lastConfigTabIdx.setValue(ArrayUtils.indexOf(tabs, tabManager.method_48614()));

        //noinspection DataFlowIssue
        this.field_22787.method_1507(lastScreen);
        AyamePaperDoll.CONFIG_PERSISTENCE.save(AyamePaperDoll.CONFIGS.getOptions());
    }

    @SuppressWarnings("DataFlowIssue")
    @Override
    protected void method_57734(class_332 guiGraphics) {
        if (field_22787.field_1687 == null || !AyamePaperDoll.CONFIGS.disableConfigScreenBlur.getValue()) {
            super.method_57734(guiGraphics);
        }
    }

    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        // only render when the screen is opened in game
        //noinspection DataFlowIssue
        if (this.field_22787.field_1687 != null) {
            this.previewHud.render(this.field_22787.method_61966().method_60637(true), guiGraphics);
            // put behind GUI
            guiGraphics.method_51448().translate(0,0);
        }
        super.method_25394(guiGraphics, mouseX, mouseY, delta);
    }

    @Override
    public boolean method_25421() {
        return AyamePaperDoll.CONFIGS.pauseGameOnConfigScreen.getValue();
    }

    @Override
    public boolean method_25404(class_11908 keyEvent) {
        if (keyEvent.comp_4795() == CommonInterfaceInstances.keyHelper.getBoundKeyOf(AyamePaperDoll.OPEN_CONFIG_GUI).method_1444() && this.method_25422()) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyEvent);
    }

    private ListWidget.ListEntry getPresetsConfigEntry() {
        final int buttonWidth = 70, gap = 10, buttonHeight = 20, labelYOffset = 7;
        @SuppressWarnings("DataFlowIssue")
        var presetLabel = new class_7842(class_2561.method_43471("config.%s.option.presets".formatted(AyamePaperDoll.MOD_ID)), this.field_22787.field_1772);
        presetLabel.method_47400(class_7919.method_47407(class_2561.method_43471("config.%s.option.presets.desc".formatted(AyamePaperDoll.MOD_ID))));
        var topLeft = new ConfigWidgetRegistry.ConfigButton(buttonWidth, buttonHeight, getPresetText("top_left"), getPresetPressAction(AyamePaperDoll.CONFIGS.topLeft));
        var topRight = new ConfigWidgetRegistry.ConfigButton(buttonWidth, buttonHeight, getPresetText("top_right"), getPresetPressAction(AyamePaperDoll.CONFIGS.topRight));
        var bottomLeft = new ConfigWidgetRegistry.ConfigButton(buttonWidth, buttonHeight, getPresetText("bottom_left"), getPresetPressAction(AyamePaperDoll.CONFIGS.bottomLeft));
        var bottomRight = new ConfigWidgetRegistry.ConfigButton(buttonWidth, buttonHeight, getPresetText("bottom_right"), getPresetPressAction(AyamePaperDoll.CONFIGS.bottomRight));
        var children = List.of(presetLabel, topLeft, topRight, bottomLeft, bottomRight);
        return new ListWidget.ListEntry() {
            @Override
            public @NotNull List<? extends class_6379> method_37025() {
                return children;
            }

            @Override
            public @NotNull List<? extends class_364> method_25396() {
                return children;
            }

            @Override
            public void method_25343(class_332 context, int i, int j,boolean hovered, float tickDelta) {
                presetLabel.method_48229(method_73380(), method_73382() + labelYOffset);
                topLeft.method_48229(method_73380() + method_73387() - buttonWidth * 4 - gap * 3, method_73382());
                topRight.method_48229(method_73380() + method_73387() - buttonWidth * 3 - gap * 2, method_73382());
                bottomLeft.method_48229(method_73380() + method_73387() - buttonWidth * 2 - gap, method_73382());
                bottomRight.method_48229(method_73380() + method_73387() - buttonWidth, method_73382());

                for (class_339 child : children) child.method_25394(context, i,j, tickDelta);
            }
        };
    }

    @SuppressWarnings("DataFlowIssue")
    private ListWidget.ListEntry getVisualConfigEditorLabelEntry() {
        final int buttonWidth = 140, buttonHeight = 20;

        var visualConfigEditorButton = new ConfigWidgetRegistry.ConfigButton(buttonWidth, buttonHeight, getButtonText("visual_config_editor"),
                (button) -> field_22787.method_1507(new VisualConfigEditorScreen(this)));
        if (field_22787.field_1687 == null) {
            visualConfigEditorButton.field_22763 = false;
            visualConfigEditorButton.method_47400(class_7919.method_47407(class_2561.method_43471("config.%s.option.visual_config_editor_not_available.desc".formatted(AyamePaperDoll.MOD_ID))));
        } else {
            visualConfigEditorButton.method_47400(class_7919.method_47407(class_2561.method_43471("config.%s.option.visual_config_editor.desc".formatted(AyamePaperDoll.MOD_ID))));
        }

        var children = List.of(visualConfigEditorButton);
        return new ListWidget.ListEntry() {
            @Override
            public void method_25343(class_332 guiGraphics, int i, int j, boolean bl, float f) {
                visualConfigEditorButton.method_48229((method_73380()+ method_73387() - buttonWidth) / 2, method_73382());

                for (class_339 child : children) child.method_25394(guiGraphics, i, j, f);
            }

            @Override
            public @NotNull List<? extends class_6379> method_37025() {
                return children;
            }

            @Override
            public @NotNull List<? extends class_364> method_25396() {
                return children;
            }
        };
    }

    private class_2561 getPresetText(String text) {
        return class_2561.method_43471("config.%s.presets.%s".formatted(AyamePaperDoll.MOD_ID, text));
    }

    @SuppressWarnings("SameParameterValue")
    private class_2561 getButtonText(String text) {
        return class_2561.method_43471("config.%s.button.%s".formatted(AyamePaperDoll.MOD_ID, text));
    }


    private class_4185.class_4241 getPresetPressAction(Configs.Presets presets) {
        return ignored -> {
            presets.load();
            // clear everything and re-init, AVOID MEMORY LEAK
            int tabIdx = ArrayUtils.indexOf(tabs, tabManager.method_48614());
            this.method_37067();
            this.listWidgets.clear();
            this.method_25426();
            this.tabNav.method_48987(tabIdx, false);
        };
    }
}
