/*
 *     Highly configurable PaperDoll mod. Forked from Extra Player Renderer.
 *     Copyright (C) 2024-2025  LucunJi(Original author), HappyRespawnanchor
 *
 *     This file is part of Ayame PaperDoll.
 *
 *     Ayame PaperDoll is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Lesser General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     Ayame PaperDoll is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU Lesser General Public License for more details.
 *
 *     You should have received a copy of the GNU Lesser General Public License
 *     along with Ayame PaperDoll.  If not, see <https://www.gnu.org/licenses/>.
 */

package org.ayamemc.ayamepaperdoll.config;

import org.ayamemc.ayamepaperdoll.hud.PaperDollRenderer;
import org.lwjgl.glfw.GLFW;

import static org.ayamemc.ayamepaperdoll.AyamePaperDoll.CONFIGS;

import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;

public class VisualConfigEditorScreen extends class_437 {
    private static final int LINE_COLOR = 0xA6_FFFFFF;
    private static final int BORDER_MARGIN = 10;
    private final class_437 lastScreen;
    private final PaperDollRenderer paperDollRenderer = PaperDollRenderer.getInstance();

    protected VisualConfigEditorScreen(class_437 lastScreen) {
        super(class_2561.method_43473());
        this.lastScreen = lastScreen;
    }

    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        // 十字的水平线，- 1能居中点，大概
        guiGraphics.method_51738(0, field_22789, (field_22790 / 2) - 1, LINE_COLOR);
        // 十字的垂直线
        guiGraphics.method_51742((field_22789 / 2), -1, field_22790, LINE_COLOR);

        // 底下的线
        guiGraphics.method_51738(0, field_22789, (field_22790 - BORDER_MARGIN), LINE_COLOR);
        // 顶上的线
        guiGraphics.method_51738(0, field_22789, BORDER_MARGIN, LINE_COLOR);
        // 左边的线
        guiGraphics.method_51742((field_22789 - BORDER_MARGIN), -1, field_22790, LINE_COLOR);
        // 右边的线
        guiGraphics.method_51742(BORDER_MARGIN, -1, field_22790, LINE_COLOR);
        paperDollRenderer.render(partialTick, guiGraphics);
    }


    @SuppressWarnings("DataFlowIssue")
    @Override
    public void method_25419() {
        // 通过构造新配置屏幕刷新设置中的值

        if (lastScreen instanceof ConfigScreen configScreen) {
            configScreen.method_25419();
            this.field_22787.method_1507(new ConfigScreen(lastScreen, CONFIGS.getOptions()));
        } else {
            this.field_22787.method_1507(lastScreen);
        }
    }

    @Override
    public boolean method_25403(class_11909 mouseButtonEvent, double deltaX, double deltaY) {
        boolean onDrag = false;
        if (mouseButtonEvent.method_74245() == GLFW.GLFW_MOUSE_BUTTON_LEFT) {
            final double newOffsetX = CONFIGS.offsetX.getValue() + (deltaX * 0.0015);
            final double newOffsetY = CONFIGS.offsetY.getValue() + (deltaY * 0.0015);
            if (newOffsetX < CONFIGS.offsetX.getMax() && newOffsetY > CONFIGS.offsetY.getMin()) {
                CONFIGS.offsetX.setValue(newOffsetX);
            }
            if (newOffsetY < CONFIGS.offsetY.getMax() && newOffsetX > CONFIGS.offsetX.getMin()) {
                CONFIGS.offsetY.setValue(newOffsetY);
            }
            onDrag = true;
        }
        if (mouseButtonEvent.method_74245() == GLFW.GLFW_MOUSE_BUTTON_RIGHT) {
            final double newRotationY = CONFIGS.rotationY.getValue() + deltaX;
            if (newRotationY < CONFIGS.rotationY.getMax() && newRotationY > CONFIGS.rotationY.getMin()) {
                CONFIGS.rotationY.setValue(newRotationY);
            }
            onDrag = true;
        }
        return onDrag;
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (scrollY != 0) {
            final double newSize = CONFIGS.size.getValue() + (scrollY / 80);
            if (newSize < CONFIGS.size.getMax() && newSize > CONFIGS.size.getMin()) {
                CONFIGS.size.setValue(newSize);
            }
            return true;
        }
        return false;
    }

    @Override
    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

}
