/*
 *     Highly configurable PaperDoll mod. Forked from Extra Player Renderer.
 *     Copyright (C) 2024-2025  LucunJi(Original author), HappyRespawnanchor
 *
 *     This file is part of Ayame PaperDoll.
 *
 *     Ayame PaperDoll is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Lesser General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     Ayame PaperDoll is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU Lesser General Public License for more details.
 *
 *     You should have received a copy of the GNU Lesser General Public License
 *     along with Ayame PaperDoll.  If not, see <https://www.gnu.org/licenses/>.
 */

package org.ayamemc.ayamepaperdoll.config.model;

import org.ayamemc.ayamepaperdoll.AyamePaperDoll;
import org.jetbrains.annotations.NotNull;

import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

/**
 * Simplest implementation of {@link ConfigOption} with no callbacks, and only checks for non-null values.
 */
public class SimpleOption<T> implements ConfigOption<T> {
    @NotNull
    private final T defaultValue;
    private final class_2960 category;
    private final class_2960 id;
    private final class_2561 name;
    private final class_2561 description;
    private final Class<T> type;
    @NotNull
    private T value;

    public SimpleOption(class_2960 category, class_2960 id, @NotNull T defaultValue) {
        this.category = category;
        this.id = id;
        this.name = class_2561.method_43471("config.%s.option.%s".formatted(id.method_12836(), id.method_12832()));
        this.description = class_2561.method_43471("config.%s.option.%s.desc".formatted(id.method_12836(), id.method_12832()));
        this.value = this.defaultValue = defaultValue;
        //noinspection unchecked
        this.type = (Class<T>) defaultValue.getClass();
    }

    @Override
    public T validate(T oldValue, T newValue) {
        if (newValue == null) {
            AyamePaperDoll.LOGGER.warn("The new value for option {} is null, reset to the old value", this.getId().toString());
            return oldValue;
        }
        return newValue;
    }

    @Override
    public boolean setValue(T value) {
        var validated = this.validate(this.value, value);
        if (!Objects.equals(value, this.value)) {
            this.value = validated;
            return true;
        }
        return false;
    }

    @NotNull
    @Override
    public T getValue() {
        return value;
    }

    @NotNull
    @Override
    public T getDefaultValue() {
        return defaultValue;
    }

    @Override
    public class_2960 getCategory() {
        return category;
    }

    @Override
    public class_2960 getId() {
        return id;
    }

    @Override
    public class_2561 getName() {
        return name;
    }

    @Override
    public class_2561 getDescription() {
        return description;
    }

    @Override
    public Class<T> getType() {
        return type;
    }
}
