/*
 *     Highly configurable PaperDoll mod. Forked from Extra Player Renderer.
 *     Copyright (C) 2024-2025  LucunJi(Original author), HappyRespawnanchor
 *
 *     This file is part of Ayame PaperDoll.
 *
 *     Ayame PaperDoll is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Lesser General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     Ayame PaperDoll is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU Lesser General Public License for more details.
 *
 *     You should have received a copy of the GNU Lesser General Public License
 *     along with Ayame PaperDoll.  If not, see <https://www.gnu.org/licenses/>.
 */

package org.ayamemc.ayamepaperdoll.config.view;

import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4265;
import org.ayamemc.ayamepaperdoll.AyamePaperDoll;

public class ListWidget extends class_4265<ListWidget.ListEntry> implements Retextured {

    private int rowWidth;

    public ListWidget(int width, int height, int top, int entryHeight) {
        super(class_310.method_1551(), width, height, top, entryHeight);
        this.rowWidth = super.method_25322();
    }

    @Override
    public int addEntry(ListEntry entry) {
        return super.method_25321(entry);
    }

    @Override
    public int method_25322() {
        return this.rowWidth;
    }

    public void setRowWidth(int rowWidth) {
        this.rowWidth = rowWidth;
        for(ListEntry entry : this.method_25396()){
            entry.method_46421(method_25342());
            entry.method_73381(rowWidth);
        }
    }

    @Override
    public class_2960 retexture(class_2960 oldTexture) {
        return AyamePaperDoll.path(oldTexture.method_12832());
    }

    public static abstract class ListEntry extends class_4265.class_4266<ListEntry> {
    }
}
