/*
 *     Highly configurable PaperDoll mod. Forked from Extra Player Renderer.
 *     Copyright (C) 2024-2025  LucunJi(Original author), HappyRespawnanchor
 *
 *     This file is part of Ayame PaperDoll.
 *
 *     Ayame PaperDoll is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Lesser General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     Ayame PaperDoll is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU Lesser General Public License for more details.
 *
 *     You should have received a copy of the GNU Lesser General Public License
 *     along with Ayame PaperDoll.  If not, see <https://www.gnu.org/licenses/>.
 */

package org.ayamemc.ayamepaperdoll.config.view;

import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_8030;

/**
 * A container that does not render but provides inner widgets to
 * {@link net.minecraft.class_8089} instances
 */
public class Tab implements net.minecraft.class_8087 {
    private final class_2561 title;
    private final List<class_339> children;

    public Tab(class_2561 title) {
        this.title = title;
        this.children = new ArrayList<>();
    }

    public void addChild(class_339 child) {
        this.children.add(child);
    }

    @Override
    public @NotNull class_2561 method_48610() {
        return this.title;
    }

    @Override
    public @NotNull class_2561 method_71245() {
        return title;
    }

    /**
     * Used to load/unload children when switching tab
     */
    @Override
    public void method_48612(Consumer<class_339> consumer) {
        children.forEach(consumer);
    }

    /**
     * Seems useless here
     */
    @Override
    public void method_48611(class_8030 tabArea) {
    }
}
