/*
 *     Highly configurable PaperDoll mod. Forked from Extra Player Renderer.
 *     Copyright (C) 2024-2025  LucunJi(Original author), HappyRespawnanchor
 *
 *     This file is part of Ayame PaperDoll.
 *
 *     Ayame PaperDoll is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Lesser General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     Ayame PaperDoll is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU Lesser General Public License for more details.
 *
 *     You should have received a copy of the GNU Lesser General Public License
 *     along with Ayame PaperDoll.  If not, see <https://www.gnu.org/licenses/>.
 */

package org.ayamemc.ayamepaperdoll.handler;

import org.ayamemc.ayamepaperdoll.AyamePaperDoll;
import org.ayamemc.ayamepaperdoll.config.ConfigScreen;
import org.ayamemc.ayamepaperdoll.config.VisualConfigEditorScreen;
import org.ayamemc.ayamepaperdoll.hud.PaperDollRenderer;

import static org.ayamemc.ayamepaperdoll.AyamePaperDoll.CONFIGS;

import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4050;
import net.minecraft.class_437;
import net.minecraft.class_9779;

public class EventHandler {
    private static final class_310 minecraft = class_310.method_1551();
    private static final PaperDollRenderer paperDollRenderer = PaperDollRenderer.getInstance();
    public static class_437 lastScreen;

    @SuppressWarnings("DataFlowIssue")
    public static void renderPaperDoll(class_332 guiGraphics, class_9779 deltaTracker) {
        final class_1657 player = minecraft.field_1724;
        final class_4050 playerPose = player.method_18376();
        if (
                !minecraft.field_1690.field_1842 &&
                        !(CONFIGS.hideUnderDebug.getValue() && minecraft.field_61504.method_72776()) &&
                        (minecraft.field_1755 == null || !CONFIGS.hideOnScreenOpen.getValue()) &&
                        !(minecraft.field_1755 instanceof ConfigScreen) &&
                        !(minecraft.field_1755 instanceof VisualConfigEditorScreen) &&
                        (!(CONFIGS.visibleDuringActivity.getValue()) ||
                                (CONFIGS.visibleDuringActivity.getValue() && hasActivity(player, playerPose)))


        ) {
            paperDollRenderer.render(deltaTracker.method_60637(true), guiGraphics);
        }
    }

    private static long lastInactiveTime = 0;
    private static boolean previousState = false;

    public static boolean hasActivity(class_1657 player, class_4050 playerPose) {
        boolean currentState = playerPose == class_4050.field_18079 ||
                playerPose == class_4050.field_18081 ||
                player.method_31549().field_7479 ||
                player.method_5624() ||
                playerPose == class_4050.field_18077 ||
                player.ayame_paperdoll$isSitting();

        if (currentState) {
            // 状态为 true 时立即返回 true，并重置时间戳
            previousState = true;
            lastInactiveTime = 0;
        } else {
            // 如果状态从 true 变为 false，记录当前时间戳
            if (previousState && lastInactiveTime == 0) {
                lastInactiveTime = System.currentTimeMillis();
            }

            // 检查是否超过 1 秒延迟
            if (lastInactiveTime > 0 && System.currentTimeMillis() - lastInactiveTime >= 500) {
                previousState = false;
                lastInactiveTime = 0; // 重置时间戳
            }
        }

        return previousState;
    }


    public static void keyPressed() {
        while (AyamePaperDoll.SHOW_PAPERDOLL_KEY.method_1436()) {
            CONFIGS.displayPaperDoll.setValue(!CONFIGS.displayPaperDoll.getValue());
        }
        while (AyamePaperDoll.OPEN_CONFIG_GUI.method_1436()) {
            minecraft.method_1507(new ConfigScreen(lastScreen, AyamePaperDoll.CONFIGS.getOptions()));
        }
    }
}
