/*
 *     Highly configurable PaperDoll mod. Forked from Extra Player Renderer.
 *     Copyright (C) 2024-2025  LucunJi(Original author), HappyRespawnanchor
 *
 *     This file is part of Ayame PaperDoll.
 *
 *     Ayame PaperDoll is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Lesser General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     Ayame PaperDoll is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU Lesser General Public License for more details.
 *
 *     You should have received a copy of the GNU Lesser General Public License
 *     along with Ayame PaperDoll.  If not, see <https://www.gnu.org/licenses/>.
 */

package org.ayamemc.ayamepaperdoll.hud;

import net.minecraft.class_10017;
import net.minecraft.class_11256;
import net.minecraft.class_8030;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public record ModRenderState(
        class_10017 renderState,
        Vector3f translation,
        Quaternionf rotation,
        @Nullable Quaternionf overrideCameraAngle,
        int x0,
        int y0,
        int x1,
        int y1,
        float scale,
        boolean boat,
        @Nullable class_8030 scissorArea,
        @Nullable class_8030 bounds
) implements class_11256 {
    public ModRenderState(
            class_10017 renderState,
            Vector3f translation,
            Quaternionf rotation,
            @Nullable Quaternionf overrideCameraAngle,
            int x,
            int y,
            float scale,
            boolean boat,
            @Nullable class_8030 scissorArea
    ) {
        this(
                renderState,
                translation,
                rotation,
                overrideCameraAngle,
                x,
                y,
                x,
                y,
                scale,
                boat,
                scissorArea,
                class_11256.method_71535(x, y, x, y, scissorArea)
        );
    }
}
