/*
 *     Highly configurable PaperDoll mod. Forked from Extra Player Renderer.
 *     Copyright (C) 2024-2025  LucunJi(Original author), HappyRespawnanchor
 *
 *     This file is part of Ayame PaperDoll.
 *
 *     Ayame PaperDoll is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Lesser General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     Ayame PaperDoll is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU Lesser General Public License for more details.
 *
 *     You should have received a copy of the GNU Lesser General Public License
 *     along with Ayame PaperDoll.  If not, see <https://www.gnu.org/licenses/>.
 */

package org.ayamemc.ayamepaperdoll.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_10366;
import net.minecraft.class_11239;
import net.minecraft.class_11246;
import net.minecraft.class_11278;
import net.minecraft.class_11684;
import net.minecraft.class_12075;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_898;
import org.ayamemc.ayamepaperdoll.AyamePaperDoll;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3f;

import static org.ayamemc.ayamepaperdoll.AyamePaperDoll.CONFIGS;

public class ModRenderer extends class_11239<ModRenderState> {
    private final class_11278 projectionMatrixBuffer = new class_11278(
            "PIP - " + this.getClass().getSimpleName(), -1000.0F, 1000.0F, true
    );
    private final class_898 entityRenderDispatcher;

    public ModRenderer(class_4597.class_4598 bufferSource, class_898 entityRenderDispatcher) {
        super(bufferSource);
        this.entityRenderDispatcher = entityRenderDispatcher;
    }

    @Override
    public @NotNull Class<ModRenderState> method_70903() {
        return ModRenderState.class;
    }

    @Override
    protected void renderToTexture(ModRenderState renderState, class_4587 poseStack) {
        class_310.method_1551().field_1773.method_71114().method_71034(class_308.class_11274.field_60028);
        Vector3f vector3f = renderState.translation();
        poseStack.method_22907(renderState.rotation());
        Quaternionf quaternionf = renderState.overrideCameraAngle();
        class_11684 featurerenderdispatcher = class_310.method_1551().field_1773.method_72911();
        class_12075 camerarenderstate = new class_12075();

        if (quaternionf != null) {
            camerarenderstate.field_63081 = quaternionf.conjugate(new Quaternionf()).rotateY((float) Math.PI);
        }

        this.entityRenderDispatcher.method_72976(renderState.renderState(), camerarenderstate, vector3f.x, vector3f.y, vector3f.z, poseStack, featurerenderdispatcher.method_73003());
        featurerenderdispatcher.method_73002();
    }

    @Override
    protected @NotNull String method_70906() {
        return "ayame-paperdoll";
    }
    @Override
    public void prepare(ModRenderState renderState, class_11246 guiRenderState, int guiScale) {
        AyamePaperDoll.identifier=CONFIGS.mirrored.getValue();
        RenderSystem.setProjectionMatrix(
                this.projectionMatrixBuffer.method_71092(class_310.method_1551().method_22683().method_4486(),
                        class_310.method_1551().method_22683().method_4502()),
                class_10366.field_54954);

        class_4587 posestack = renderState.boat()?new PaperDollRenderer.PaperDollPoseStack():new class_4587();
        posestack.method_46416(renderState.comp_4122(), renderState.comp_4123(), 0.0F);
        posestack.method_22905(CONFIGS.mirrored.getValue()?-1.0f:1.0f, 1.0f, -1.0f);
        float f =  renderState.comp_4133();
        posestack.method_22905(f, f, f);
        this.renderToTexture(renderState, posestack);
        this.field_59933.method_22993();
        AyamePaperDoll.identifier=false;
    }
}