/*
 *     Highly configurable PaperDoll mod. Forked from Extra Player Renderer.
 *     Copyright (C) 2024-2025  LucunJi(Original author), HappyRespawnanchor
 *
 *     This file is part of Ayame PaperDoll.
 *
 *     Ayame PaperDoll is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Lesser General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     Ayame PaperDoll is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU Lesser General Public License for more details.
 *
 *     You should have received a copy of the GNU Lesser General Public License
 *     along with Ayame PaperDoll.  If not, see <https://www.gnu.org/licenses/>.
 */

package org.ayamemc.ayamepaperdoll.hud;

import com.google.common.collect.ImmutableList;
import org.ayamemc.ayamepaperdoll.config.Configs;
import org.ayamemc.ayamepaperdoll.config.Configs.RotationMode;
import org.ayamemc.ayamepaperdoll.hud.DataBackup.DataBackupEntry;
import org.ayamemc.ayamepaperdoll.mixininterface.GuiGraphicsInterface;
import org.joml.Quaternionf;
import org.joml.Vector3f;

import java.awt.geom.Rectangle2D;
import java.util.List;
import net.minecraft.class_10017;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_4587;
import net.minecraft.class_490;
import net.minecraft.class_746;
import net.minecraft.class_765;
import net.minecraft.class_897;
import net.minecraft.class_898;

import static org.ayamemc.ayamepaperdoll.AyamePaperDoll.CONFIGS;

import F;

public class PaperDollRenderer {
    private static final List<DataBackupEntry<class_1309, ?>> LIVINGENTITY_BACKUP_ENTRIES = ImmutableList.of(
            new DataBackupEntry<>(class_1309::method_18376, class_1309::method_18380),
            // required for player on client side
            new DataBackupEntry<>(class_1297::method_18276, (e, flag) -> {
                if (e instanceof class_746 player) player.field_23093 = flag;
            }),
            new DataBackupEntry<>(e -> e.field_6243, (e, pitch) -> e.field_6243 = pitch),
            new DataBackupEntry<>(e -> e.field_6264, (e, pitch) -> e.field_6264 = pitch),
            new DataBackupEntry<>(class_1309::method_6128, (e, flag) -> e.method_5729(7, flag)),
            new DataBackupEntry<>(class_1309::method_6003, (e, ticks) -> e.field_6239 = ticks),

            new DataBackupEntry<>(class_1309::method_5854, (e, vehicle) -> e.field_6034 = vehicle),

            new DataBackupEntry<>(e -> e.field_6220, (e, yaw) -> e.field_6220 = yaw),
            new DataBackupEntry<>(e -> e.field_6283, (e, yaw) -> e.field_6283 = yaw),
            new DataBackupEntry<>(e -> e.field_6259, (e, yaw) -> e.field_6259 = yaw),
            new DataBackupEntry<>(e -> e.field_6241, (e, yaw) -> e.field_6241 = yaw),
            new DataBackupEntry<>(e -> e.field_6004, (e, pitch) -> e.field_6004 = pitch),
            new DataBackupEntry<>(class_1309::method_36455, class_1309::method_36457),

            new DataBackupEntry<>(e -> e.field_6251, (e, prog) -> e.field_6251 = prog),
            new DataBackupEntry<>(e -> e.field_6229, (e, prog) -> e.field_6229 = prog),
            new DataBackupEntry<>(e -> e.field_6235, (e, time) -> e.field_6235 = time),
            new DataBackupEntry<>(class_1309::method_20802, class_1309::method_20803),
            new DataBackupEntry<>(e -> e.method_5795(0), (e, flag) -> e.method_5729(0, flag)) // on fire
    );
    private static final PaperDollRenderer instance = new PaperDollRenderer();
    private final class_310 minecraft = class_310.method_1551();
    private Rectangle2D.Double currentRenderBounds;

    private PaperDollRenderer() {
    }

    public static PaperDollRenderer getInstance() {
        return instance;
    }

    @SuppressWarnings("resource")
    private static int getLight(class_1297 entity, float tickDelta) {
        if (CONFIGS.useWorldLight.getValue()) {
            class_1937 world = entity.method_73183();
            int blockLight = world.method_8314(class_1944.field_9282, class_2338.method_49638(entity.method_5836(tickDelta)));
            int skyLight = world.method_8314(class_1944.field_9284, class_2338.method_49638(entity.method_5836(tickDelta)));
            int min = CONFIGS.worldLightMin.getValue();
            blockLight = class_3532.method_15340(blockLight, min, 15);
            skyLight = class_3532.method_15340(skyLight, min, 15);
            return class_765.method_23687(blockLight, skyLight);
        }
        return class_765.method_23687(15, 15);
    }

    private static float getFallFlyingLeaning(class_1309 entity, float partialTicks) {
        float ticks = partialTicks + entity.method_6003();
        return class_3532.method_15363(ticks * ticks / 100f, 0f, 1f);
    }

    public static boolean shouldLockRotationYaw() {
        final RotationMode rotationUnlock = CONFIGS.rotationMode.getValue();
        return (rotationUnlock == RotationMode.LOCK); //|| (rotationUnlock == RotationMode.SMOOTH_LOCK)*/;

    }

    // 这会导致织布机渲染问题，不要使用↓
    // follow convention in LayeredDrawer#renderInternal
    // guiGraphics.pose().translate(0, 0, 200);

    /**
     * Mimics the code in {@link class_490#method_48472}
     */
    public void render(float partialTicks, class_332 guiGraphics) {
        if (minecraft.field_1687 == null || minecraft.field_1724 == null || !CONFIGS.displayPaperDoll.getValue()) return;
        class_1309 targetEntity = minecraft.field_1687.method_18456().stream().filter(p -> p.method_5477().getString().equals(CONFIGS.playerName.getValue())).findFirst().orElse(minecraft.field_1724);
        if (CONFIGS.spectatorAutoSwitch.getValue() && minecraft.field_1724.method_7325()) {
            class_1297 cameraEntity = minecraft.method_1560();
            if (cameraEntity instanceof class_1309 livingEntity) {
                targetEntity = livingEntity;
            } else if (cameraEntity != null) {
                return;
            }
        }

        int scaledWidth = minecraft.method_22683().method_4486();
        int scaledHeight = minecraft.method_22683().method_4502();
        Configs.PoseOffsetMethod poseOffsetMethod = CONFIGS.poseOffsetMethod.getValue();

        var backup = new DataBackup<>(targetEntity, LIVINGENTITY_BACKUP_ENTRIES);
        backup.save();

        transformEntity(targetEntity, partialTicks, poseOffsetMethod == Configs.PoseOffsetMethod.FORCE_STANDING);

        DataBackup<class_1309> vehicleBackup = null;
        if (CONFIGS.renderVehicle.getValue() && poseOffsetMethod != Configs.PoseOffsetMethod.FORCE_STANDING && targetEntity.method_5765()) {
            var vehicle = targetEntity.method_5854();
            assert vehicle != null;

            // get the overall yaw before transforming
            var yawLerped = vehicle.method_5705(partialTicks);

            // FIXME: NEVERFIX - the rendered yaw of minecart is determined non-trivially in its MinecartEntityRenderer#render, so it cannot be fixed to 0 easily
            if (vehicle instanceof class_1309 livingVehicle) {
                vehicleBackup = new DataBackup<>(livingVehicle, LIVINGENTITY_BACKUP_ENTRIES);
                vehicleBackup.save();
                transformEntity(livingVehicle, partialTicks, false);
            }

            performRendering(vehicle,
                    CONFIGS.offsetX.getValue() * scaledWidth,
                    CONFIGS.offsetY.getValue() * scaledHeight,
                    CONFIGS.size.getValue() * scaledHeight,
                    true,
                    vehicle.method_30950(partialTicks).method_1020(targetEntity.method_30950(partialTicks))
                            .method_1024((float) Math.toRadians(yawLerped+180)).method_46409(), // undo the rotation
                    CONFIGS.lightDegree.getValue(),
                    partialTicks, guiGraphics);
        }


        performRendering(targetEntity,
                CONFIGS.offsetX.getValue() * scaledWidth,
                CONFIGS.offsetY.getValue() * scaledHeight,
                CONFIGS.size.getValue() * scaledHeight,
                false,
                new Vector3f(0, (float) getPoseOffsetY(targetEntity, partialTicks, poseOffsetMethod), 0),
                CONFIGS.lightDegree.getValue(),
                partialTicks, guiGraphics);

        if (vehicleBackup != null) vehicleBackup.restore();

        backup.restore();
    }

    private double getPoseOffsetY(class_1309 targetEntity, float partialTicks, Configs.PoseOffsetMethod poseOffsetMethod) {
        if (poseOffsetMethod == Configs.PoseOffsetMethod.AUTO) {
            final float defaultPlayerEyeHeight = class_1657.field_62511;
            final float defaultPlayerSwimmingBBHeight = class_1657.field_63009;
            final float eyeHeightRatio = 0.85f;
            if (targetEntity.method_6128()) {
                return (defaultPlayerEyeHeight - targetEntity.method_5751()) * getFallFlyingLeaning(targetEntity, partialTicks);
            } else if (targetEntity.method_6123()) {
                return defaultPlayerEyeHeight - defaultPlayerSwimmingBBHeight * eyeHeightRatio * 0.8;
            } else if (targetEntity.method_20232()) {
                return targetEntity.method_6024(partialTicks) <= 0 ? 0 : defaultPlayerEyeHeight - targetEntity.method_5751();
            } else if (!targetEntity.method_20232() && targetEntity.method_6024(partialTicks) > 0) { // for swimming/crawling pose, only smooth the falling edge
                return (defaultPlayerEyeHeight - defaultPlayerSwimmingBBHeight * eyeHeightRatio * 0.85) * targetEntity.method_6024(partialTicks);
            } else {
                return class_1657.field_62511 - targetEntity.method_5751();
            }
        } else if (poseOffsetMethod == Configs.PoseOffsetMethod.MANUAL) {
            if (targetEntity.method_6128()) {
                return CONFIGS.elytraOffsetY.getValue() * getFallFlyingLeaning(targetEntity, partialTicks);
            } else if ((targetEntity.method_20232()) && targetEntity.method_6024(partialTicks) > 0 || targetEntity.method_6123()) { // require nonzero leaning to filter out glitch
                return CONFIGS.swimCrawlOffsetY.getValue();
            } else if (!targetEntity.method_20232() && targetEntity.method_6024(partialTicks) > 0) { // for swimming/crawling pose, only smooth the falling edge
                return CONFIGS.swimCrawlOffsetY.getValue() * targetEntity.method_6024(partialTicks);
            } else if (targetEntity.method_18276()) {
                return CONFIGS.sneakOffsetY.getValue();
            }
        }
        return 0;
    }

    private void transformEntity(class_1309 targetEntity, float partialTicks, boolean forceStanding) {
        // synchronize values to remove glitch
        if (!targetEntity.method_5681() && !targetEntity.method_6128() && !targetEntity.method_20448()) {
            targetEntity.method_18380(targetEntity.method_18276() ? class_4050.field_18081 : class_4050.field_18076);
        }

        if (forceStanding) {
            if (targetEntity instanceof class_746 player) {
                player.field_23093 = false;
            }
            targetEntity.field_6034 = null;

            targetEntity.field_6243 = 0;
            targetEntity.field_6264 = 0;

            targetEntity.method_5729(7, false);
            targetEntity.field_6239 = 0;
        }

        // FIXME: NEVERFIX - glitch when the mouse moves too fast, caused by lerping a warped value, it is possibly wrapped in LivingEntity#tick or LivingEntity#turnHead
        final float headLerp = class_3532.method_16439(partialTicks, targetEntity.field_6259, targetEntity.field_6241);
        final double headYaw = CONFIGS.headYaw.getValue(), headYawRange = CONFIGS.headYawRange.getValue();
        final double bodyYaw = CONFIGS.bodyYaw.getValue(), bodyYawRange = CONFIGS.bodyYawRange.getValue();
        final double pitch = CONFIGS.pitch.getValue(), pitchRange = CONFIGS.pitchRange.getValue();
        final float headClamp = (float) class_3532.method_15350(headLerp, headYaw - headYawRange, headYaw + headYawRange);
        final float bodyLerp = class_3532.method_16439(partialTicks, targetEntity.field_6220, targetEntity.field_6283);
        final float diff = headLerp - bodyLerp;
        final float bodyClamp = (float) class_3532.method_15350(class_3532.method_15393(headClamp - diff), bodyYaw - bodyYawRange, bodyYaw + bodyYawRange);
        final float pitchClamp = (float) (class_3532.method_15350(class_3532.method_16439(partialTicks, targetEntity.field_6004, targetEntity.method_36455()), -pitchRange, pitchRange) + pitch);
        final RotationMode rotationMode = CONFIGS.rotationMode.getValue();

        // 头部锁定
        if (rotationMode == RotationMode.LOCK) {
            targetEntity.field_6241 = targetEntity.field_6259 = 180 - headClamp;
        }
        // 身体锁定
        if (rotationMode == RotationMode.LOCK) {
            targetEntity.field_6283 = targetEntity.field_6220 = 180 - bodyClamp;
        }

        // 头部俯视角度
        targetEntity.method_36457(targetEntity.field_6004 = pitchClamp);


        if (!CONFIGS.swingHands.getValue()) {
            targetEntity.field_6251 = 0;
            targetEntity.field_6229 = 0;
        }

        if (!CONFIGS.hurtFlash.getValue()) {
            targetEntity.field_6235 = 0;
        }

        targetEntity.method_20803(0);

        targetEntity.method_5729(0, false);
    }

    private void performRendering(class_1297 targetEntity, double posX, double posY, double size, boolean boat,
                                  Vector3f offset, double lightDegree, float partialTicks, class_332 guiGraphics) {
        // 其余渲染逻辑保持不变...
        class_898 entityRenderDispatcher = minecraft.method_1561();

        class_897<? super class_1297, ?> entityRenderer = entityRenderDispatcher.method_3953(targetEntity);

        class_10017 state = entityRenderer.method_62425(targetEntity, partialTicks);
        state.field_61820 =getLight(targetEntity,partialTicks);
        state.field_58169 = null;
        state.field_61823.clear();
        state.field_61821 = 0;

        Quaternionf pose = new Quaternionf().rotateZ((float) Math.PI).rotateY((float) Math.PI);
        Quaternionf configRot = new Quaternionf().rotateXYZ(
                (float) Math.toRadians(CONFIGS.rotationX.getValue()),
                (float) Math.toRadians(CONFIGS.rotationY.getValue()),
                (float) Math.toRadians(CONFIGS.rotationZ.getValue()));

        pose.mul(configRot).rotateY((float) Math.toRadians(lightDegree + 180));

        if (targetEntity instanceof class_1690) {
            pose.rotateY((float) Math.toRadians(180));
        }
        ((GuiGraphicsInterface)guiGraphics).submitModeRenderState(
                state,
                offset,
                pose,
                new Quaternionf(configRot).conjugate(),
                (int) posX,
                (int) posY,
                (float) size,
                boat
        );
    }


    public Rectangle2D.Double getRenderBounds() {
        return this.currentRenderBounds;
    }

    public interface LockedPaperDoll {
    }

    public static class PaperDollPoseStack extends class_4587 implements LockedPaperDoll {
    }
}