/*
 * Decompiled with CFR 0.152.
 */
package org.ayamemc.ayamepaperdoll.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_11908;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_6379;
import net.minecraft.class_7842;
import net.minecraft.class_7919;
import net.minecraft.class_8087;
import net.minecraft.class_8088;
import net.minecraft.class_8089;
import org.apache.commons.lang3.ArrayUtils;
import org.ayamemc.ayamepaperdoll.AyamePaperDoll;
import org.ayamemc.ayamepaperdoll.CommonInterfaceInstances;
import org.ayamemc.ayamepaperdoll.config.ConfigWidgetRegistry;
import org.ayamemc.ayamepaperdoll.config.Configs;
import org.ayamemc.ayamepaperdoll.config.VisualConfigEditorScreen;
import org.ayamemc.ayamepaperdoll.config.model.ConfigOption;
import org.ayamemc.ayamepaperdoll.config.view.ListWidget;
import org.ayamemc.ayamepaperdoll.config.view.Tab;
import org.ayamemc.ayamepaperdoll.hud.PaperDollRenderer;
import org.jetbrains.annotations.NotNull;

public class ConfigScreen
extends class_437 {
    private static final int TAB_BUTTON_HEIGHT = 24;
    private static final int ENTRY_HEIGHT = 30;
    private static final int LIST_WIDTH_OFFSET = -50;
    private final class_437 lastScreen;
    private final PaperDollRenderer previewHud;
    private final class_8088 tabManager;
    private final List<ListWidget> listWidgets;
    private final List<? extends ConfigOption<?>> options;
    private Tab[] tabs;
    private class_8089 tabNav;

    public ConfigScreen(class_437 lastScreen, List<? extends ConfigOption<?>> options) {
        super(class_2561.method_30163((String)"Config Screen"));
        while (lastScreen instanceof ConfigScreen) {
            ConfigScreen configScreen = (ConfigScreen)lastScreen;
            lastScreen = configScreen.lastScreen;
        }
        this.lastScreen = lastScreen;
        this.previewHud = PaperDollRenderer.getInstance();
        this.tabManager = new class_8088(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        }, x$0 -> this.method_37066((class_364)x$0));
        this.options = options;
        this.listWidgets = new ArrayList<ListWidget>();
    }

    protected void method_25426() {
        this.tabs = this.generateTabs();
        this.tabNav = class_8089.method_48623((class_8088)this.tabManager, (int)this.field_22789).method_48631((class_8087[])this.tabs).method_48627();
        this.method_37063((class_364)this.tabNav);
        int tabIdx = AyamePaperDoll.CONFIGS.lastConfigTabIdx.getValue();
        if (tabIdx < 0 || tabIdx >= this.tabs.length) {
            tabIdx = 0;
            AyamePaperDoll.CONFIGS.lastConfigTabIdx.setValue(0);
        }
        this.tabNav.method_48987(tabIdx, false);
        this.method_48640();
    }

    private Tab[] generateTabs() {
        ArrayList<Tab> tabs = new ArrayList<Tab>();
        HashMap<class_2960, ListWidget> categoryLists = new HashMap<class_2960, ListWidget>();
        for (ConfigOption<?> option : this.options) {
            if (option.getCategory().equals((Object)Configs.HIDDEN_CATEGORY)) continue;
            Optional<ListWidget.ListEntry> configEntryOptioal = ConfigWidgetRegistry.DEFAULT.getConfigEntry(option);
            if (configEntryOptioal.isEmpty()) {
                AyamePaperDoll.LOGGER.error("Could not find widget for option {}", (Object)option.getId());
                continue;
            }
            class_7842 label = new class_7842(option.getName(), this.field_22787.field_1772);
            label.method_47400(class_7919.method_47407((class_2561)option.getDescription()));
            class_2960 category = option.getCategory();
            if (!categoryLists.containsKey(category)) {
                Tab tab = new Tab((class_2561)class_2561.method_43471((String)"config.%s.category.%s".formatted(category.method_12836(), category.method_12832())));
                ListWidget list = new ListWidget(this.field_22789, this.field_22790 - 24, 24, 30);
                this.listWidgets.add(list);
                tab.addChild((class_339)list);
                tabs.add(tab);
                categoryLists.put(category, list);
            }
            ((ListWidget)categoryLists.get(category)).addEntry(configEntryOptioal.get());
            if (option.getId().equals((Object)AyamePaperDoll.path("display_paperdoll"))) {
                ((ListWidget)categoryLists.get(category)).addEntry(this.getPresetsConfigEntry());
            }
            if (!option.getId().equals((Object)AyamePaperDoll.path("display_paperdoll"))) continue;
            ((ListWidget)categoryLists.get(category)).addEntry(this.getVisualConfigEditorLabelEntry());
        }
        if (tabs.isEmpty()) {
            tabs.add(new Tab(class_2561.method_30163((String)"")));
        }
        return (Tab[])tabs.toArray(Tab[]::new);
    }

    protected void method_48640() {
        if (this.tabNav == null) {
            return;
        }
        this.tabNav.method_48618(this.field_22789);
        this.tabNav.method_49613();
        for (ListWidget listWidget : this.listWidgets) {
            listWidget.method_55445(this.field_22789, this.field_22790 - 24);
            listWidget.setRowWidth(this.field_22789 + -50);
        }
    }

    public void method_25419() {
        AyamePaperDoll.CONFIGS.lastConfigTabIdx.setValue(ArrayUtils.indexOf((Object[])this.tabs, (Object)this.tabManager.method_48614()));
        this.field_22787.method_1507(this.lastScreen);
        AyamePaperDoll.CONFIG_PERSISTENCE.save(AyamePaperDoll.CONFIGS.getOptions());
    }

    protected void method_57734(class_332 guiGraphics) {
        if (this.field_22787.field_1687 == null || !AyamePaperDoll.CONFIGS.disableConfigScreenBlur.getValue().booleanValue()) {
            super.method_57734(guiGraphics);
        }
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        if (this.field_22787.field_1687 != null) {
            this.previewHud.render(this.field_22787.method_61966().method_60637(true), guiGraphics);
            guiGraphics.method_51448().translate(0.0f, 0.0f);
        }
        super.method_25394(guiGraphics, mouseX, mouseY, delta);
    }

    public boolean method_25421() {
        return AyamePaperDoll.CONFIGS.pauseGameOnConfigScreen.getValue();
    }

    public boolean method_25404(class_11908 keyEvent) {
        if (keyEvent.comp_4795() == CommonInterfaceInstances.keyHelper.getBoundKeyOf(AyamePaperDoll.OPEN_CONFIG_GUI).method_1444() && this.method_25422()) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyEvent);
    }

    private ListWidget.ListEntry getPresetsConfigEntry() {
        int buttonWidth = 70;
        int gap = 10;
        int buttonHeight = 20;
        int labelYOffset = 7;
        final class_7842 presetLabel = new class_7842((class_2561)class_2561.method_43471((String)"config.%s.option.presets".formatted("ayame_paperdoll")), this.field_22787.field_1772);
        presetLabel.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"config.%s.option.presets.desc".formatted("ayame_paperdoll"))));
        final ConfigWidgetRegistry.ConfigButton topLeft = new ConfigWidgetRegistry.ConfigButton(70, 20, this.getPresetText("top_left"), this.getPresetPressAction(AyamePaperDoll.CONFIGS.topLeft));
        final ConfigWidgetRegistry.ConfigButton topRight = new ConfigWidgetRegistry.ConfigButton(70, 20, this.getPresetText("top_right"), this.getPresetPressAction(AyamePaperDoll.CONFIGS.topRight));
        final ConfigWidgetRegistry.ConfigButton bottomLeft = new ConfigWidgetRegistry.ConfigButton(70, 20, this.getPresetText("bottom_left"), this.getPresetPressAction(AyamePaperDoll.CONFIGS.bottomLeft));
        final ConfigWidgetRegistry.ConfigButton bottomRight = new ConfigWidgetRegistry.ConfigButton(70, 20, this.getPresetText("bottom_right"), this.getPresetPressAction(AyamePaperDoll.CONFIGS.bottomRight));
        final List<ConfigWidgetRegistry.ConfigButton> children = List.of(presetLabel, topLeft, topRight, bottomLeft, bottomRight);
        return new ListWidget.ListEntry(this){

            @NotNull
            public List<? extends class_6379> method_37025() {
                return children;
            }

            @NotNull
            public List<? extends class_364> method_25396() {
                return children;
            }

            public void method_25343(class_332 context, int i, int j, boolean hovered, float tickDelta) {
                presetLabel.method_48229(this.method_73380(), this.method_73382() + 7);
                topLeft.method_48229(this.method_73380() + this.method_73387() - 280 - 30, this.method_73382());
                topRight.method_48229(this.method_73380() + this.method_73387() - 210 - 20, this.method_73382());
                bottomLeft.method_48229(this.method_73380() + this.method_73387() - 140 - 10, this.method_73382());
                bottomRight.method_48229(this.method_73380() + this.method_73387() - 70, this.method_73382());
                for (class_339 child : children) {
                    child.method_25394(context, i, j, tickDelta);
                }
            }
        };
    }

    private ListWidget.ListEntry getVisualConfigEditorLabelEntry() {
        int buttonWidth = 140;
        int buttonHeight = 20;
        final ConfigWidgetRegistry.ConfigButton visualConfigEditorButton = new ConfigWidgetRegistry.ConfigButton(140, 20, this.getButtonText("visual_config_editor"), button -> this.field_22787.method_1507((class_437)new VisualConfigEditorScreen(this)));
        if (this.field_22787.field_1687 == null) {
            visualConfigEditorButton.field_22763 = false;
            visualConfigEditorButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"config.%s.option.visual_config_editor_not_available.desc".formatted("ayame_paperdoll"))));
        } else {
            visualConfigEditorButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"config.%s.option.visual_config_editor.desc".formatted("ayame_paperdoll"))));
        }
        final List<ConfigWidgetRegistry.ConfigButton> children = List.of(visualConfigEditorButton);
        return new ListWidget.ListEntry(this){

            public void method_25343(class_332 guiGraphics, int i, int j, boolean bl, float f) {
                visualConfigEditorButton.method_48229((this.method_73380() + this.method_73387() - 140) / 2, this.method_73382());
                for (class_339 child : children) {
                    child.method_25394(guiGraphics, i, j, f);
                }
            }

            @NotNull
            public List<? extends class_6379> method_37025() {
                return children;
            }

            @NotNull
            public List<? extends class_364> method_25396() {
                return children;
            }
        };
    }

    private class_2561 getPresetText(String text) {
        return class_2561.method_43471((String)"config.%s.presets.%s".formatted("ayame_paperdoll", text));
    }

    private class_2561 getButtonText(String text) {
        return class_2561.method_43471((String)"config.%s.button.%s".formatted("ayame_paperdoll", text));
    }

    private class_4185.class_4241 getPresetPressAction(Configs.Presets presets) {
        return ignored -> {
            presets.load();
            int tabIdx = ArrayUtils.indexOf((Object[])this.tabs, (Object)this.tabManager.method_48614());
            this.method_37067();
            this.listWidgets.clear();
            this.method_25426();
            this.tabNav.method_48987(tabIdx, false);
        };
    }
}

