/*
 * Decompiled with CFR 0.152.
 */
package org.ayamemc.ayamepaperdoll.config;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_6379;
import net.minecraft.class_7842;
import net.minecraft.class_7919;
import org.ayamemc.ayamepaperdoll.AyamePaperDoll;
import org.ayamemc.ayamepaperdoll.config.model.ConfigOption;
import org.ayamemc.ayamepaperdoll.config.model.RangedConfigOption;
import org.ayamemc.ayamepaperdoll.config.view.ListWidget;
import org.ayamemc.ayamepaperdoll.config.view.Retextured;
import org.jetbrains.annotations.NotNull;

public class ConfigWidgetRegistry {
    public static final int RESET_BUTTON_WIDTH = 50;
    public static final ConfigWidgetRegistry DEFAULT = new ConfigWidgetRegistry();
    private static final String ON_LANGKEY = "config.%s.on".formatted("ayame_paperdoll");
    private static final String OFF_LANGKEY = "config.%s.off".formatted("ayame_paperdoll");
    private static final String RESET_LANGKEY = "config.%s.reset".formatted("ayame_paperdoll");
    private static final int WIDGET_WIDTH = 150;
    private static final int WIDGET_HEIGHT = 20;
    private final List<OptionWidgetEntry<?, ?>> defaultWidgets = new ArrayList();

    private ConfigWidgetRegistry() {
        this.defaultWidgets.add(new OptionWidgetEntry<Boolean, ConfigOption>(Boolean.class, ConfigOption.class, ConfigWidgetRegistry::getOnOffButton));
        this.defaultWidgets.add(new OptionWidgetEntry<Enum, ConfigOption>(Enum.class, ConfigOption.class, ConfigWidgetRegistry::getEnumCycleButton));
        this.defaultWidgets.add(new OptionWidgetEntry<Double, RangedConfigOption>(Double.class, RangedConfigOption.class, ConfigWidgetRegistry::getDoubleSlider));
        this.defaultWidgets.add(new OptionWidgetEntry<Integer, RangedConfigOption>(Integer.class, RangedConfigOption.class, ConfigWidgetRegistry::getIntegerSlider));
        this.defaultWidgets.add(new OptionWidgetEntry<String, ConfigOption>(String.class, ConfigOption.class, ConfigWidgetRegistry::getStringField));
    }

    private static <T> class_4185 getResetButton(ConfigOption<T> option, ConfigValueUpdater<T> setter) {
        ConfigButton reset = new ConfigButton(50, 20, (class_2561)class_2561.method_43471((String)RESET_LANGKEY), self -> setter.setValue(option.getDefaultValue()));
        reset.field_22763 = !option.isValueDefault();
        return reset;
    }

    private static ListWidget.ListEntry getStringField(ConfigOption<String> option) {
        ConfigValueUpdater<String> setter = new ConfigValueUpdater<String>();
        ConfigTextField field = new ConfigTextField(150, 20);
        field.method_1852(option.getValue());
        field.method_1863(setter::setValue);
        class_4185 reset = ConfigWidgetRegistry.getResetButton(option, setter);
        setter.setUpdateHandler(val -> {
            option.setValue((String)val);
            field.method_1852((String)option.getValue());
            reset.field_22763 = !option.isValueDefault();
        });
        return new ConfigEntry(option.getName(), class_7919.method_47407((class_2561)option.getDescription()), (class_339)field, reset);
    }

    private static ListWidget.ListEntry getDoubleSlider(RangedConfigOption<Double> option) {
        ConfigValueUpdater<Double> setter = new ConfigValueUpdater<Double>();
        ConfigSlider slider = new ConfigSlider(150, 20, ((Double)option.getValue() - option.getMin()) / (option.getMax() - option.getMin()), val -> setter.setValue(class_3532.method_16436((double)val, (double)((Double)option.getMin()), (double)((Double)option.getMax()))), val -> class_2561.method_30163((String)"%.2f".formatted(option.getValue())));
        class_4185 reset = ConfigWidgetRegistry.getResetButton(option, setter);
        setter.setUpdateHandler(val -> {
            option.setValue((Double)val);
            slider.setValueNoEvent(((Double)option.getValue() - (Double)option.getMin()) / ((Double)option.getMax() - (Double)option.getMin()));
            reset.field_22763 = !option.isValueDefault();
        });
        return new ConfigEntry(option.getName(), class_7919.method_47407((class_2561)option.getDescription()), (class_339)slider, reset);
    }

    private static ListWidget.ListEntry getIntegerSlider(RangedConfigOption<Integer> option) {
        ConfigValueUpdater<Integer> setter = new ConfigValueUpdater<Integer>();
        double steps = option.getMax() - option.getMin();
        ConfigSlider slider = new ConfigSlider(150, 20, (double)((Integer)option.getValue() - option.getMin()) / steps, val -> setter.setValue((int)Math.round(val * steps) + (Integer)option.getMin()), val -> class_2561.method_30163((String)Integer.toString((Integer)option.getValue())));
        class_4185 reset = ConfigWidgetRegistry.getResetButton(option, setter);
        setter.setUpdateHandler(val -> {
            option.setValue((Integer)val);
            slider.setValueNoEvent((double)((Integer)option.getValue() - (Integer)option.getMin()) / steps);
            reset.field_22763 = !option.isValueDefault();
        });
        return new ConfigEntry(option.getName(), class_7919.method_47407((class_2561)option.getDescription()), (class_339)slider, reset);
    }

    private static ListWidget.ListEntry getOnOffButton(ConfigOption<Boolean> option) {
        ConfigValueUpdater<Boolean> setter = new ConfigValueUpdater<Boolean>();
        ConfigButton btn = new ConfigButton(150, 20, (class_2561)class_2561.method_43471((String)(option.getValue() != false ? ON_LANGKEY : OFF_LANGKEY)), self -> setter.setValue((Boolean)option.getValue() == false));
        class_4185 reset = ConfigWidgetRegistry.getResetButton(option, setter);
        setter.setUpdateHandler(val -> {
            option.setValue((Boolean)val);
            btn.method_25355((class_2561)class_2561.method_43471((String)((Boolean)option.getValue() != false ? ON_LANGKEY : OFF_LANGKEY)));
            reset.field_22763 = !option.isValueDefault();
        });
        return new ConfigEntry(option.getName(), class_7919.method_47407((class_2561)option.getDescription()), (class_339)btn, reset);
    }

    private static <T extends Enum<?>> ListWidget.ListEntry getEnumCycleButton(ConfigOption<T> option) {
        ConfigValueUpdater<Enum> setter = new ConfigValueUpdater<Enum>();
        Enum[] values = (Enum[])option.getType().getEnumConstants();
        class_2561[] translations = new class_2561[values.length];
        for (int i = 0; i < values.length; ++i) {
            translations[i] = class_2561.method_43471((String)"config.%s.enum.%s.%s".formatted("ayame_paperdoll", option.getType().getSimpleName(), values[i].name()));
        }
        ConfigButton btn = new ConfigButton(150, 20, translations[((Enum)option.getValue()).ordinal()], self -> setter.setValue(values[(((Enum)option.getValue()).ordinal() + 1) % values.length]));
        class_4185 reset = ConfigWidgetRegistry.getResetButton(option, setter);
        setter.setUpdateHandler(val -> {
            option.setValue(val);
            btn.method_25355(translations[((Enum)option.getValue()).ordinal()]);
            reset.field_22763 = !option.isValueDefault();
        });
        return new ConfigEntry(option.getName(), class_7919.method_47407((class_2561)option.getDescription()), (class_339)btn, reset);
    }

    public <T, U extends ConfigOption<T>> Optional<ListWidget.ListEntry> getConfigEntry(U option) {
        for (OptionWidgetEntry<?, ?> entry : this.defaultWidgets) {
            if (!entry.type.isAssignableFrom(option.getType())) continue;
            OptionWidgetEntry<?, ?> entryCast = entry;
            return Optional.of(entryCast.widgetProvider.apply(option));
        }
        return Optional.empty();
    }

    record OptionWidgetEntry<T, U extends ConfigOption<T>>(Class<T> type, Class<U> optionType, Function<U, ListWidget.ListEntry> widgetProvider) {
    }

    public static class ConfigButton
    extends class_4185
    implements Retextured {
        public ConfigButton(int width, int height, class_2561 message, class_4185.class_4241 action) {
            super(0, 0, width, height, message, action, field_40754);
        }

        @Override
        public class_2960 retexture(class_2960 oldTexture) {
            return AyamePaperDoll.path(oldTexture.method_12832());
        }
    }

    private static class ConfigValueUpdater<T> {
        private Consumer<T> updateHandler = null;
        private boolean preventUpdates = false;

        private ConfigValueUpdater() {
        }

        public void setUpdateHandler(Consumer<T> updateHandler) {
            this.updateHandler = updateHandler;
        }

        public void setValue(T newValue) {
            if (this.preventUpdates || this.updateHandler == null) {
                return;
            }
            this.preventUpdates = true;
            this.updateHandler.accept(newValue);
            this.preventUpdates = false;
        }
    }

    private static class ConfigTextField
    extends class_342
    implements Retextured {
        public ConfigTextField(int width, int height) {
            super(class_310.method_1551().field_1772, width, height, (class_2561)class_2561.method_43473());
        }

        @Override
        public class_2960 retexture(class_2960 oldTexture) {
            return AyamePaperDoll.path(oldTexture.method_12832());
        }
    }

    private static class ConfigEntry
    extends ListWidget.ListEntry {
        private static final int LABEL_Y_OFFSET = 7;
        private static final int GAP_WIDTH = 10;
        private final List<class_339> children;
        private final class_7842 label;
        private final class_339 widget;
        private final class_4185 reset;

        private ConfigEntry(class_2561 label, class_7919 labelTooltip, class_339 widget, class_4185 resetButton) {
            class_7842 labelWidget = new class_7842(label, class_310.method_1551().field_1772);
            labelWidget.method_47400(labelTooltip);
            this.label = labelWidget;
            this.widget = widget;
            this.reset = resetButton;
            this.children = ImmutableList.of((Object)this.widget, (Object)this.reset);
        }

        public List<? extends class_6379> method_37025() {
            return this.children;
        }

        public List<? extends class_364> method_25396() {
            return this.children;
        }

        public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.label.method_48229(this.method_73380(), this.method_73382() + 7);
            this.reset.method_48229(this.method_73380() + this.method_73387() - this.reset.method_25368(), this.method_73382());
            this.widget.method_48229(this.method_73380() + this.method_73387() - this.reset.method_25368() - this.widget.method_25368() - 10, this.method_73382());
            this.widget.method_25394(guiGraphics, mouseX, mouseY, tickDelta);
            this.reset.method_25394(guiGraphics, mouseX, mouseY, tickDelta);
            this.label.method_25394(guiGraphics, mouseX, mouseY, tickDelta);
        }
    }

    private static class ConfigSlider
    extends class_357
    implements Retextured {
        @NotNull
        private final Consumer<Double> changeListener;
        @NotNull
        private final Function<Double, class_2561> messageProvider;

        public ConfigSlider(int width, int height, double value, @NotNull Consumer<Double> changeListener, @NotNull Function<Double, class_2561> messageProvider) {
            super(0, 0, width, height, (class_2561)class_2561.method_43473(), value);
            this.changeListener = changeListener;
            this.messageProvider = messageProvider;
            this.method_25346();
        }

        @Override
        public class_2960 retexture(class_2960 oldTexture) {
            return AyamePaperDoll.path(oldTexture.method_12832());
        }

        protected void method_25344() {
            this.changeListener.accept(this.field_22753);
        }

        protected void method_25346() {
            this.method_25355(this.messageProvider.apply(this.field_22753));
        }

        public void setValueNoEvent(double value) {
            this.field_22753 = value;
            this.method_25346();
        }
    }
}

