/*
 * Decompiled with CFR 0.152.
 */
package org.ayamemc.ayamepaperdoll.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_2960;
import org.apache.commons.lang3.tuple.Pair;
import org.ayamemc.ayamepaperdoll.AyamePaperDoll;
import org.ayamemc.ayamepaperdoll.config.model.ConfigOption;
import org.ayamemc.ayamepaperdoll.config.model.SimpleNumericOption;
import org.ayamemc.ayamepaperdoll.config.model.SimpleOption;

public class Configs {
    public static final class_2960 GENERAL_CATEGORY = AyamePaperDoll.path("general");
    public static final class_2960 ROTATIONS_CATEGORY = AyamePaperDoll.path("rotations");
    public static final class_2960 POSTURES_CATEGORY = AyamePaperDoll.path("postures");
    public static final class_2960 DETAILS_CATEGORY = AyamePaperDoll.path("details");
    public static final class_2960 HIDDEN_CATEGORY = AyamePaperDoll.path("hidden");
    public final SimpleOption<Boolean> displayPaperDoll = new SimpleOption<Boolean>(GENERAL_CATEGORY, AyamePaperDoll.path("display_paperdoll"), true);
    public final SimpleOption<RotationMode> rotationMode = new SimpleOption<RotationMode>(GENERAL_CATEGORY, AyamePaperDoll.path("rotation_mode"), RotationMode.LOCK);
    public final SimpleNumericOption<Double> offsetX = new SimpleNumericOption<Double>(GENERAL_CATEGORY, AyamePaperDoll.path("offset_x"), 0.08, -0.5, 1.5);
    public final SimpleNumericOption<Double> offsetY = new SimpleNumericOption<Double>(GENERAL_CATEGORY, AyamePaperDoll.path("offset_y"), 0.23, -0.5, 2.5);
    public final SimpleNumericOption<Double> rotationX = new SimpleNumericOption<Double>(GENERAL_CATEGORY, AyamePaperDoll.path("rotation_x"), -4.96, -180.0, 180.0);
    public final SimpleNumericOption<Double> rotationY = new SimpleNumericOption<Double>(GENERAL_CATEGORY, AyamePaperDoll.path("rotation_y"), -4.96, -180.0, 180.0);
    public final SimpleNumericOption<Double> rotationZ = new SimpleNumericOption<Double>(GENERAL_CATEGORY, AyamePaperDoll.path("rotation_z"), 0.0, -180.0, 180.0);
    public final SimpleNumericOption<Double> size = new SimpleNumericOption<Double>(GENERAL_CATEGORY, AyamePaperDoll.path("size"), 0.1, 0.0, 2.0);
    public final SimpleOption<Boolean> mirrored = new SimpleOption<Boolean>(GENERAL_CATEGORY, AyamePaperDoll.path("mirrored"), true);
    public final SimpleNumericOption<Double> pitch = new SimpleNumericOption<Double>(ROTATIONS_CATEGORY, AyamePaperDoll.path("pitch"), 0.0, -90.0, 90.0);
    public final SimpleNumericOption<Double> pitchRange = new SimpleNumericOption<Double>(ROTATIONS_CATEGORY, AyamePaperDoll.path("pitch_range"), 20.0, 0.0, 90.0);
    public final SimpleNumericOption<Double> headYaw = new SimpleNumericOption<Double>(ROTATIONS_CATEGORY, AyamePaperDoll.path("head_yaw"), -7.5, -180.0, 180.0);
    public final SimpleNumericOption<Double> headYawRange = new SimpleNumericOption<Double>(ROTATIONS_CATEGORY, AyamePaperDoll.path("head_yaw_range"), 0.0, 0.0, 180.0);
    public final SimpleNumericOption<Double> bodyYaw = new SimpleNumericOption<Double>(ROTATIONS_CATEGORY, AyamePaperDoll.path("body_yaw"), 0.0, -180.0, 180.0);
    public final SimpleNumericOption<Double> bodyYawRange = new SimpleNumericOption<Double>(ROTATIONS_CATEGORY, AyamePaperDoll.path("body_yaw_range"), 0.0, 0.0, 180.0);
    public final SimpleOption<PoseOffsetMethod> poseOffsetMethod = new SimpleOption<PoseOffsetMethod>(POSTURES_CATEGORY, AyamePaperDoll.path("pose_offset_method"), PoseOffsetMethod.AUTO);
    public final SimpleNumericOption<Double> sneakOffsetY = new SimpleNumericOption<Double>(POSTURES_CATEGORY, AyamePaperDoll.path("sneak_offset_y"), -0.35, -3.0, 3.0);
    public final SimpleNumericOption<Double> swimCrawlOffsetY = new SimpleNumericOption<Double>(POSTURES_CATEGORY, AyamePaperDoll.path("swim_crawl_offset_y"), -1.22, -3.0, 3.0);
    public final SimpleNumericOption<Double> elytraOffsetY = new SimpleNumericOption<Double>(POSTURES_CATEGORY, AyamePaperDoll.path("elytra_offset_y"), -1.22, -3.0, 3.0);
    public final SimpleOption<Boolean> hurtFlash = new SimpleOption<Boolean>(DETAILS_CATEGORY, AyamePaperDoll.path("hurt_flash"), true);
    public final SimpleOption<Boolean> swingHands = new SimpleOption<Boolean>(DETAILS_CATEGORY, AyamePaperDoll.path("swing_hands"), true);
    public final SimpleNumericOption<Double> lightDegree = new SimpleNumericOption<Double>(DETAILS_CATEGORY, AyamePaperDoll.path("light_degree"), 0.0, -180.0, 180.0);
    public final SimpleOption<Boolean> useWorldLight = new SimpleOption<Boolean>(DETAILS_CATEGORY, AyamePaperDoll.path("use_world_light"), true);
    public final SimpleNumericOption<Integer> worldLightMin = new SimpleNumericOption<Integer>(DETAILS_CATEGORY, AyamePaperDoll.path("world_light_min"), 2, 0, 15);
    public final SimpleOption<Boolean> renderVehicle = new SimpleOption<Boolean>(DETAILS_CATEGORY, AyamePaperDoll.path("render_vehicle"), true);
    public final SimpleOption<Boolean> pauseGameOnConfigScreen = new SimpleOption<Boolean>(DETAILS_CATEGORY, AyamePaperDoll.path("pause_game_on_config_screen"), true);
    public final SimpleOption<Boolean> disableConfigScreenBlur = new SimpleOption<Boolean>(DETAILS_CATEGORY, AyamePaperDoll.path("disable_config_screen_blur"), true);
    public final SimpleOption<Boolean> visibleDuringActivity = new SimpleOption<Boolean>(DETAILS_CATEGORY, AyamePaperDoll.path("visible_during_activity"), false);
    public final SimpleOption<Boolean> hideUnderDebug = new SimpleOption<Boolean>(DETAILS_CATEGORY, AyamePaperDoll.path("hide_under_debug"), true);
    public final SimpleOption<Boolean> hideOnScreenOpen = new SimpleOption<Boolean>(DETAILS_CATEGORY, AyamePaperDoll.path("hide_on_screen_open"), false);
    public final SimpleOption<Boolean> spectatorAutoSwitch = new SimpleOption<Boolean>(DETAILS_CATEGORY, AyamePaperDoll.path("spectator_auto_switch"), true);
    public final SimpleOption<String> playerName = new SimpleOption<String>(DETAILS_CATEGORY, AyamePaperDoll.path("player_name"), "");
    public final SimpleOption<Integer> lastConfigTabIdx = new SimpleOption<Integer>(HIDDEN_CATEGORY, AyamePaperDoll.path("last_config_tab_idx"), 0);
    public final Presets topLeft = new Presets.PresetsBuilder().with(this.offsetX, 0.08).with(this.offsetY, 0.23).with(this.rotationX, -4.96).with(this.rotationY, -4.96).with(this.rotationZ, 0.0).with(this.size, 0.1).with(this.mirrored, true).build();
    public final Presets topRight = new Presets.PresetsBuilder().with(this.offsetX, 0.91).with(this.offsetY, 0.23).with(this.rotationX, -4.96).with(this.rotationY, -4.96).with(this.rotationZ, 0.0).with(this.size, 0.1).with(this.mirrored, false).build();
    public final Presets bottomLeft = new Presets.PresetsBuilder().with(this.offsetX, 0.14).with(this.offsetY, 1.27).with(this.rotationX, 0.0).with(this.rotationY, 0.0).with(this.rotationZ, 0.0).with(this.size, 0.29).with(this.mirrored, true).build();
    public final Presets bottomRight = new Presets.PresetsBuilder().with(this.offsetX, 0.85).with(this.offsetY, 1.27).with(this.rotationX, 0.0).with(this.rotationY, 0.0).with(this.rotationZ, 0.0).with(this.size, 0.29).with(this.mirrored, false).build();
    private final List<? extends ConfigOption<?>> options = Arrays.stream(this.getClass().getFields()).map(field -> {
        try {
            return field.get(this);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }).filter(val -> val instanceof ConfigOption).map(f -> (ConfigOption)f).toList();

    public Configs() {
        HashSet<Pair> unique = new HashSet<Pair>();
        for (ConfigOption<?> option : this.options) {
            if (unique.add(Pair.of((Object)option.getCategory(), (Object)option.getId()))) continue;
            throw new IllegalStateException("Duplicated option id: " + String.valueOf(option.getId()) + " in category " + String.valueOf(option.getCategory()));
        }
    }

    public List<? extends ConfigOption<?>> getOptions() {
        return this.options;
    }

    public static enum RotationMode {
        UNLOCK,
        LOCK;

    }

    public static enum PoseOffsetMethod {
        AUTO,
        MANUAL,
        FORCE_STANDING,
        DISABLED;

    }

    @FunctionalInterface
    public static interface Presets {
        public void load();

        public static class PresetsBuilder {
            private final List<Runnable> presets = new ArrayList<Runnable>();

            public <T> PresetsBuilder with(ConfigOption<T> option, T value) {
                this.presets.add(() -> option.setValue(value));
                return this;
            }

            public Presets build() {
                return () -> this.presets.forEach(Runnable::run);
            }
        }
    }
}

