/*
 * Decompiled with CFR 0.152.
 */
package org.ayamemc.ayamepaperdoll.config.model;

import net.minecraft.class_2960;
import org.ayamemc.ayamepaperdoll.AyamePaperDoll;
import org.ayamemc.ayamepaperdoll.config.model.RangedConfigOption;
import org.ayamemc.ayamepaperdoll.config.model.SimpleOption;
import org.jetbrains.annotations.NotNull;

public class SimpleNumericOption<T extends Number>
extends SimpleOption<T>
implements RangedConfigOption<T> {
    @NotNull
    private final T min;
    @NotNull
    private final T max;

    public SimpleNumericOption(class_2960 category, class_2960 id, @NotNull T defaultValue, @NotNull T min, @NotNull T max) {
        super(category, id, defaultValue);
        this.min = min;
        this.max = max;
        if (((Comparable)max).compareTo(min) < 0) {
            throw new IllegalArgumentException("The maximum value must be greater than the minimum value");
        }
        if (!SimpleNumericOption.withinRangeInclusive(defaultValue, min, max)) {
            throw new IllegalArgumentException("The default value must be in range [minValue] to [maxValue]");
        }
    }

    private static <T extends Number> boolean withinRangeInclusive(T value, T minValue, T maxValue) {
        return ((Comparable)((Object)minValue)).compareTo(value) <= 0 && ((Comparable)((Object)maxValue)).compareTo(value) >= 0;
    }

    @Override
    public T validate(T oldValue, T newValue) {
        Number validated = (Number)super.validate(oldValue, newValue);
        if (!SimpleNumericOption.withinRangeInclusive(validated, this.min, this.max)) {
            AyamePaperDoll.LOGGER.warn("The new value for option {} is outside the range [{}, {}], reset to the old value", new Object[]{this.getId().toString(), this.min, this.max});
            return oldValue;
        }
        return newValue;
    }

    @Override
    @NotNull
    public T getMax() {
        return this.max;
    }

    @Override
    @NotNull
    public T getMin() {
        return this.min;
    }
}

