/*
 * Decompiled with CFR 0.152.
 */
package org.ayamemc.ayamepaperdoll.config.persistence;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import org.ayamemc.ayamepaperdoll.AyamePaperDoll;
import org.ayamemc.ayamepaperdoll.config.model.ConfigOption;
import org.ayamemc.ayamepaperdoll.config.persistence.ConfigPersistence;

public class GsonConfigPersistence
implements ConfigPersistence {
    private final Path path;
    private final Gson gson;

    public GsonConfigPersistence(Path path) {
        this.path = path;
        this.gson = new GsonBuilder().setPrettyPrinting().create();
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public boolean save(List<? extends ConfigOption<?>> options) {
        Map<class_2960, Map<class_2960, ConfigOption<?>>> categories = this.categorize(options);
        try (JsonWriter writer = this.gson.newJsonWriter((Writer)new BufferedWriter(new FileWriter(this.path.toFile())));){
            writer.beginObject();
            for (Map.Entry<class_2960, Map<class_2960, ConfigOption<?>>> entry : categories.entrySet()) {
                writer.name(entry.getKey().toString());
                writer.beginObject();
                for (Map.Entry<class_2960, ConfigOption<?>> optionEntry : entry.getValue().entrySet()) {
                    class_2960 id = optionEntry.getKey();
                    ConfigOption<?> option = optionEntry.getValue();
                    writer.name(id.toString());
                    this.gson.toJson(option.getValue(), option.getType(), writer);
                }
                writer.endObject();
            }
            writer.endObject();
        }
        catch (Exception e) {
            AyamePaperDoll.LOGGER.error("Failed to save config at " + String.valueOf(this.path), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean load(List<? extends ConfigOption<?>> options) {
        Map<class_2960, Map<class_2960, ConfigOption<?>>> categories = this.categorize(options);
        if (!this.path.toFile().exists() || !this.path.toFile().isFile()) {
            AyamePaperDoll.LOGGER.info("Configuration is not found at {}", (Object)this.path);
            return false;
        }
        try (JsonReader reader = this.gson.newJsonReader((Reader)new BufferedReader(new FileReader(this.path.toFile())));){
            reader.beginObject();
            while (reader.peek() == JsonToken.NAME) {
                String categoryName = reader.nextName();
                Map<class_2960, ConfigOption<?>> category = categories.get(class_2960.method_60654((String)categoryName));
                if (category == null) {
                    throw new IllegalStateException("The category with key " + categoryName + "does not exist");
                }
                reader.beginObject();
                while (reader.peek() == JsonToken.NAME) {
                    String optionName = reader.nextName();
                    ConfigOption<?> option = category.get(class_2960.method_60654((String)optionName));
                    if (option == null) {
                        throw new IllegalStateException("The option with key " + optionName + " in category " + categoryName + " does not exist");
                    }
                    if (option.getType().isAssignableFrom(Integer.class)) {
                        option.setValue(reader.nextInt());
                        continue;
                    }
                    if (option.getType().isAssignableFrom(Double.class)) {
                        option.setValue(reader.nextDouble());
                        continue;
                    }
                    if (option.getType().isAssignableFrom(Boolean.class)) {
                        option.setValue(reader.nextBoolean());
                        continue;
                    }
                    if (option.getType().isAssignableFrom(String.class)) {
                        option.setValue(reader.nextString());
                        continue;
                    }
                    if (option.getType().isAssignableFrom(Long.class)) {
                        option.setValue(reader.nextLong());
                        continue;
                    }
                    if (option.getType().isEnum()) {
                        option.setValue(Enum.valueOf(option.getType(), reader.nextString()));
                        continue;
                    }
                    throw new IllegalStateException("The option of type " + String.valueOf(option.getType()) + " could not be deserialized from a JSON value");
                }
                reader.endObject();
            }
            reader.endObject();
        }
        catch (Exception e) {
            AyamePaperDoll.LOGGER.error("Failed to load config at " + String.valueOf(this.path), (Throwable)e);
            return false;
        }
        return true;
    }

    private Map<class_2960, Map<class_2960, ConfigOption<?>>> categorize(List<? extends ConfigOption<?>> options) {
        LinkedHashMap categories = new LinkedHashMap();
        for (ConfigOption<?> option : options) {
            categories.computeIfAbsent(option.getCategory(), k -> new LinkedHashMap()).put(option.getId(), option);
        }
        return categories;
    }
}

