/*
 * Decompiled with CFR 0.152.
 */
package org.ayamemc.ayamepaperdoll.hud;

import com.google.common.collect.ImmutableList;
import java.awt.geom.Rectangle2D;
import java.util.List;
import net.minecraft.class_10017;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1690;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_4587;
import net.minecraft.class_742;
import net.minecraft.class_746;
import net.minecraft.class_765;
import net.minecraft.class_897;
import net.minecraft.class_898;
import org.ayamemc.ayamepaperdoll.AyamePaperDoll;
import org.ayamemc.ayamepaperdoll.config.Configs;
import org.ayamemc.ayamepaperdoll.hud.DataBackup;
import org.ayamemc.ayamepaperdoll.mixininterface.GuiGraphicsInterface;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class PaperDollRenderer {
    private static final List<DataBackup.DataBackupEntry<class_1309, ?>> LIVINGENTITY_BACKUP_ENTRIES = ImmutableList.of(new DataBackup.DataBackupEntry<class_1309, class_4050>(class_1297::method_18376, class_1297::method_18380), new DataBackup.DataBackupEntry<class_1309, Boolean>(class_1297::method_18276, (e, flag) -> {
        if (e instanceof class_746) {
            class_746 player = (class_746)e;
            player.field_23093 = flag;
        }
    }), new DataBackup.DataBackupEntry<class_1309, Float>(e -> Float.valueOf(e.field_6243), (e, pitch) -> {
        e.field_6243 = pitch.floatValue();
    }), new DataBackup.DataBackupEntry<class_1309, Float>(e -> Float.valueOf(e.field_6264), (e, pitch) -> {
        e.field_6264 = pitch.floatValue();
    }), new DataBackup.DataBackupEntry<class_1309, Boolean>(class_1309::method_6128, (e, flag) -> e.method_5729(7, flag.booleanValue())), new DataBackup.DataBackupEntry<class_1309, Integer>(class_1309::method_6003, (e, ticks) -> {
        e.field_6239 = ticks;
    }), new DataBackup.DataBackupEntry<class_1309, class_1297>(class_1297::method_5854, (e, vehicle) -> {
        e.field_6034 = vehicle;
    }), new DataBackup.DataBackupEntry<class_1309, Float>(e -> Float.valueOf(e.field_6220), (e, yaw) -> {
        e.field_6220 = yaw.floatValue();
    }), new DataBackup.DataBackupEntry<class_1309, Float>(e -> Float.valueOf(e.field_6283), (e, yaw) -> {
        e.field_6283 = yaw.floatValue();
    }), new DataBackup.DataBackupEntry<class_1309, Float>(e -> Float.valueOf(e.field_6259), (e, yaw) -> {
        e.field_6259 = yaw.floatValue();
    }), new DataBackup.DataBackupEntry<class_1309, Float>(e -> Float.valueOf(e.field_6241), (e, yaw) -> {
        e.field_6241 = yaw.floatValue();
    }), new DataBackup.DataBackupEntry<class_1309, Float>(e -> Float.valueOf(e.field_6004), (e, pitch) -> {
        e.field_6004 = pitch.floatValue();
    }), (Object[])new DataBackup.DataBackupEntry[]{new DataBackup.DataBackupEntry<class_1309, Float>(class_1297::method_36455, class_1297::method_36457), new DataBackup.DataBackupEntry<class_1309, Float>(e -> Float.valueOf(e.field_6251), (e, prog) -> {
        e.field_6251 = prog.floatValue();
    }), new DataBackup.DataBackupEntry<class_1309, Float>(e -> Float.valueOf(e.field_6229), (e, prog) -> {
        e.field_6229 = prog.floatValue();
    }), new DataBackup.DataBackupEntry<class_1309, Integer>(e -> e.field_6235, (e, time) -> {
        e.field_6235 = time;
    }), new DataBackup.DataBackupEntry<class_1309, Integer>(class_1297::method_20802, class_1297::method_20803), new DataBackup.DataBackupEntry<class_1309, Boolean>(e -> e.method_5795(0), (e, flag) -> e.method_5729(0, flag.booleanValue()))});
    private static final PaperDollRenderer instance = new PaperDollRenderer();
    private final class_310 minecraft = class_310.method_1551();
    private Rectangle2D.Double currentRenderBounds;

    private PaperDollRenderer() {
    }

    public static PaperDollRenderer getInstance() {
        return instance;
    }

    private static int getLight(class_1297 entity, float tickDelta) {
        if (AyamePaperDoll.CONFIGS.useWorldLight.getValue().booleanValue()) {
            class_1937 world = entity.method_73183();
            int blockLight = world.method_8314(class_1944.field_9282, class_2338.method_49638((class_2374)entity.method_5836(tickDelta)));
            int skyLight = world.method_8314(class_1944.field_9284, class_2338.method_49638((class_2374)entity.method_5836(tickDelta)));
            int min = (Integer)AyamePaperDoll.CONFIGS.worldLightMin.getValue();
            blockLight = class_3532.method_15340((int)blockLight, (int)min, (int)15);
            skyLight = class_3532.method_15340((int)skyLight, (int)min, (int)15);
            return class_765.method_23687((int)blockLight, (int)skyLight);
        }
        return class_765.method_23687((int)15, (int)15);
    }

    private static float getFallFlyingLeaning(class_1309 entity, float partialTicks) {
        float ticks = partialTicks + (float)entity.method_6003();
        return class_3532.method_15363((float)(ticks * ticks / 100.0f), (float)0.0f, (float)1.0f);
    }

    public static boolean shouldLockRotationYaw() {
        Configs.RotationMode rotationUnlock = AyamePaperDoll.CONFIGS.rotationMode.getValue();
        return rotationUnlock == Configs.RotationMode.LOCK;
    }

    public void render(float partialTicks, class_332 guiGraphics) {
        if (this.minecraft.field_1687 == null || this.minecraft.field_1724 == null || !AyamePaperDoll.CONFIGS.displayPaperDoll.getValue().booleanValue()) {
            return;
        }
        class_1309 targetEntity = (class_1309)this.minecraft.field_1687.method_18456().stream().filter(p -> p.method_5477().getString().equals(AyamePaperDoll.CONFIGS.playerName.getValue())).findFirst().orElse((class_742)this.minecraft.field_1724);
        if (AyamePaperDoll.CONFIGS.spectatorAutoSwitch.getValue().booleanValue() && this.minecraft.field_1724.method_7325()) {
            class_1297 cameraEntity = this.minecraft.method_1560();
            if (cameraEntity instanceof class_1309) {
                class_1309 livingEntity;
                targetEntity = livingEntity = (class_1309)cameraEntity;
            } else if (cameraEntity != null) {
                return;
            }
        }
        int scaledWidth = this.minecraft.method_22683().method_4486();
        int scaledHeight = this.minecraft.method_22683().method_4502();
        Configs.PoseOffsetMethod poseOffsetMethod = AyamePaperDoll.CONFIGS.poseOffsetMethod.getValue();
        DataBackup<class_1309> backup = new DataBackup<class_1309>(targetEntity, LIVINGENTITY_BACKUP_ENTRIES);
        backup.save();
        this.transformEntity(targetEntity, partialTicks, poseOffsetMethod == Configs.PoseOffsetMethod.FORCE_STANDING);
        DataBackup<class_1309> vehicleBackup = null;
        if (AyamePaperDoll.CONFIGS.renderVehicle.getValue().booleanValue() && poseOffsetMethod != Configs.PoseOffsetMethod.FORCE_STANDING && targetEntity.method_5765()) {
            class_1297 vehicle = targetEntity.method_5854();
            assert (vehicle != null);
            float yawLerped = vehicle.method_5705(partialTicks);
            if (vehicle instanceof class_1309) {
                class_1309 livingVehicle = (class_1309)vehicle;
                vehicleBackup = new DataBackup<class_1309>(livingVehicle, LIVINGENTITY_BACKUP_ENTRIES);
                vehicleBackup.save();
                this.transformEntity(livingVehicle, partialTicks, false);
            }
            this.performRendering(vehicle, (Double)AyamePaperDoll.CONFIGS.offsetX.getValue() * (double)scaledWidth, (Double)AyamePaperDoll.CONFIGS.offsetY.getValue() * (double)scaledHeight, (Double)AyamePaperDoll.CONFIGS.size.getValue() * (double)scaledHeight, true, vehicle.method_30950(partialTicks).method_1020(targetEntity.method_30950(partialTicks)).method_1024((float)Math.toRadians(yawLerped + 180.0f)).method_46409(), (Double)AyamePaperDoll.CONFIGS.lightDegree.getValue(), partialTicks, guiGraphics);
        }
        this.performRendering((class_1297)targetEntity, (Double)AyamePaperDoll.CONFIGS.offsetX.getValue() * (double)scaledWidth, (Double)AyamePaperDoll.CONFIGS.offsetY.getValue() * (double)scaledHeight, (Double)AyamePaperDoll.CONFIGS.size.getValue() * (double)scaledHeight, false, new Vector3f(0.0f, (float)this.getPoseOffsetY(targetEntity, partialTicks, poseOffsetMethod), 0.0f), (Double)AyamePaperDoll.CONFIGS.lightDegree.getValue(), partialTicks, guiGraphics);
        if (vehicleBackup != null) {
            vehicleBackup.restore();
        }
        backup.restore();
    }

    private double getPoseOffsetY(class_1309 targetEntity, float partialTicks, Configs.PoseOffsetMethod poseOffsetMethod) {
        if (poseOffsetMethod == Configs.PoseOffsetMethod.AUTO) {
            float defaultPlayerEyeHeight = 1.62f;
            float defaultPlayerSwimmingBBHeight = 0.6f;
            float eyeHeightRatio = 0.85f;
            if (targetEntity.method_6128()) {
                return (1.62f - targetEntity.method_5751()) * PaperDollRenderer.getFallFlyingLeaning(targetEntity, partialTicks);
            }
            if (targetEntity.method_6123()) {
                return 1.2119999647140502;
            }
            if (targetEntity.method_20232()) {
                return targetEntity.method_6024(partialTicks) <= 0.0f ? 0.0 : (double)(1.62f - targetEntity.method_5751());
            }
            if (!targetEntity.method_20232() && targetEntity.method_6024(partialTicks) > 0.0f) {
                return 1.1864999622106551 * (double)targetEntity.method_6024(partialTicks);
            }
            return 1.62f - targetEntity.method_5751();
        }
        if (poseOffsetMethod == Configs.PoseOffsetMethod.MANUAL) {
            if (targetEntity.method_6128()) {
                return (Double)AyamePaperDoll.CONFIGS.elytraOffsetY.getValue() * (double)PaperDollRenderer.getFallFlyingLeaning(targetEntity, partialTicks);
            }
            if (targetEntity.method_20232() && targetEntity.method_6024(partialTicks) > 0.0f || targetEntity.method_6123()) {
                return (Double)AyamePaperDoll.CONFIGS.swimCrawlOffsetY.getValue();
            }
            if (!targetEntity.method_20232() && targetEntity.method_6024(partialTicks) > 0.0f) {
                return (Double)AyamePaperDoll.CONFIGS.swimCrawlOffsetY.getValue() * (double)targetEntity.method_6024(partialTicks);
            }
            if (targetEntity.method_18276()) {
                return (Double)AyamePaperDoll.CONFIGS.sneakOffsetY.getValue();
            }
        }
        return 0.0;
    }

    private void transformEntity(class_1309 targetEntity, float partialTicks, boolean forceStanding) {
        if (!(targetEntity.method_5681() || targetEntity.method_6128() || targetEntity.method_20448())) {
            targetEntity.method_18380(targetEntity.method_18276() ? class_4050.field_18081 : class_4050.field_18076);
        }
        if (forceStanding) {
            if (targetEntity instanceof class_746) {
                class_746 player = (class_746)targetEntity;
                player.field_23093 = false;
            }
            targetEntity.field_6034 = null;
            targetEntity.field_6243 = 0.0f;
            targetEntity.field_6264 = 0.0f;
            targetEntity.method_5729(7, false);
            targetEntity.field_6239 = 0;
        }
        float headLerp = class_3532.method_16439((float)partialTicks, (float)targetEntity.field_6259, (float)targetEntity.field_6241);
        double headYaw = (Double)AyamePaperDoll.CONFIGS.headYaw.getValue();
        double headYawRange = (Double)AyamePaperDoll.CONFIGS.headYawRange.getValue();
        double bodyYaw = (Double)AyamePaperDoll.CONFIGS.bodyYaw.getValue();
        double bodyYawRange = (Double)AyamePaperDoll.CONFIGS.bodyYawRange.getValue();
        double pitch = (Double)AyamePaperDoll.CONFIGS.pitch.getValue();
        double pitchRange = (Double)AyamePaperDoll.CONFIGS.pitchRange.getValue();
        float headClamp = (float)class_3532.method_15350((double)headLerp, (double)(headYaw - headYawRange), (double)(headYaw + headYawRange));
        float bodyLerp = class_3532.method_16439((float)partialTicks, (float)targetEntity.field_6220, (float)targetEntity.field_6283);
        float diff = headLerp - bodyLerp;
        float bodyClamp = (float)class_3532.method_15350((double)class_3532.method_15393((float)(headClamp - diff)), (double)(bodyYaw - bodyYawRange), (double)(bodyYaw + bodyYawRange));
        float pitchClamp = (float)(class_3532.method_15350((double)class_3532.method_16439((float)partialTicks, (float)targetEntity.field_6004, (float)targetEntity.method_36455()), (double)(-pitchRange), (double)pitchRange) + pitch);
        Configs.RotationMode rotationMode = AyamePaperDoll.CONFIGS.rotationMode.getValue();
        if (rotationMode == Configs.RotationMode.LOCK) {
            targetEntity.field_6241 = targetEntity.field_6259 = 180.0f - headClamp;
        }
        if (rotationMode == Configs.RotationMode.LOCK) {
            targetEntity.field_6283 = targetEntity.field_6220 = 180.0f - bodyClamp;
        }
        targetEntity.field_6004 = pitchClamp;
        targetEntity.method_36457(targetEntity.field_6004);
        if (!AyamePaperDoll.CONFIGS.swingHands.getValue().booleanValue()) {
            targetEntity.field_6251 = 0.0f;
            targetEntity.field_6229 = 0.0f;
        }
        if (!AyamePaperDoll.CONFIGS.hurtFlash.getValue().booleanValue()) {
            targetEntity.field_6235 = 0;
        }
        targetEntity.method_20803(0);
        targetEntity.method_5729(0, false);
    }

    private void performRendering(class_1297 targetEntity, double posX, double posY, double size, boolean boat, Vector3f offset, double lightDegree, float partialTicks, class_332 guiGraphics) {
        class_898 entityRenderDispatcher = this.minecraft.method_1561();
        class_897 entityRenderer = entityRenderDispatcher.method_3953(targetEntity);
        class_10017 state = entityRenderer.method_62425(targetEntity, partialTicks);
        state.field_61820 = PaperDollRenderer.getLight(targetEntity, partialTicks);
        state.field_58169 = null;
        state.field_61823.clear();
        state.field_61821 = 0;
        Quaternionf pose = new Quaternionf().rotateZ((float)Math.PI).rotateY((float)Math.PI);
        Quaternionf configRot = new Quaternionf().rotateXYZ((float)Math.toRadians((Double)AyamePaperDoll.CONFIGS.rotationX.getValue()), (float)Math.toRadians((Double)AyamePaperDoll.CONFIGS.rotationY.getValue()), (float)Math.toRadians((Double)AyamePaperDoll.CONFIGS.rotationZ.getValue()));
        pose.mul((Quaternionfc)configRot).rotateY((float)Math.toRadians(lightDegree + 180.0));
        if (targetEntity instanceof class_1690) {
            pose.rotateY((float)Math.toRadians(180.0));
        }
        ((GuiGraphicsInterface)guiGraphics).submitModeRenderState(state, offset, pose, new Quaternionf((Quaternionfc)configRot).conjugate(), (int)posX, (int)posY, (float)size, boat);
    }

    public Rectangle2D.Double getRenderBounds() {
        return this.currentRenderBounds;
    }

    public static class PaperDollPoseStack
    extends class_4587
    implements LockedPaperDoll {
    }

    public static interface LockedPaperDoll {
    }
}

