#version 150

#moj_import <fog.glsl>

uniform sampler2D Sampler0;

uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;

in float vertexDistance;
in vec4 vertexColor;
in vec4 lightMapColor;
in vec4 overlayColor;
in vec2 texCoord0;

out vec4 fragColor;

void main() {
    vec4 color = texture(Sampler0, texCoord0) * vertexColor * ColorModulator;
    color.rgb = mix(overlayColor.rgb, color.rgb, overlayColor.a);
    color *= lightMapColor;
    fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);
	
	// Emissive Office Cape
	vec2 texSize = textureSize(Sampler0,0);
	vec4 preColor = texture(Sampler0, texCoord0);
	
	// Using code for detecting capes from https://github.com/McTsts/mc-core-shaders
	if (texSize.x == 64 && texSize.y == 32 && // check if size matches a cape
			texture(Sampler0, vec2(0.0, 1.0/32.0)).a == 1.0 && texture(Sampler0, vec2(12.0/64.0, 16.0/32.0)).a == 1.0 && // check if skin transparent pixels have color
			(	// support both types of cape texture
				(texture(Sampler0, vec2(0.0, 18.0/32.0)) == vec4(1.0) && texture(Sampler0, vec2(0.99, 0.99)) == vec4(1.0) && texture(Sampler0, vec2(0.99, 0.0)) == vec4(1.0)) // for capes filled with white, check for white pixels
				|| (texture(Sampler0, vec2(25.0/64.0, 25.0/32.0)).a == 0.0 || texture(Sampler0, vec2(30.0/64.0, 10.0/32.0)).a == 0.0 || texture(Sampler0, vec2(9.0/64.0, 25.0/32.0)).a == 0.0)  // otherwise check of transparent pixels
			)
	){
		if (preColor.rgb == vec3(255, 232, 102)/255. || preColor.rgb == vec3(248, 137, 66)/255. || preColor.rgb == vec3(188, 73, 20)/255. || preColor.rgb == vec3(145, 62, 24)/255.) {
			fragColor = linear_fog(preColor, vertexDistance, FogStart, FogEnd, FogColor);
		}
	}
}
