/*
 * Decompiled with CFR 0.152.
 */
package me.realhero.chatprefix;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.message.v1.ClientSendMessageEvents;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;

@Environment(value=EnvType.CLIENT)
public class ChatPrefix
implements ClientModInitializer {
    private static boolean teamChatEnabled = false;
    private static class_304 toggleKey;
    private static String currentPrefix;
    private static final Path configFilePath;

    public void onInitializeClient() {
        ChatPrefix.loadPrefix();
        toggleKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.chatprefix.toggle", class_3675.class_307.field_1668, 75, "category.chatprefix"));
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"setprefix").then(ClientCommandManager.argument((String)"prefix", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            String prefix = StringArgumentType.getString((CommandContext)ctx, (String)"prefix");
            currentPrefix = prefix + " ";
            ChatPrefix.savePrefix(currentPrefix);
            class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a7aPrefix set to: " + currentPrefix)), false);
            return 1;
        }))));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (toggleKey.method_1436()) {
                boolean bl = teamChatEnabled = !teamChatEnabled;
                if (client.field_1724 == null) continue;
                client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("Team Chat Prefix " + (teamChatEnabled ? "Enabled" : "Disabled"))), false);
            }
        });
        ClientSendMessageEvents.MODIFY_CHAT.register((Object)new ClientSendMessageEvents.ModifyChat(this){

            public String modifySendChatMessage(String message) {
                if (teamChatEnabled && !message.startsWith("/")) {
                    String fullCommand = (currentPrefix + message).trim();
                    class_310.method_1551().execute(() -> {
                        if (class_310.method_1551().field_1724 != null) {
                            class_310.method_1551().field_1724.field_3944.method_45730(fullCommand);
                        }
                    });
                    return "";
                }
                return message;
            }
        });
    }

    private static void savePrefix(String prefix) {
        try {
            Files.createDirectories(configFilePath.getParent(), new FileAttribute[0]);
            Files.writeString(configFilePath, (CharSequence)prefix, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            System.err.println("Failed to save prefix: " + e.getMessage());
        }
    }

    private static void loadPrefix() {
        try {
            if (Files.exists(configFilePath, new LinkOption[0])) {
                currentPrefix = Files.readString(configFilePath).trim();
            }
        }
        catch (IOException e) {
            System.err.println("Failed to load prefix: " + e.getMessage());
        }
    }

    static {
        currentPrefix = "/tc ";
        configFilePath = Path.of("config", "chatprefix-config.txt");
    }
}

