package net.pneumono.gravestones.block;

import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2631;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.nbt.*;
import net.pneumono.gravestones.GravestonesConfig;
import net.pneumono.gravestones.content.GravestoneSkeletonEntity;
import net.pneumono.gravestones.content.GravestonesRegistry;
import net.pneumono.gravestones.gravestones.GravestoneDecay;
import net.pneumono.gravestones.multiversion.GraveOwner;
import net.pneumono.gravestones.multiversion.VersionUtil;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import net.pneumono.gravestones.api.GravestonesApi;
//?}

//? if <1.20.6 {
/*import net.minecraft.util.Util;
*///?}

public class TechnicalGravestoneBlockEntity extends AbstractGravestoneBlockEntity {
    private class_2487 contents = new class_2487();
    @Nullable
    private GraveOwner graveOwner;
    private String spawnDateTime;
    private long spawnDateTicks;
    private int deathDamage = 0;
    private int ageDamage = 0;

    public TechnicalGravestoneBlockEntity(class_2338 pos, class_2680 state) {
        super(GravestonesRegistry.TECHNICAL_GRAVESTONE_ENTITY, pos, state);
    }

    //? if >=1.21.8 {
    @Override
    public void method_11007(class_11372 view) {
        super.method_11007(view);
        view.method_71468("contents", class_2487.field_25128, this.contents);
        view.method_71477("owner", GraveOwner.CODEC, this.graveOwner);
        if (this.spawnDateTime != null) {
            view.method_71469("spawnDateTime", this.spawnDateTime);
        }
        if (this.spawnDateTicks != 0) {
            view.method_71466("spawnDateTicks", this.spawnDateTicks);
        }
        view.method_71465("deathDamage", this.deathDamage);
        view.method_71465("ageDamage", this.ageDamage);
    }

    @Override
    public void method_11014(class_11368 view) {
        super.method_11014(view);
        this.contents = view.method_71426("contents", class_2487.field_25128).orElse(new class_2487());
        this.setGraveOwner(view.method_71426("owner", GraveOwner.CODEC).orElse(null));
        this.spawnDateTime = view.method_71428("spawnDateTime", null);
        this.spawnDateTicks = view.method_71425("spawnDateTicks", 0);
        this.deathDamage = view.method_71424("deathDamage", 0);
        this.ageDamage = view.method_71424("ageDamage", 0);
    }
    //?} else if >=1.20.6 {
    /*@Override
    public void writeNbt(NbtCompound nbt, RegistryWrapper.WrapperLookup registries) {
        super.writeNbt(nbt, registries);
        RegistryOps<NbtElement> ops = registries.getOps(NbtOps.INSTANCE);

        VersionUtil.put(ops, nbt, "contents", NbtCompound.CODEC, this.contents);
        if (this.graveOwner != null) {
            VersionUtil.put(ops, nbt, "owner", GraveOwner.CODEC, this.graveOwner);
        }
        if (this.spawnDateTime != null) {
            nbt.putString("spawnDateTime", this.spawnDateTime);
        }
        if (this.spawnDateTicks != 0) {
            nbt.putLong("spawnDateTicks", this.spawnDateTicks);
        }
        nbt.putInt("deathDamage", this.deathDamage);
        nbt.putInt("ageDamage", this.ageDamage);
    }

    @Override
    public void readNbt(NbtCompound nbt, RegistryWrapper.WrapperLookup registries) {
        super.readNbt(nbt, registries);
        RegistryOps<NbtElement> ops = registries.getOps(NbtOps.INSTANCE);

        this.contents = VersionUtil.get(ops, nbt, "contents", NbtCompound.CODEC).orElse(new NbtCompound());
        this.setGraveOwner(VersionUtil.get(ops, nbt, "owner", GraveOwner.CODEC).orElse(null));
        this.spawnDateTime = nbt.getString("spawnDateTime"/^? if >=1.21.5 {^//^, null^//^?}^/);
        this.spawnDateTicks = nbt.getLong("spawnDateTicks"/^? if >=1.21.5 {^//^, 0^//^?}^/);
        this.deathDamage = nbt.getInt("deathDamage"/^? if >=1.21.5 {^//^, 0^//^?}^/);
        this.ageDamage = nbt.getInt("ageDamage"/^? if >=1.21.5 {^//^, 0^//^?}^/);
    }
    *///?} else {
    /*@Override
    public void writeNbt(NbtCompound nbt) {
        super.writeNbt(nbt);

        VersionUtil.put(nbt, "contents", NbtCompound.CODEC, this.contents);
        if (this.graveOwner != null) {
            VersionUtil.put(nbt, "owner", GraveOwner.CODEC, this.graveOwner);
        }
        if (this.spawnDateTime != null) {
            nbt.putString("spawnDateTime", this.spawnDateTime);
        }
        if (this.spawnDateTicks != 0) {
            nbt.putLong("spawnDateTicks", this.spawnDateTicks);
        }
        nbt.putInt("deathDamage", this.deathDamage);
        nbt.putInt("ageDamage", this.ageDamage);
    }

    @Override
    public void readNbt(NbtCompound nbt) {
        super.readNbt(nbt);

        this.contents = VersionUtil.get(nbt, "contents", NbtCompound.CODEC).orElse(new NbtCompound());
        this.setGraveOwner(VersionUtil.get(nbt, "owner", GraveOwner.CODEC).orElse(null));
        this.spawnDateTime = nbt.getString("spawnDateTime");
        this.spawnDateTicks = nbt.getLong("spawnDateTicks");
        this.deathDamage = nbt.getInt("deathDamage");
        this.ageDamage = nbt.getInt("ageDamage");
    }
    *///?}

    //? if >=1.21.5 {
    @Override
    public void method_66473(class_2338 pos, class_2680 oldState) {
        if (method_10997() instanceof class_3218 serverWorld) {
            GravestonesApi.onBreak(serverWorld, pos, getDecay(oldState), this);
        }
        super.method_66473(pos, oldState);
    }
    //?}

    public static void tick(class_1937 world, class_2338 blockPos, class_2680 state, TechnicalGravestoneBlockEntity entity) {
        if (world.method_8608() || world.method_8510() % 20 != 0) {
            return;
        }

        GravestoneDecay.timeDecayGravestone(world, blockPos, state);

        if (GravestonesConfig.SPAWN_GRAVESTONE_SKELETONS.getValue() && world.method_8510() % 900 == 0 && isOwnerNearby(world, entity, blockPos)) {
            spawnSkeletons(world, entity, blockPos);
        }
    }

    private static boolean isOwnerNearby(class_1937 world, TechnicalGravestoneBlockEntity entity, class_2338 blockPos) {
        GraveOwner graveOwner = entity.getGraveOwner();
        if (graveOwner == null) {
            return false;
        }

        class_238 box = /*? if >=1.20.4 {*/class_238.method_54784/*?} else {*//*new Box*//*?}*/(blockPos.method_10087(30).method_10077(50).method_10088(50), blockPos.method_10086(30).method_10076(50).method_10089(50));
        for (class_1297 nearbyEntity : world.method_8335(null, box)) {
            if (nearbyEntity instanceof class_1657 player && VersionUtil.getId(player.method_7334()).equals(graveOwner.getUuid())) {
                return true;
            }
        }

        return false;
    }

    private static void spawnSkeletons(class_1937 world, TechnicalGravestoneBlockEntity entity, class_2338 blockPos) {
        int entityCount = entity.countEntities(world);

        if (entityCount >= 5) {
            return;
        }

        GravestoneSkeletonEntity spawned = new GravestoneSkeletonEntity(world);

        List<class_2338> possiblePos = new ArrayList<>();
        for (int x = -5; x < 6; ++x) {
            for (int y = -5; y < 6; ++y) {
                for (int z = -5; z < 6; ++z) {
                    possiblePos.add(new class_2338(entity.method_11016().method_10263() + x, entity.method_11016().method_10264() + y, entity.method_11016().method_10260() + z));
                }
            }
        }

        Random random = new Random();
        class_2338 finalPos = null;
        while (!possiblePos.isEmpty()) {
            int randInt = random.nextInt(possiblePos.size());
            class_2338 possible = possiblePos.get(randInt);
            possiblePos.remove(randInt);

            boolean tooFar = false;
            while (world.method_8320(possible.method_10074()).method_26215() && !tooFar) {
                if (possible.method_10074().method_10264() < blockPos.method_10087(5).method_10264()) {
                    tooFar = true;
                }
                possible = possible.method_10074();
            }

            if (tooFar) {
                continue;
            }

            if (world.method_8320(possible).method_26215() && world.method_8320(possible.method_10084()).method_26215()) {
                finalPos = possible;
                break;
            }
        }

        if (finalPos == null) {
            finalPos = blockPos;
        }

        spawned.method_23327(finalPos.method_10263() + 0.5, finalPos.method_10264() + 0.1, finalPos.method_10260() + 0.5);
        spawned.method_6092(new class_1293(class_1294.field_5918, -1));
        if (random.nextFloat() > 0.5) {
            spawned.method_5673(class_1304.field_6173, class_1802.field_8102.method_7854());
            spawned.method_5673(class_1304.field_6169, class_1802.field_8267.method_7854());
        } else {
            spawned.method_5673(class_1304.field_6169, class_1802.field_8743.method_7854());
        }
        spawned.method_5946(class_1304.field_6173, 0);
        spawned.method_5946(class_1304.field_6169, 0);

        world.method_8649(spawned);
        TechnicalGravestoneBlock.createSoulParticles(world, finalPos);
        TechnicalGravestoneBlock.createSoulParticles(world, blockPos);
    }

    private int countEntities(class_1937 world) {
        class_238 box = /*? if >=1.20.4 {*/class_238.method_54784/*?} else {*//*new Box*//*?}*/(method_11016().method_10087(15).method_10077(15).method_10088(15), method_11016().method_10086(15).method_10076(15).method_10089(15));
        List<class_1297> entities = world.method_8335(null, box);
        int entityCount = 0;
        for (class_1297 nearbyEntity : entities) {
            if (nearbyEntity instanceof GravestoneSkeletonEntity) {
                entityCount++;
            }
        }
        return entityCount;
    }

    public int getDecay() {
        return getDecay(Objects.requireNonNull(this.method_10997()).method_8320(this.method_11016()));
    }

    public static int getDecay(class_2680 state) {
        return state.method_11654(TechnicalGravestoneBlock.DAMAGE);
    }

    public class_2487 getContents() {
        return this.contents;
    }

    public void setContents(class_2487 contents) {
        this.contents = contents;
        this.method_5431();
    }

    public void setGraveOwner(@Nullable GraveOwner graveOwner) {
        this.graveOwner = graveOwner;

        //? if >=1.21.9 {
        /*this.markDirty();
        *///?} else if >=1.20.6 {
        if (this.graveOwner != null && !this.graveOwner.getProfile().method_57511()) {
            this.graveOwner.getProfile().method_57507().thenAcceptAsync(profile -> {
                this.graveOwner.setProfile(profile);
                this.method_5431();
            }, class_2631.field_45147);
        } else {
            this.method_5431();
        }
        //?} else if >=1.20.2 {
        /*if (this.graveOwner != null && !Util.isBlank(this.graveOwner.getName()) && !SkullBlockEntity.hasTextures(this.graveOwner.getProfile())) {
            SkullBlockEntity.fetchProfile(this.graveOwner.getName()).thenAcceptAsync(profile -> {
                this.graveOwner.setProfile(profile.orElse(this.graveOwner.getProfile()));
                this.markDirty();
            }, SkullBlockEntity.EXECUTOR);
        } else {
            this.markDirty();
        }
        *///?} else {
        /*SkullBlockEntity.loadProperties(this.graveOwner == null ? null : this.graveOwner.getProfile(), profile -> {
            this.graveOwner.setProfile(profile);
            this.markDirty();
        });
        *///?}
    }

    public int getTotalDamage() {
        return this.ageDamage + this.deathDamage;
    }

    public int getAgeDamage() {
        return this.ageDamage;
    }

    public void setAgeDamage(int ageDamage) {
        if (this.getAgeDamage() != ageDamage) {
            this.ageDamage = ageDamage;
            this.method_5431();
        }
    }

    public int getDeathDamage() {
        return this.deathDamage;
    }

    public void setDeathDamage(int deathDamage) {
        this.deathDamage = deathDamage;
        this.method_5431();
    }

    @Nullable
    public GraveOwner getGraveOwner() {
        return this.graveOwner;
    }

    public void setSpawnDate(String spawnDateTime, long spawnDateTicks) {
        this.spawnDateTime = spawnDateTime;
        this.spawnDateTicks = spawnDateTicks;
        this.method_5431();
    }

    public String getSpawnDateTime() {
        return this.spawnDateTime;
    }

    public long getSpawnDateTicks() {
        return this.spawnDateTicks;
    }

    @Override
    public class_2350 getGravestoneDirection() {
        return class_2350.field_11043;
    }
}