package net.pneumono.gravestones.content;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2561;
import net.pneumono.gravestones.Gravestones;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class DeathArgumentType implements ArgumentType<String> {
    protected static final DynamicCommandExceptionType COULD_NOT_READ = new DynamicCommandExceptionType(
            name -> class_2561.method_43470("Could not read death file " + name)
    );

    @Override
    public String parse(StringReader reader) {
        int i = reader.getCursor();

        while (reader.canRead() && isCharValid(reader.peek())) {
            reader.skip();
        }

        return reader.getString().substring(i, reader.getCursor());
    }

    public static boolean isCharValid(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '/' || c == '.' || c == '-';
    }

    @Override
    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        if (!(context.getSource() instanceof class_2168 serverCommandSource)) {
            if (context.getSource() instanceof class_2172 commandSource) {
                return commandSource.method_9261(context);
            }
            return Suggestions.empty();
        }

        File rootFile = Gravestones.GRAVESTONES_ROOT.apply(serverCommandSource.method_9211());

        File[] playerFiles = rootFile.listFiles();
        String[] playerFileStrings = rootFile.list();
        if (playerFiles == null || playerFileStrings == null) return Suggestions.empty();

        List<String> deathFiles = new ArrayList<>();
        for (int i = 0; i < playerFiles.length; ++i) {
            File playerFile = playerFiles[i];
            String[] playerDeaths = playerFile.list();
            if (playerDeaths != null) {
                int finalI = i;
                deathFiles.addAll(Arrays.stream(playerDeaths).map(file -> playerFileStrings[finalI] + "/" + file).toList());
            }
        }

        return class_2172.method_9265(deathFiles, builder);
    }

    public static DeathArgumentType death() {
        return new DeathArgumentType();
    }

    public static class_2487 getDeath(CommandContext<class_2168> context, String name) throws CommandSyntaxException {
        File deathsFile = Gravestones.GRAVESTONES_ROOT.apply(context.getSource().method_9211());
        String file = context.getArgument(name, String.class);
        File deathFile = new File(deathsFile, file);

        class_2487 nbt;
        try {
            nbt = class_2507.method_30613(deathFile/*? if >=1.20.4 {*/.toPath(), class_2505.method_53898()/*?}*/);
        } catch (IOException e) {
            throw COULD_NOT_READ.create(file);
        }
        if (nbt == null) throw DeathArgumentType.COULD_NOT_READ.create(file);
        return nbt;
    }
}
