/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.gravestones.compat;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.core.Accessory;
import io.wispforest.accessories.api.core.AccessoryRegistry;
import io.wispforest.accessories.api.slot.SlotPredicateRegistry;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.impl.core.ExpandedContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.server.MinecraftServer;
import net.pneumono.gravestones.api.GravestoneDataType;
import net.pneumono.gravestones.api.GravestonesApi;
import net.pneumono.gravestones.multiversion.VersionUtil;

public class AccessoriesDataType
extends GravestoneDataType {
    private static final String KEY = "accessories";

    @Override
    public void writeData(class_2487 nbt, DynamicOps<class_2520> ops, class_1657 player) throws Exception {
        MinecraftServer server = player.method_5682();
        if (server != null && server.method_3767().method_8355(Accessories.RULE_KEEP_ACCESSORY_INVENTORY)) {
            return;
        }
        AccessoriesCapability capability = AccessoriesCapability.get((class_1309)player);
        if (capability == null) {
            throw new IllegalStateException("Player {} does not have an AccessoriesCapability");
        }
        ArrayList<SlotReferencePrimitive> list = new ArrayList<SlotReferencePrimitive>();
        for (Map.Entry entry : capability.getContainers().entrySet()) {
            String name = (String)entry.getKey();
            AccessoriesContainer container = (AccessoriesContainer)entry.getValue();
            ExpandedContainer accessories = container.getAccessories();
            for (int index = 0; index < accessories.method_5439(); ++index) {
                class_1799 stack = accessories.method_5438(index);
                if (GravestonesApi.shouldSkipItem(player, stack) || stack.method_7960()) continue;
                accessories.method_5441(index);
                list.add(new SlotReferencePrimitive(stack, name, index, false));
            }
            ExpandedContainer cosmetics = container.getCosmeticAccessories();
            for (int index = 0; index < cosmetics.method_5439(); ++index) {
                class_1799 stack = cosmetics.method_5438(index);
                if (GravestonesApi.shouldSkipItem(player, stack) || stack.method_7960()) continue;
                cosmetics.method_5441(index);
                list.add(new SlotReferencePrimitive(stack, name, index, true));
            }
        }
        VersionUtil.put(ops, nbt, KEY, SlotReferencePrimitive.CODEC.listOf(), list);
    }

    @Override
    public void onBreak(class_2487 nbt, DynamicOps<class_2520> ops, class_1937 world, class_2338 pos, int decay) {
        List list = VersionUtil.get(ops, nbt, KEY, SlotReferencePrimitive.CODEC.listOf()).orElse(null);
        if (list == null || list.isEmpty()) {
            return;
        }
        this.dropStacks(world, pos, list.stream().map(SlotReferencePrimitive::stack).toList());
    }

    @Override
    public void onCollect(class_2487 nbt, DynamicOps<class_2520> ops, class_1937 world, class_2338 pos, class_1657 player, int decay) {
        List list = VersionUtil.get(ops, nbt, KEY, SlotReferencePrimitive.CODEC.listOf()).orElse(null);
        if (list == null || list.isEmpty()) {
            return;
        }
        AccessoriesCapability capability = AccessoriesCapability.get((class_1309)player);
        if (capability == null) {
            AccessoriesDataType.warn("Player {} does not have an AccessoriesCapability. Any accessories will be dropped on the ground", player.method_5477().getString());
            this.dropStacks(world, pos, list.stream().map(SlotReferencePrimitive::stack).toList());
            return;
        }
        ArrayList<class_1799> remaining = new ArrayList<class_1799>();
        for (SlotReferencePrimitive primitive : list) {
            class_1799 newStack = primitive.stack;
            if (newStack.method_7960()) continue;
            int index = primitive.index;
            AccessoriesContainer container = (AccessoriesContainer)capability.getContainers().get(primitive.slotName());
            if (container == null || container.getSize() <= 0) {
                remaining.add(newStack);
                continue;
            }
            SlotReference reference = SlotReference.of((class_1309)player, (String)primitive.slotName(), (int)primitive.index());
            boolean canInsert = SlotPredicateRegistry.canInsertIntoSlot((class_1799)newStack, (SlotReference)reference);
            if (!canInsert) {
                remaining.add(newStack);
                continue;
            }
            ExpandedContainer accessories = primitive.cosmetic ? container.getCosmeticAccessories() : container.getAccessories();
            class_1799 oldStack = accessories.method_5438(index);
            boolean canUnequipOldStack = AccessoryRegistry.canUnequip((class_1799)oldStack, (SlotReference)reference);
            boolean canInsertNewStack = SlotPredicateRegistry.canInsertIntoSlot((class_1799)newStack, (SlotReference)reference);
            if (!oldStack.method_7960() || !canUnequipOldStack || !canInsertNewStack) continue;
            Accessory accessory = AccessoryRegistry.getAccessoryOrDefault((class_1799)oldStack);
            class_1799 splitStack = newStack.method_7971(accessory.maxStackSize(newStack));
            accessories.method_5447(index, splitStack);
            if (newStack.method_7960()) continue;
            remaining.add(newStack);
        }
        this.dropStacks(world, pos, remaining);
    }

    public record SlotReferencePrimitive(class_1799 stack, String slotName, int index, boolean cosmetic) {
        public static final Codec<SlotReferencePrimitive> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1799.field_24671.fieldOf("stack").forGetter(SlotReferencePrimitive::stack), (App)Codec.STRING.fieldOf("slot_name").forGetter(SlotReferencePrimitive::slotName), (App)Codec.INT.fieldOf("index").forGetter(SlotReferencePrimitive::index), (App)Codec.BOOL.fieldOf("cosmetic").forGetter(SlotReferencePrimitive::cosmetic)).apply((Applicative)instance, SlotReferencePrimitive::new));
    }
}

