/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.gravestones.content;

import java.util.Objects;
import java.util.stream.IntStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_3728;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_8242;
import net.minecraft.class_837;
import net.minecraft.class_8710;
import net.pneumono.gravestones.Gravestones;
import net.pneumono.gravestones.block.AestheticGravestoneBlockEntity;
import net.pneumono.gravestones.content.GravestonesRegistry;
import net.pneumono.gravestones.networking.UpdateGravestoneC2SPayload;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class AestheticGravestoneEditScreen
extends class_437 {
    public static final int TEXT_WIDTH = 86;
    private static final int TEXT_LINE_HEIGHT = 14;
    protected final AestheticGravestoneBlockEntity blockEntity;
    private class_8242 text;
    private final String[] messages;
    private int ticksSinceOpened;
    private int currentRow;
    @Nullable
    private class_3728 selectionManager;
    private final class_2960 texture;

    public AestheticGravestoneEditScreen(AestheticGravestoneBlockEntity blockEntity, boolean filtered) {
        super((class_2561)class_2561.method_43471((String)"gravestones.edit_text"));
        this.blockEntity = blockEntity;
        this.text = blockEntity.getText();
        this.messages = (String[])IntStream.range(0, 4).mapToObj(line -> this.text.method_49859(line, filtered)).map(class_2561::getString).toArray(String[]::new);
        class_1937 world = blockEntity.method_10997();
        class_2248 block = world != null ? world.method_8320(blockEntity.method_11016()).method_26204() : GravestonesRegistry.GRAVESTONE;
        this.texture = this.getTexture(block);
    }

    private class_2960 getTexture(class_2248 block) {
        String name = block == GravestonesRegistry.GRAVESTONE_CHIPPED ? "chipped" : (block == GravestonesRegistry.GRAVESTONE_DAMAGED ? "damaged" : "default");
        return Gravestones.id("textures/gui/gravestone_" + name + ".png");
    }

    protected void method_25426() {
        Objects.requireNonNull(this.field_22787);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.finishEditing()).method_46434(this.field_22789 / 2 - 100, this.field_22790 / 4 + 144, 200, 20).method_46431());
        this.selectionManager = new class_3728(() -> this.messages[this.currentRow], this::setCurrentRowMessage, class_3728.method_27550((class_310)this.field_22787), class_3728.method_27561((class_310)this.field_22787), string -> this.field_22787.field_1772.method_1727(string) <= 86);
    }

    public void method_25393() {
        ++this.ticksSinceOpened;
        if (!this.canEdit()) {
            this.finishEditing();
        }
    }

    private boolean canEdit() {
        return this.field_22787 != null && this.field_22787.field_1724 != null && !this.blockEntity.method_11015() && !this.blockEntity.isPlayerTooFarToEdit(this.field_22787.field_1724.method_5667());
    }

    public boolean method_25404(int input, int scanCode, int modifiers) {
        Objects.requireNonNull(this.selectionManager);
        if (this.isUp(input)) {
            this.currentRow = this.currentRow - 1 & 3;
            this.selectionManager.method_16204();
            return true;
        }
        if (this.isDownOrEnter(input)) {
            this.currentRow = this.currentRow + 1 & 3;
            this.selectionManager.method_16204();
            return true;
        }
        if (this.selectionManager.method_16202(input)) {
            return true;
        }
        return super.method_25404(input, scanCode, modifiers);
    }

    public boolean isUp(int input) {
        return input == 265;
    }

    public boolean isDownOrEnter(int input) {
        return input == 264 || input == 257 || input == 335;
    }

    public boolean method_25400(char input, int modifiers) {
        Objects.requireNonNull(this.selectionManager).method_16199(input);
        return true;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        super.method_25394(context, mouseX, mouseY, deltaTicks);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 40, 0xFFFFFF);
        this.renderGravestone(context);
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        this.method_52752(context);
    }

    public void method_25419() {
        this.finishEditing();
    }

    public void method_25432() {
        UpdateGravestoneC2SPayload payload = new UpdateGravestoneC2SPayload(this.blockEntity.method_11016(), this.messages[0], this.messages[1], this.messages[2], this.messages[3]);
        ClientPlayNetworking.send((class_8710)payload);
    }

    public boolean method_25421() {
        return false;
    }

    private void renderGravestone(class_332 context) {
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)this.field_22789 / 2.0f, 125.0f, 50.0f);
        context.method_51448().method_22903();
        this.renderGravestoneBackground(context);
        context.method_51448().method_22909();
        this.renderGravestoneText(context);
        context.method_51448().method_22909();
    }

    protected void renderGravestoneBackground(class_332 context) {
        context.method_51448().method_22905(7.0f, 7.0f, 1.0f);
        context.method_25290(this.texture, -8, -8, 0.0f, 0.0f, 16, 16, 16, 16);
    }

    private void renderGravestoneText(class_332 context) {
        String message;
        int i;
        int color = this.text.method_49856() ? this.text.method_49872().method_16357() : class_837.method_37311((class_8242)this.text);
        boolean shouldFlashCursor = this.ticksSinceOpened / 6 % 2 == 0;
        Objects.requireNonNull(this.selectionManager);
        int selectionStart = this.selectionManager.method_16201();
        int selectionEnd = this.selectionManager.method_16203();
        int lineHeightOffset = 28;
        int adjustedY = this.currentRow * 14 - lineHeightOffset;
        for (i = 0; i < this.messages.length; ++i) {
            message = this.messages[i];
            if (message == null) continue;
            if (this.field_22793.method_1726()) {
                message = this.field_22793.method_1721(message);
            }
            int x = -this.field_22793.method_1727(message) / 2;
            context.method_51433(this.field_22793, message, x, i * 14 - lineHeightOffset, color, false);
            if (i != this.currentRow || selectionStart < 0 || !shouldFlashCursor) continue;
            int substringWidth = this.field_22793.method_1727(message.substring(0, Math.min(selectionStart, message.length())));
            int adjustedX = substringWidth - this.field_22793.method_1727(message) / 2;
            if (selectionStart < message.length()) continue;
            context.method_51433(this.field_22793, "_", adjustedX, adjustedY, color, false);
        }
        for (i = 0; i < this.messages.length; ++i) {
            message = this.messages[i];
            if (message == null || i != this.currentRow || selectionStart < 0) continue;
            int substringWidth = this.field_22793.method_1727(message.substring(0, Math.min(selectionStart, message.length())));
            int adjustedX = substringWidth - this.field_22793.method_1727(message) / 2;
            if (shouldFlashCursor && selectionStart < message.length()) {
                context.method_25294(adjustedX, adjustedY - 1, adjustedX + 1, adjustedY + 14, 0xFF000000 | color);
            }
            if (selectionEnd == selectionStart) continue;
            int start = Math.min(selectionStart, selectionEnd);
            int end = Math.max(selectionStart, selectionEnd);
            int widthStart = this.field_22793.method_1727(message.substring(0, start)) - this.field_22793.method_1727(message) / 2;
            int widthEnd = this.field_22793.method_1727(message.substring(0, end)) - this.field_22793.method_1727(message) / 2;
            int startX = Math.min(widthStart, widthEnd);
            int endX = Math.max(widthStart, widthEnd);
            context.method_51739(class_1921.method_51786(), startX, adjustedY, endX, adjustedY + 14, -16776961);
        }
    }

    private void setCurrentRowMessage(String message) {
        this.messages[this.currentRow] = message;
        this.text = this.text.method_49857(this.currentRow, (class_2561)class_2561.method_43470((String)message));
        this.blockEntity.setText(this.text);
    }

    private void finishEditing() {
        Objects.requireNonNull(this.field_22787).method_1507(null);
    }
}

