package net.pneumono.gravestones.api;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_3218;

/**
 * Callback after a gravestone is collected.
 *
 * <p>Called after all other gravestone processing. At this point the contents have been returned to the player,
 * and the gravestone block itself has been broken.
 *
 * <p>Should not be used for collecting custom contents from graves.
 * If you need to add custom contents, see {@link GravestoneDataType}
 *
 * @see GravestoneDataType
 */
public interface GravestoneCollectedCallback {
    Event<GravestoneCollectedCallback> EVENT = EventFactory.createArrayBacked(GravestoneCollectedCallback.class,
            listeners -> (world, player, gravePos) -> {
                for (GravestoneCollectedCallback listener : listeners) {
                    listener.afterGravestoneCollect(world, player, gravePos);
                }
            }
    );

    void afterGravestoneCollect(class_3218 world, class_1657 player, class_2338 gravePos);
}
