package net.pneumono.gravestones.content;

import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1928;
import net.minecraft.class_6880;
import net.minecraft.class_9304;
import net.pneumono.gravestones.Gravestones;
import net.pneumono.gravestones.GravestonesConfig;
import net.pneumono.gravestones.api.CancelGravestonePlacementCallback;
import net.pneumono.gravestones.api.GravestonesApi;
import net.pneumono.gravestones.api.SkipItemCallback;

/**
 * Contains usages of the Gravestones API by Gravestones itself. These can be used as examples if necessary.
 */
public class GravestonesApiUsages {
    public static void register() {
        GravestonesApi.registerDataType(Gravestones.id("inventory"), new PlayerInventoryDataType());
        GravestonesApi.registerDataType(Gravestones.id("experience"), new ExperienceDataType());

        SkipItemCallback.EVENT.register((player, itemStack, slot) ->
                itemStack.method_31573(GravestonesApi.ITEM_SKIPS_GRAVESTONES) ||
                //? if >=1.21.1 {
                /*EnchantmentHelper.hasAnyEnchantmentsIn(itemStack, GravestonesApi.ENCHANTMENT_SKIPS_GRAVESTONES)
                *///?} else {
                hasSkippableEnchantments(itemStack)
                //?}
        );
        SkipItemCallback.EVENT.register((player, itemStack, slot) ->
                //? if >=1.21.1 {
                /*EnchantmentHelper.hasAnyEnchantmentsWith(itemStack, EnchantmentEffectComponentTypes.PREVENT_EQUIPMENT_DROP)
                *///?} else {
                class_1890.method_8221(itemStack)
                //?}
        );

        CancelGravestonePlacementCallback.EVENT.register((world, player, deathPos) ->
                world.method_8450().method_8355(class_1928.field_19389) && !GravestonesConfig.SPAWN_GRAVESTONES_WITH_KEEPINV.getValue()
        );
        CancelGravestonePlacementCallback.EVENT.register((world, player, deathPos) ->
                player.method_7337() && !GravestonesConfig.SPAWN_GRAVESTONES_IN_CREATIVE.getValue()
        );
    }

    //? if <1.20.6 {
    /*@SuppressWarnings("deprecation")
     *///?}
    //? if <1.21.1 {
    private static boolean hasSkippableEnchantments(class_1799 stack) {
        //? if >=1.20.6 {
        class_9304 component = stack.method_58657();
        for (class_6880<class_1887> enchantment : component.method_57534()) {
            if (enchantment.method_40220(GravestonesApi.ENCHANTMENT_SKIPS_GRAVESTONES)) {
                return true;
            }
        }
        return false;
        //?} else {
        /*for (RegistryEntry<Enchantment> enchantment : EnchantmentHelper.get(stack).keySet().stream()
                .map(Registries.ENCHANTMENT::getEntry)
                .toList()
        ) {
            if (enchantment.isIn(GravestonesApi.ENCHANTMENT_SKIPS_GRAVESTONES)) {
                return true;
            }
        }
        return false;
        *///?}
    }
    //?}
}
