/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.gravestones.block;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.UnaryOperator;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import net.minecraft.class_5712;
import net.minecraft.class_5837;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_8242;
import net.minecraft.class_9288;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import net.pneumono.gravestones.Gravestones;
import net.pneumono.gravestones.block.AbstractGravestoneBlockEntity;
import net.pneumono.gravestones.content.GravestonesRegistry;
import net.pneumono.gravestones.multiversion.VersionUtil;
import net.pneumono.pneumonocore.util.MultiVersionUtil;
import org.jetbrains.annotations.Nullable;

public class AestheticGravestoneBlockEntity
extends AbstractGravestoneBlockEntity {
    private class_1799 headStack = class_1799.field_8037;
    @Nullable
    private UUID editor;
    private class_8242 text = this.createText();
    private boolean waxed;

    public AestheticGravestoneBlockEntity(class_2338 pos, class_2680 state) {
        super(GravestonesRegistry.AESTHETIC_GRAVESTONE_ENTITY, pos, state);
    }

    protected class_8242 createText() {
        return new class_8242();
    }

    public void method_11007(class_2487 nbt, class_7225.class_7874 registries) {
        super.method_11007(nbt, registries);
        class_6903 ops = registries.method_57093((DynamicOps)class_2509.field_11560);
        if (!this.headStack.method_7960()) {
            VersionUtil.put((DynamicOps<class_2520>)ops, nbt, "head", class_1799.field_24671, this.headStack);
        }
        VersionUtil.put((DynamicOps<class_2520>)ops, nbt, "text", class_8242.field_43298, this.text);
        nbt.method_10556("is_waxed", this.waxed);
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 registries) {
        super.method_11014(nbt, registries);
        class_6903 ops = registries.method_57093((DynamicOps)class_2509.field_11560);
        this.headStack = VersionUtil.get((DynamicOps<class_2520>)ops, nbt, "head", class_1799.field_24671).orElse(class_1799.field_8037);
        this.text = VersionUtil.get((DynamicOps<class_2520>)ops, nbt, "text", class_8242.field_43298).map(this::parseLines).orElseGet(class_8242::new);
        this.waxed = nbt.method_10577("is_waxed");
    }

    protected void method_57567(class_9323.class_9324 builder) {
        super.method_57567(builder);
        builder.method_57840(class_9334.field_49622, (Object)class_9288.method_57493(List.of(this.headStack)));
    }

    protected void method_57568(class_2586.class_9473 components) {
        super.method_57568(components);
        this.headStack = ((class_9288)components.method_58695(class_9334.field_49622, (Object)class_9288.field_49334)).method_58114();
    }

    public void method_57569(class_2487 nbt) {
        super.method_57569(nbt);
        nbt.method_10551("head");
    }

    private class_8242 parseLines(class_8242 signText) {
        for (int i = 0; i < 4; ++i) {
            class_2561 text = this.parseLine(signText.method_49859(i, false));
            class_2561 text2 = this.parseLine(signText.method_49859(i, true));
            signText = signText.method_49858(i, text, text2);
        }
        return signText;
    }

    private class_2561 parseLine(class_2561 text) {
        class_1937 world = this.field_11863;
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            try {
                return class_2564.method_10881((class_2168)AestheticGravestoneBlockEntity.createCommandSource(null, (class_1937)serverWorld, this.field_11867), (class_2561)text, null, (int)0);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        return text;
    }

    public void tryChangeText(class_1657 player, List<class_5837> messages) {
        if (!this.isWaxed() && player.method_5667().equals(this.getEditor()) && this.field_11863 != null) {
            this.changeText(text -> this.getTextWithMessages(player, messages, (class_8242)text));
            this.setEditor(null);
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
        } else {
            Gravestones.LOGGER.warn("Player {} just tried to change non-editable gravestone", (Object)player.method_5477().getString());
        }
    }

    public boolean changeText(UnaryOperator<class_8242> textChanger) {
        return this.setText((class_8242)textChanger.apply(this.getText()));
    }

    private class_8242 getTextWithMessages(class_1657 player, List<class_5837> messages, class_8242 text) {
        for (int i = 0; i < messages.size(); ++i) {
            class_5837 filteredMessage = messages.get(i);
            class_2583 style = text.method_49859(i, player.method_33793()).method_10866();
            text = player.method_33793() ? text.method_49857(i, (class_2561)class_2561.method_43470((String)filteredMessage.method_45061()).method_10862(style)) : text.method_49858(i, (class_2561)class_2561.method_43470((String)filteredMessage.comp_841()).method_10862(style), (class_2561)class_2561.method_43470((String)filteredMessage.method_45061()).method_10862(style));
        }
        return text;
    }

    public boolean runCommandClickEvent(class_1657 player, class_1937 world, class_2338 pos) {
        boolean hasRunCommand = false;
        for (class_2561 text : this.getText().method_49877(player.method_33793())) {
            class_2583 style = text.method_10866();
            class_2558 clickEvent = style.method_10970();
            if (clickEvent == null || clickEvent.method_10845() != class_2558.class_2559.field_11750) continue;
            String value = clickEvent.method_10844();
            class_2170 manager = Objects.requireNonNull(MultiVersionUtil.getWorld((class_1297)player).method_8503()).method_3734();
            class_2168 commandSource = AestheticGravestoneBlockEntity.createCommandSource(player, world, pos);
            String command = value.startsWith("/") ? value.substring(1) : value;
            manager.method_9249(manager.method_9235().parse(command, (Object)commandSource), command);
            hasRunCommand = true;
        }
        return hasRunCommand;
    }

    private static class_2168 createCommandSource(@Nullable class_1657 player, class_1937 world, class_2338 pos) {
        String string = player == null ? "Gravestone" : player.method_5477().getString();
        class_5250 text = player == null ? class_2561.method_43470((String)"Gravestone") : player.method_5476();
        return new class_2168(class_2165.field_17395, class_243.method_24953((class_2382)pos), class_241.field_1340, (class_3218)world, 2, string, (class_2561)text, world.method_8503(), (class_1297)player);
    }

    public boolean isPlayerTooFarToEdit(UUID uuid) {
        if (this.field_11863 == null) {
            return true;
        }
        class_1657 playerEntity = this.field_11863.method_18470(uuid);
        return playerEntity == null || !playerEntity.method_56093(this.method_11016(), 4.0);
    }

    @Override
    public class_2350 getGravestoneDirection() {
        class_2680 state;
        class_1937 world = this.method_10997();
        if (world != null && (state = world.method_8320(this.method_11016())).method_28501().contains(class_2741.field_12481)) {
            return (class_2350)state.method_11654((class_2769)class_2741.field_12481);
        }
        return class_2350.field_11043;
    }

    public void setHeadStack(@Nullable class_1309 entity, class_1799 headStack) {
        class_1657 player;
        this.headStack = headStack.method_46651(1);
        if (!(entity instanceof class_1657) || !(player = (class_1657)entity).method_7337()) {
            headStack.method_7934(1);
        }
        this.updateListeners();
        Objects.requireNonNull(this.method_10997()).method_43276((class_6880)class_5712.field_28733, this.method_11016(), class_5712.class_7397.method_43286((class_1297)entity, (class_2680)this.method_11010()));
    }

    public class_1799 getHeadStack() {
        return this.headStack;
    }

    public void setEditor(@Nullable UUID editor) {
        this.editor = editor;
    }

    @Nullable
    public UUID getEditor() {
        return this.editor;
    }

    public boolean setText(class_8242 text) {
        if (this.text != text) {
            this.text = text;
            this.updateListeners();
            return true;
        }
        return false;
    }

    public class_8242 getText() {
        return this.text;
    }

    public boolean setWaxed(boolean waxed) {
        if (this.waxed != waxed) {
            this.waxed = waxed;
            this.updateListeners();
            return true;
        }
        return false;
    }

    public boolean isWaxed() {
        return this.waxed;
    }

    private void updateListeners() {
        this.method_5431();
        Objects.requireNonNull(this.field_11863).method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
    }
}

