/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.gravestones.gravestones;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2874;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import net.pneumono.gravestones.Gravestones;
import net.pneumono.gravestones.GravestonesConfig;
import net.pneumono.gravestones.api.CancelGravestonePlacementCallback;
import net.pneumono.gravestones.api.GravestonePlacedCallback;
import net.pneumono.gravestones.api.GravestonesApi;
import net.pneumono.gravestones.block.TechnicalGravestoneBlockEntity;
import net.pneumono.gravestones.content.GravestonesRegistry;
import net.pneumono.gravestones.gravestones.GravestoneDataSaving;
import net.pneumono.gravestones.gravestones.GravestoneDecay;
import net.pneumono.gravestones.gravestones.GravestoneManager;
import net.pneumono.gravestones.gravestones.GravestonePlacement;
import net.pneumono.gravestones.gravestones.GravestoneTime;
import net.pneumono.gravestones.gravestones.RecentGraveHistory;
import net.pneumono.gravestones.multiversion.GraveOwner;
import net.pneumono.gravestones.multiversion.VersionUtil;
import net.pneumono.pneumonocore.util.MultiVersionUtil;

public class GravestoneCreation
extends GravestoneManager {
    public static void create(class_1657 player) {
        class_1937 world = MultiVersionUtil.getWorld((class_1297)player);
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        GravestoneCreation.checkConsoleInfoConfig();
        GravestoneCreation.info("----- Beginning Gravestone Creation -----");
        GravestoneCreation.info("If you don't want to see this, disable 'Console Info' in the configs!");
        GravestoneCreation.create(serverWorld, player);
        GravestoneCreation.info("----- Finishing Gravestone Creation -----");
    }

    private static void create(class_3218 deathWorld, class_1657 player) {
        class_3218 class_32182;
        class_4208 deathPos = VersionUtil.createGlobalPos((class_5321<class_1937>)deathWorld.method_27983(), player.method_24515());
        MinecraftServer server = deathWorld.method_8503();
        GravestoneCreation.info("Checking if Gravestone Placement should be cancelled...");
        if (((CancelGravestonePlacementCallback)CancelGravestonePlacementCallback.EVENT.invoker()).shouldCancel(deathWorld, player, deathPos)) {
            GravestoneCreation.info("Placement cancelled!");
            return;
        }
        GravestoneCreation.info("Placement not cancelled");
        CompletableFuture<List> historiesFuture = CompletableFuture.supplyAsync(() -> {
            GravestoneCreation.info("Reading gravestone history...");
            return GravestoneDataSaving.readHistories(server);
        });
        GravestoneCreation.info("Creating gravestone contents data...");
        class_2487 contents = GravestoneCreation.createContentsData(player);
        CompletableFuture.runAsync(() -> {
            GravestoneCreation.info("Backing up gravestone contents data...");
            GravestoneDataSaving.saveBackup(contents, player);
        });
        GravestoneCreation.info("Calculating gravestone placement position...");
        class_4208 gravestonePos = GravestoneCreation.getPlacementPos(deathWorld, player, deathPos);
        historiesFuture.thenAcceptAsync(histories -> {
            histories = new ArrayList<RecentGraveHistory>((Collection<RecentGraveHistory>)histories);
            RecentGraveHistory history = GravestoneCreation.getHistory(histories, player.method_5667());
            GravestoneCreation.info("Updating gravestone history...");
            RecentGraveHistory newHistory = history == null ? new RecentGraveHistory(player.method_5667(), gravestonePos) : history.getShifted(gravestonePos);
            histories.add(newHistory);
            GravestoneCreation.info("Writing updated gravestone history...");
            GravestoneDataSaving.writeData(server, histories);
        });
        String playerName = VersionUtil.getName(player.method_7334());
        GravestoneCreation.info("Placing gravestone...");
        if (gravestonePos == null || !((class_32182 = server.method_3847(VersionUtil.getDimension(gravestonePos))) instanceof class_3218)) {
            GravestonesApi.onBreak(deathWorld, VersionUtil.getPos(deathPos), 0, contents == null ? new class_2487() : contents);
            Gravestones.LOGGER.info("Failed to place {}'s Gravestone! The items have been dropped on the ground", (Object)playerName);
            return;
        }
        class_3218 graveWorld = class_32182;
        GravestoneCreation.placeGravestone(server, gravestonePos);
        Gravestones.LOGGER.info("Placed {}'s Gravestone at {}", (Object)playerName, (Object)GravestoneCreation.posToString(gravestonePos));
        GravestoneCreation.info("Inserting contents into gravestone...");
        GravestoneCreation.insertGravestoneContents(graveWorld, player, gravestonePos, contents);
        GravestoneCreation.info("Broadcasting chat message... (if enabled)");
        if (((Boolean)GravestonesConfig.BROADCAST_COORDINATES_IN_CHAT.getValue()).booleanValue()) {
            server.method_3760().method_43514((class_2561)class_2561.method_43469((String)"gravestones.grave_spawned", (Object[])new Object[]{playerName, GravestoneCreation.posToString(VersionUtil.getPos(gravestonePos))}), false);
        }
        GravestoneCreation.info("Damaging existing gravestones... (if enabled)");
        try {
            RecentGraveHistory history = GravestoneCreation.getHistory(new ArrayList<RecentGraveHistory>(historiesFuture.get()), player.method_5667());
            if (history != null) {
                GravestoneDecay.deathDamageOldGravestones(server, history.getList(), gravestonePos);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            GravestoneCreation.error("Failed to damage existing gravestones", e);
        }
        GravestoneCreation.info("Invoking GravestonePlacedCallbacks...");
        ((GravestonePlacedCallback)GravestonePlacedCallback.EVENT.invoker()).afterGravestonePlace(deathWorld, player, deathPos, gravestonePos);
    }

    public static RecentGraveHistory getHistory(List<RecentGraveHistory> histories, UUID uuid) {
        RecentGraveHistory history = null;
        for (int i = 0; i < histories.size(); ++i) {
            RecentGraveHistory checkedHistory = histories.get(i);
            if (!checkedHistory.owner().equals(uuid)) continue;
            history = histories.remove(i);
            break;
        }
        return history;
    }

    private static class_2487 createContentsData(class_1657 player) {
        class_2487 contents;
        try {
            contents = GravestonesApi.getDataToInsert(player);
        }
        catch (Exception e) {
            return new class_2487();
        }
        return contents;
    }

    private static void insertGravestoneContents(class_3218 world, class_1657 player, class_4208 gravestonePos, class_2487 contents) {
        class_2586 class_25862 = world.method_8321(VersionUtil.getPos(gravestonePos));
        if (!(class_25862 instanceof TechnicalGravestoneBlockEntity)) {
            return;
        }
        TechnicalGravestoneBlockEntity gravestone = (TechnicalGravestoneBlockEntity)class_25862;
        gravestone.setContents(contents);
        gravestone.setGraveOwner(new GraveOwner(player.method_7334()));
        gravestone.setSpawnDate(GravestoneTime.READABLE.format(new Date()), world.method_8510());
        world.method_8413(VersionUtil.getPos(gravestonePos), gravestone.method_11010(), gravestone.method_11010(), 2);
    }

    private static class_4208 getPlacementPos(class_3218 world, class_1657 player, class_4208 deathPos) {
        class_2874 dimension = world.method_8597();
        class_4208 clampedDeathPos = VersionUtil.createGlobalPos(VersionUtil.getDimension(deathPos), VersionUtil.getPos(deathPos).method_33096(class_3532.method_15340((int)VersionUtil.getPos(deathPos).method_10264(), (int)dimension.comp_651(), (int)(dimension.comp_651() + dimension.comp_652()))));
        class_4208 validPos = GravestonePlacement.getRedirectableValidPos(world, player, clampedDeathPos);
        if (validPos == null || world.method_8503().method_3847(VersionUtil.getDimension(validPos)) == null) {
            return null;
        }
        return validPos;
    }

    protected static void placeGravestone(MinecraftServer server, class_4208 gravestonePos) {
        class_3218 world = server.method_3847(VersionUtil.getDimension(gravestonePos));
        if (world == null) {
            return;
        }
        class_2338 pos = VersionUtil.getPos(gravestonePos);
        class_2680 gravestoneBlock = GravestonesRegistry.GRAVESTONE_TECHNICAL.method_9564();
        if (world.method_8320(pos).method_26227().method_15767(class_3486.field_15517)) {
            gravestoneBlock = (class_2680)gravestoneBlock.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true));
        }
        world.method_22352(pos, true);
        world.method_8501(pos, gravestoneBlock);
    }
}

