package net.pneumono.gravestones.content;

import net.fabricmc.fabric.api.command.v2.ArgumentTypeRegistry;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1792;
import net.minecraft.class_1887;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2319;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3446;
import net.minecraft.class_3468;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5837;
import net.minecraft.class_6862;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.registry.*;
import net.pneumono.gravestones.Gravestones;
import net.pneumono.gravestones.block.*;
import net.pneumono.gravestones.networking.UpdateGravestoneC2SPayload;
import net.pneumono.pneumonocore.util.MultiVersionUtil;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

//? if >=1.20.6 {
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.pneumono.gravestones.networking.GravestoneEditorOpenS2CPayload;
//?}

public class GravestonesRegistry {
    public static final class_2248 GRAVESTONE_TECHNICAL = registerGravestone("gravestone_technical",
            TechnicalGravestoneBlock::new, class_4970.class_2251.method_9630(class_2246.field_10340).method_9629(-1.0F, 3600000.0F).method_22488());
    public static final class_2248 GRAVESTONE = registerAestheticGravestone("gravestone",
            AestheticGravestoneBlock::new, class_4970.class_2251.method_9630(class_2246.field_10340).method_9632(3.5F).method_22488().method_29292());
    public static final class_2248 GRAVESTONE_CHIPPED = registerAestheticGravestone("gravestone_chipped",
            AestheticGravestoneBlock::new, class_4970.class_2251.method_9630(class_2246.field_10340).method_9632(3.5F).method_22488().method_29292());
    public static final class_2248 GRAVESTONE_DAMAGED = registerAestheticGravestone("gravestone_damaged",
            AestheticGravestoneBlock::new, class_4970.class_2251.method_9630(class_2246.field_10340).method_9632(3.5F).method_22488().method_29292());

    public static class_2591<TechnicalGravestoneBlockEntity> TECHNICAL_GRAVESTONE_ENTITY = class_2378.method_10230(
            class_7923.field_41181, Gravestones.id("technical_gravestone"), FabricBlockEntityTypeBuilder.create(
                    TechnicalGravestoneBlockEntity::new,
                    GRAVESTONE_TECHNICAL
            ).build()
    );
    public static class_2591<AestheticGravestoneBlockEntity> AESTHETIC_GRAVESTONE_ENTITY = class_2378.method_10230(
            class_7923.field_41181, Gravestones.id("aesthetic_gravestone"), FabricBlockEntityTypeBuilder.create(
                    AestheticGravestoneBlockEntity::new,
                    GRAVESTONE, GRAVESTONE_CHIPPED, GRAVESTONE_DAMAGED
            )/*? if >=1.21.4 {*/.canPotentiallyExecuteCommands(true)/*?}*/.build()
    );

    public static final class_1299<GravestoneSkeletonEntity> GRAVESTONE_SKELETON_ENTITY_TYPE = class_2378.method_10230(
            class_7923.field_41177,
            Gravestones.id("gravestone_skeleton"),
            class_1299.class_1300.<GravestoneSkeletonEntity>method_5903(GravestoneSkeletonEntity::new, class_1311.field_17715)
                    //? if >=1.20.6 {
                    .method_17687(0.6F, 1.99F)
                    //?} else {
                    /*.setDimensions(0.6F, 1.99F)
                    *///?}
                    .method_27299(8)
                    //? if >=1.21.3 {
                    .method_5905(class_5321.method_29179(class_7924.field_41266, Gravestones.id("gravestone_skeleton")))
                    //?} else {
                    /*.build("gravestone_skeleton")
                    *///?}
    );

    /**
     * @deprecated Use {@link net.pneumono.gravestones.api.GravestonesApi#ITEM_SKIPS_GRAVESTONES ITEM_SKIPS_GRAVESTONES} instead
     */
    @Deprecated
    public static final class_6862<class_1792> ITEM_SKIPS_GRAVESTONES = class_6862.method_40092(class_7924.field_41197, Gravestones.id("skips_gravestones"));
    /**
     * @deprecated Use {@link net.pneumono.gravestones.api.GravestonesApi#ENCHANTMENT_SKIPS_GRAVESTONES ENCHANTMENT_SKIPS_GRAVESTONES} instead
     */
    @Deprecated
    public static final class_6862<class_1887> ENCHANTMENT_SKIPS_GRAVESTONES = class_6862.method_40092(class_7924.field_41265, Gravestones.id("skips_gravestones"));
    /**
     * @deprecated Use {@link net.pneumono.gravestones.api.GravestonesApi#BLOCK_GRAVESTONE_IRREPLACEABLE BLOCK_GRAVESTONE_IRREPLACEABLE} instead
     */
    @Deprecated
    public static final class_6862<class_2248> BLOCK_GRAVESTONE_IRREPLACEABLE = class_6862.method_40092(class_7924.field_41254, Gravestones.id("gravestone_irreplaceable"));

    public static final class_3414 SOUND_BLOCK_WAXED_GRAVESTONE_INTERACT_FAIL = registerSoundEvent("block.gravestone.waxed_interact_fail");
    public static final class_3414 SOUND_BLOCK_GRAVESTONE_ADD_SKULL = registerSoundEvent("block.gravestone.add_skull");
    public static final class_3414 SOUND_BLOCK_GRAVESTONE_REMOVE_SKULL = registerSoundEvent("block.gravestone.remove_skull");

    public static final class_2960 GRAVESTONES_COLLECTED = Gravestones.id("gravestones_collected");

    private static class_2248 registerAestheticGravestone(String name, Function<class_4970.class_2251, class_2248> factory, class_4970.class_2251 settings) {
        class_2248 block = registerGravestone(name, factory, settings);
        class_2378.method_10230(class_7923.field_41178, Gravestones.id(name), new AestheticGravestoneBlockItem(block,
                new class_1792.class_1793()/*? if >=1.21.3 {*/.method_63685().method_63686(class_5321.method_29179(class_7924.field_41197, Gravestones.id(name)))/*?}*/
        ));
        return block;
    }

    private static class_2248 registerGravestone(String name, Function<class_4970.class_2251, class_2248> factory, class_4970.class_2251 settings) {
        return class_2378.method_10230(class_7923.field_41175, Gravestones.id(name),
                factory.apply(settings/*? if >=1.21.3 {*/.method_63500(class_5321.method_29179(class_7924.field_41254, Gravestones.id(name)))/*?}*/)
        );
    }

    private static class_3414 registerSoundEvent(String name) {
        class_2960 id = Gravestones.id(name);
        return class_2378.method_10230(class_7923.field_41172, id, class_3414.method_47908(id));
    }

    public static void registerModContent() {
        FabricDefaultAttributeRegistry.register(GRAVESTONE_SKELETON_ENTITY_TYPE,
                GravestoneSkeletonEntity.method_26905()
        );

        ArgumentTypeRegistry.registerArgumentType(
                Gravestones.id("deaths"),
                DeathArgumentType.class,
                class_2319.method_41999(DeathArgumentType::new)
        );

        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40197).register(content -> {
            content.method_45421(GRAVESTONE);
            content.method_45421(GRAVESTONE_CHIPPED);
            content.method_45421(GRAVESTONE_DAMAGED);
        });

        class_2378.method_10226(class_7923.field_41183, "gravestones_collected", GRAVESTONES_COLLECTED);
        class_3468.field_15419.method_14955(GRAVESTONES_COLLECTED, class_3446.field_16975);

        //? if >=1.20.6 {
        PayloadTypeRegistry.playS2C().register(GravestoneEditorOpenS2CPayload.PAYLOAD_ID, GravestoneEditorOpenS2CPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(UpdateGravestoneC2SPayload.PAYLOAD_ID, UpdateGravestoneC2SPayload.CODEC);

        ServerPlayNetworking.registerGlobalReceiver(UpdateGravestoneC2SPayload.PAYLOAD_ID, (payload, context) -> {
            List<String> list = Stream.of(payload.getText()).map(class_124::method_539).collect(Collectors.toList());
            context.player().field_13987.method_31279(list).thenAcceptAsync(texts ->
                    onSignUpdate(context.player(), payload, texts), context.server()
            );
        });
        //?} else {
        /*ServerPlayNetworking.registerGlobalReceiver(UpdateGravestoneC2SPayload.ID, (server, player, handler, buf, sender) -> {
            UpdateGravestoneC2SPayload payload = UpdateGravestoneC2SPayload.read(buf);

            List<String> list = Stream.of(payload.getText()).map(Formatting::strip).collect(Collectors.toList());
            player.networkHandler.filterTexts(list).thenAcceptAsync(texts ->
                    onSignUpdate(player, payload, texts), server
            );
        });
        *///?}
    }

    @SuppressWarnings("deprecation")
    private static void onSignUpdate(class_3222 player, UpdateGravestoneC2SPayload payload, List<class_5837> signText) {
        player.method_14234();
        class_3218 serverWorld = (class_3218) MultiVersionUtil.getWorld(player);
        class_2338 blockPos = payload.pos();
        if (serverWorld.method_22340(blockPos)) {
            if (!(serverWorld.method_8321(blockPos) instanceof AestheticGravestoneBlockEntity blockEntity)) {
                return;
            }

            blockEntity.tryChangeText(player, signText);
        }
    }
}
