package net.pneumono.gravestones.content;

import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4208;
import net.pneumono.gravestones.Gravestones;
import net.pneumono.gravestones.api.GravestonesApi;
import net.pneumono.gravestones.block.TechnicalGravestoneBlockEntity;
import net.pneumono.gravestones.gravestones.GravestoneDataSaving;
import net.pneumono.gravestones.gravestones.GravestoneManager;
import net.pneumono.gravestones.gravestones.RecentGraveHistory;
import net.pneumono.gravestones.multiversion.GraveOwner;
import net.pneumono.gravestones.multiversion.VersionUtil;

import java.util.List;
import java.util.UUID;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class GravestonesCommands {
    public static void registerCommands() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) ->
                dispatcher.register(method_9247("gravestones")
                        .requires(source -> source.method_9259(4))
                        .then(method_9247("getdata")
                                .then(method_9247("gravestone")
                                        .then(method_9244("position", class_2262.method_9698())
                                                .executes(context -> {
                                                    class_3218 world = context.getSource().method_9225();
                                                    class_2338 pos = class_2262.method_48299(context, "position");

                                                    if (!(world.method_8320(pos).method_27852(GravestonesRegistry.GRAVESTONE_TECHNICAL))) {
                                                        context.getSource().method_9226(() -> class_2561.method_43471("commands.gravestones.getdata.gravestone.no_gravestone").method_27692(class_124.field_1061), false);
                                                    } else if (world.method_8321(pos) instanceof TechnicalGravestoneBlockEntity entity) {
                                                        GraveOwner graveOwner = entity.getGraveOwner();
                                                        if (graveOwner != null) {
                                                            context.getSource().method_9226(() -> class_2561.method_43469("commands.gravestones.getdata.gravestone.all_data", entity.getSpawnDateTime(), graveOwner.getNotNullName(), graveOwner.getUuid()).method_27692(class_124.field_1060), false);
                                                        } else {
                                                            context.getSource().method_9226(() -> class_2561.method_43469("commands.gravestones.getdata.gravestone.no_grave_owner", entity.getSpawnDateTime()).method_27692(class_124.field_1061), false);
                                                        }

                                                        context.getSource().method_9226(() -> class_2561.method_43469("commands.gravestones.getdata.gravestone.contents_data", class_2512.method_32270(entity.getContents())), false);
                                                    }
                                                    return 1;
                                                })
                                        )
                                )
                                .then(method_9247("player")
                                        .then(method_9244("player", class_2186.method_9305())
                                                .executes(context -> {
                                                    List<RecentGraveHistory> histories = GravestoneDataSaving.readHistories(context.getSource().method_9211());

                                                    UUID uuid = VersionUtil.getId(class_2186.method_9315(context, "player").method_7334());
                                                    List<class_4208> positions = null;
                                                    for (RecentGraveHistory history : histories) {
                                                        if (history.owner().equals(uuid)) {
                                                            positions = history.getList();
                                                            break;
                                                        }
                                                    }

                                                    if (positions == null) {
                                                        Gravestones.LOGGER.error("Could not find gravestone data file!");
                                                        context.getSource().method_9226(() -> class_2561.method_43471("commands.gravestones.getdata.player.cannot_find").method_27692(class_124.field_1061), false);
                                                        return 0;
                                                    }

                                                    class_3222 player = class_2186.method_9315(context, "player");
                                                    class_2561 first = GravestoneManager.posToText(positions.get(0));
                                                    class_2561 second = GravestoneManager.posToText(positions.get(1));
                                                    class_2561 third = GravestoneManager.posToText(positions.get(2));
                                                    context.getSource().method_9226(() -> class_2561.method_43469("commands.gravestones.getdata.player.grave_data",
                                                            player.method_5476(),
                                                            first, second, third
                                                    ), false);

                                                    return 1;
                                                })
                                        )
                                )
                        )
                        .then(method_9247("deaths")
                                .then(method_9247("view")
                                        .then(method_9244("death", DeathArgumentType.death())
                                                .executes(context -> {
                                                    class_2168 source = context.getSource();

                                                    class_2487 nbt = DeathArgumentType.getDeath(context, "death");

                                                    source.method_9226(() -> class_2561.method_43469("commands.gravestones.deaths.view", class_2512.method_32270(VersionUtil.getCompoundOrEmpty(nbt, "contents"))), false);
                                                    return 1;
                                                })
                                        )
                                )
                                .then(method_9247("recover")
                                        .then(method_9244("death", DeathArgumentType.death())
                                                .executes(context -> recoverDeath(context, DeathArgumentType.getDeath(context, "death"), context.getSource().method_9207()))
                                                .then(method_9244("player", class_2186.method_9305())
                                                        .executes(context -> recoverDeath(
                                                                context,
                                                                DeathArgumentType.getDeath(context, "death"),
                                                                class_2186.method_9315(context, "player")
                                                        ))
                                                )
                                        )
                                )
                        )
                        .then(method_9247("getuuid")
                                .then(method_9244("player", class_2186.method_9305())
                                        .executes(
                                                context -> getUuid(context, class_2186.method_9315(context, "player"))
                                        )
                                )
                                .executes(
                                        context -> getUuid(context, context.getSource().method_9207())
                                )
                        )
                )
        );
    }

    private static int recoverDeath(CommandContext<class_2168> context, class_2487 nbt, class_3222 player) {
        GravestonesApi.onCollect(context.getSource().method_9225(), player.method_24515(), player, 0, VersionUtil.getCompoundOrEmpty(nbt, "contents").method_10553());
        context.getSource().method_9226(() -> class_2561.method_43471("commands.gravestones.deaths.recover"), true);
        return 1;
    }

    private static int getUuid(CommandContext<class_2168> context, class_3222 player) {
        context.getSource().method_9226(() -> class_2561.method_43469("commands.gravestones.getuuid", player.method_5476(), player.method_5845()), false);
        return 1;
    }
}
