/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.gravestones.gravestones.enums;

import java.util.function.Function;
import net.minecraft.class_1657;

public enum ExperienceKeptCalculation {
    ALL(ExperienceKeptCalculation::getTotalExperience),
    THREE_QUARTERS(entity -> (int)((float)ExperienceKeptCalculation.getTotalExperience(entity) * 3.0f / 4.0f)),
    TWO_THIRDS(entity -> (int)((float)ExperienceKeptCalculation.getTotalExperience(entity) * 2.0f / 3.0f)),
    HALF(entity -> (int)((float)ExperienceKeptCalculation.getTotalExperience(entity) / 2.0f)),
    ONE_THIRD(entity -> (int)((float)ExperienceKeptCalculation.getTotalExperience(entity) / 3.0f)),
    ONE_QUARTER(entity -> (int)((float)ExperienceKeptCalculation.getTotalExperience(entity) / 4.0f)),
    VANILLA(entity -> entity.field_7520 * 7);

    private final Function<class_1657, Integer> calculation;

    private ExperienceKeptCalculation(Function<class_1657, Integer> calculation) {
        this.calculation = calculation;
    }

    public static int getTotalExperience(class_1657 entity) {
        int level = entity.field_7520;
        int xpFromLevel = level <= 16 ? level * level + 6 * level : (level <= 31 ? (int)(2.5f * (float)level * (float)level - 40.5f * (float)level + 360.0f) : (int)(4.5f * (float)level * (float)level - 162.5f * (float)level + 2220.0f));
        int xpFromProgress = Math.round((float)ExperienceKeptCalculation.getNextLevelExperience(level) * entity.field_7510);
        return xpFromLevel + xpFromProgress;
    }

    public static int getNextLevelExperience(int currentLevel) {
        if (currentLevel >= 30) {
            return 112 + (currentLevel - 30) * 9;
        }
        if (currentLevel >= 15) {
            return 37 + (currentLevel - 15) * 5;
        }
        return 7 + currentLevel * 2;
    }

    public int calculateExperienceKept(class_1657 entity) {
        return this.calculation.apply(entity);
    }
}

