package net.pneumono.gravestones.gravestones;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4208;
import net.minecraft.server.MinecraftServer;
import net.pneumono.gravestones.GravestonesConfig;
import net.pneumono.gravestones.api.GravestonesApi;
import net.pneumono.gravestones.block.TechnicalGravestoneBlock;
import net.pneumono.gravestones.block.TechnicalGravestoneBlockEntity;
import net.pneumono.gravestones.gravestones.enums.DecayTimeType;
import net.pneumono.gravestones.multiversion.VersionUtil;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class GravestoneDecay extends GravestoneManager {
    public static void timeDecayGravestone(class_1937 world, class_2338 pos, class_2680 state) {
        class_2586 blockEntity = world.method_8321(pos);
        if (
                !GravestonesConfig.DECAY_WITH_TIME.getValue() ||
                !(blockEntity instanceof TechnicalGravestoneBlockEntity entity) ||
                entity.getGraveOwner() == null
        ) return;

        long difference;

        if (GravestonesConfig.DECAY_TIME_TYPE.getValue() == DecayTimeType.TICKS) {
            difference = world.method_8510() - entity.getSpawnDateTicks();
        } else if (entity.getSpawnDateTime() != null) {
            difference = GravestoneTime.getDifferenceInSeconds(GravestoneTime.READABLE.format(new Date()), entity.getSpawnDateTime()) * 20;
        } else {
            difference = 0;
        }

        long timeUnit = GravestonesConfig.DECAY_TIME.getValue();

        if (difference > (timeUnit * 3)) {
            entity.setAgeDamage(3);

        } else if (difference > (timeUnit * 2)) {
            entity.setAgeDamage(2);

        } else if (difference > timeUnit) {
            entity.setAgeDamage(1);
        }

        updateTotalGravestoneDamage(world, pos, state, entity);
    }

    protected static void deathDamageOldGravestones(MinecraftServer server, List<class_4208> oldGravePositions, class_4208 newPos) {
        if (!GravestonesConfig.DECAY_WITH_DEATHS.getValue()) {
            return;
        }

        List<class_4208> checkedPositions = new ArrayList<>();
        checkedPositions.add(newPos);
        for (class_4208 oldPos : oldGravePositions) {
            if (checkedPositions.contains(oldPos)) {
                continue;
            }

            GravestoneDecay.incrementDeathDamage(server, oldPos);
            checkedPositions.add(oldPos);
        }
    }

    public static void incrementDeathDamage(MinecraftServer server, class_4208 globalPos) {
        class_3218 world = server.method_3847(VersionUtil.getDimension(globalPos));
        class_2338 pos = VersionUtil.getPos(globalPos);

        if (
                world == null ||
                !(world.method_8321(pos) instanceof TechnicalGravestoneBlockEntity entity) ||
                entity.getGraveOwner() == null
        ) return;

        entity.setDeathDamage(entity.getDeathDamage() + 1);
        updateTotalGravestoneDamage(world, pos, world.method_8320(pos), entity);
    }

    public static void updateTotalGravestoneDamage(class_1937 world, class_2338 pos, class_2680 state, TechnicalGravestoneBlockEntity entity) {
        int totalDamage = entity.getTotalDamage();
        if (totalDamage == state.method_11654(TechnicalGravestoneBlock.DAMAGE)) return;

        if (totalDamage >= 3) {
            if (GravestonesApi.shouldDecayAffectGameplay()) {
                world.method_22352(pos, true);
            } else {
                return;
            }
        } else if (totalDamage >= 0) {
            world.method_8501(pos, state.method_11657(TechnicalGravestoneBlock.DAMAGE, totalDamage));
        }

        entity.method_5431();
    }
}
