package net.pneumono.gravestones.content;

import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3728;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_8012;
import net.minecraft.class_8242;
import net.minecraft.class_837;
import net.minecraft.class_9848;
import net.pneumono.gravestones.Gravestones;
import net.pneumono.gravestones.block.AestheticGravestoneBlockEntity;
import net.pneumono.gravestones.networking.UpdateGravestoneC2SPayload;
import org.jetbrains.annotations.Nullable;

//? if >=1.21.9 {
/*import net.minecraft.client.input.KeyInput;
import net.minecraft.client.input.CharInput;
*///?} else {
import org.lwjgl.glfw.GLFW;
//?}

//? if <1.20.2 {
/*import net.minecraft.client.render.DiffuseLighting;
*///?}

import java.util.Objects;
import java.util.stream.IntStream;

public class AestheticGravestoneEditScreen extends class_437 {
    public static final int TEXT_WIDTH = 86;
    private static final int TEXT_LINE_HEIGHT = 14;
    protected final AestheticGravestoneBlockEntity blockEntity;
    private class_8242 text;
    private final String[] messages;
    private int ticksSinceOpened;
    private int currentRow;
    @Nullable
    private class_3728 selectionManager;
    private final class_2960 texture;

    public AestheticGravestoneEditScreen(AestheticGravestoneBlockEntity blockEntity, boolean filtered) {
        super(class_2561.method_43471("gravestones.edit_text"));
        this.blockEntity = blockEntity;
        this.text = blockEntity.getText();
        this.messages = IntStream.range(0, 4).mapToObj(line -> this.text.method_49859(line, filtered)).map(class_2561::getString).toArray(String[]::new);
        class_1937 world = blockEntity.method_10997();
        class_2248 block;
        if (world != null) {
            block = world.method_8320(blockEntity.method_11016()).method_26204();
        } else {
            block = GravestonesRegistry.GRAVESTONE;
        }
        this.texture = getTexture(block);
    }

    private class_2960 getTexture(class_2248 block) {
        String name;
        if (block == GravestonesRegistry.GRAVESTONE_CHIPPED) {
            name = "chipped";
        } else if (block == GravestonesRegistry.GRAVESTONE_DAMAGED) {
            name = "damaged";
        } else {
            name = "default";
        }

        return Gravestones.id("textures/gui/gravestone_" + name + ".png");
    }

    @Override
    protected void method_25426() {
        Objects.requireNonNull(this.field_22787);
        this.method_37063(
                class_4185.method_46430(class_5244.field_24334, button -> this.finishEditing()).method_46434(this.field_22789 / 2 - 100, this.field_22790 / 4 + 144, 200, 20).method_46431()
        );
        this.selectionManager = new class_3728(
                () -> this.messages[this.currentRow],
                this::setCurrentRowMessage,
                class_3728.method_27550(this.field_22787),
                class_3728.method_27561(this.field_22787),
                string -> this.field_22787.field_1772.method_1727(string) <= TEXT_WIDTH
        );
    }

    @Override
    public void method_25393() {
        this.ticksSinceOpened++;
        if (!this.canEdit()) {
            this.finishEditing();
        }
    }

    private boolean canEdit() {
        return this.field_22787 != null
                && this.field_22787.field_1724 != null
                && !this.blockEntity.method_11015()
                && !this.blockEntity.isPlayerTooFarToEdit(this.field_22787.field_1724.method_5667());
    }

    @Override
    //? if >=1.21.9 {
    /*public boolean keyPressed(KeyInput input) {
    *///?} else {
    public boolean method_25404(int input, int scanCode, int modifiers) {
    //?}
        Objects.requireNonNull(this.selectionManager);
        if (isUp(input)) {
            this.currentRow = this.currentRow - 1 & 3;
            this.selectionManager.method_16204();
            return true;
        } else if (isDownOrEnter(input)) {
            this.currentRow = this.currentRow + 1 & 3;
            this.selectionManager.method_16204();
            return true;
        } else {
            if (this.selectionManager.method_16202(input)) {
                return true;
            } else {
                //? if >=1.21.9 {
                /*return super.keyPressed(input);
                *///?} else {
                return super.method_25404(input, scanCode, modifiers);
                //?}
            }
        }
    }

    //? if >=1.21.9 {
    /*public boolean isUp(KeyInput input) {
        return input.isUp();
    }
    *///?} else {
    public boolean isUp(int input) {
        return input == GLFW.GLFW_KEY_UP;
    }
    //?}

    //? if >=1.21.9 {
    /*public boolean isDownOrEnter(KeyInput input) {
        return input.isDown() || input.isEnter();
    }
    *///?} else {
    public boolean isDownOrEnter(int input) {
        return input == GLFW.GLFW_KEY_DOWN || input == GLFW.GLFW_KEY_ENTER || input == GLFW.GLFW_KEY_KP_ENTER;
    }
    //?}

    @Override
    //? if >=1.21.9 {
    /*public boolean charTyped(CharInput input) {
    *///?} else {
    public boolean method_25400(char input, int modifiers) {
    //?}
        Objects.requireNonNull(this.selectionManager).method_16199(input);
        return true;
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        //? if <1.20.2 {
        /*DiffuseLighting.disableGuiDepthLighting();
        this.renderBackground(context);
        *///?}
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 40, 16777215);
        this.renderGravestone(context);
        //? if <1.20.2 {
        /*DiffuseLighting.enableGuiDepthLighting();
        *///?}
        super.method_25394(context, mouseX, mouseY, deltaTicks);
    }

    //? if >=1.20.2 {
    @Override
    public void method_25420(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        this.method_52752(context);
    }
    //?}

    @Override
    public void method_25419() {
        this.finishEditing();
    }

    @Override
    public void method_25432() {
        UpdateGravestoneC2SPayload payload = new UpdateGravestoneC2SPayload(this.blockEntity.method_11016(), this.messages[0], this.messages[1], this.messages[2], this.messages[3]);
        //? if >=1.20.6 {
        ClientPlayNetworking.send(payload);
        //?} else {
        /*ClientPlayNetworking.send(payload.id(), payload.write());
        *///?}
    }

    @Override
    public boolean method_25421() {
        return false;
    }

    private void renderGravestone(class_332 context) {
        //? if >=1.21.8 {
        /*context.getMatrices().pushMatrix();
        context.getMatrices().translate(this.width / 2.0F, 125.0F);
        context.getMatrices().pushMatrix();
        this.renderGravestoneBackground(context);
        context.getMatrices().popMatrix();
        this.renderGravestoneText(context);
        context.getMatrices().popMatrix();
        *///?} else {
        context.method_51448().method_22903();
        context.method_51448().method_46416(this.field_22789 / 2.0F, 125.0F, 50.0F);
        context.method_51448().method_22903();
        this.renderGravestoneBackground(context);
        context.method_51448().method_22909();
        this.renderGravestoneText(context);
        context.method_51448().method_22909();
        //?}
    }

    protected void renderGravestoneBackground(class_332 context) {
        //? if >=1.21.8 {
        /*context.getMatrices().scale(7.0F, 7.0F);
        *///?} else {
        context.method_51448().method_22905(7.0F, 7.0F, 1.0F);
        //?}
        context.method_25290(
                /*? if >=1.21.8 {*//*RenderPipelines.GUI_TEXTURED,*//*?} else if >=1.21.3 {*/class_1921::method_62277,/*?}*/
                this.texture,
                -8, -8,
                0.0F, 0.0F,
                16, 16,
                16, 16
        );
    }

    private void renderGravestoneText(class_332 context) {
        int color = this.text.method_49856() ? this.text.method_49872().method_16357() : /*? if >=1.21.4 {*//*AbstractSignBlockEntityRenderer.getTextColor(this.text)*//*?} else {*/class_837.method_37311(this.text)/*?}*/;
        boolean shouldFlashCursor = this.ticksSinceOpened / 6 % 2 == 0;
        Objects.requireNonNull(this.selectionManager);
        int selectionStart = this.selectionManager.method_16201();
        int selectionEnd = this.selectionManager.method_16203();
        int lineHeightOffset = 4 * TEXT_LINE_HEIGHT / 2;
        int adjustedY = this.currentRow * TEXT_LINE_HEIGHT - lineHeightOffset;

        for (int i = 0; i < this.messages.length; i++) {
            String message = this.messages[i];
            if (message != null) {
                if (this.field_22793.method_1726()) {
                    message = this.field_22793.method_1721(message);
                }

                int x = -this.field_22793.method_1727(message) / 2;
                context.method_51433(this.field_22793, message, x, i * TEXT_LINE_HEIGHT - lineHeightOffset, color, false);
                if (i == this.currentRow && selectionStart >= 0 && shouldFlashCursor) {
                    int substringWidth = this.field_22793.method_1727(message.substring(0, Math.min(selectionStart, message.length())));
                    int adjustedX = substringWidth - this.field_22793.method_1727(message) / 2;
                    if (selectionStart >= message.length()) {
                        context.method_51433(this.field_22793, "_", adjustedX, adjustedY, color, false);
                    }
                }
            }
        }

        for (int i = 0; i < this.messages.length; i++) {
            String message = this.messages[i];
            if (message != null && i == this.currentRow && selectionStart >= 0) {
                int substringWidth = this.field_22793.method_1727(message.substring(0, Math.min(selectionStart, message.length())));
                int adjustedX = substringWidth - this.field_22793.method_1727(message) / 2;
                if (shouldFlashCursor && selectionStart < message.length()) {
                    context.method_25294(adjustedX, adjustedY - 1, adjustedX + 1, adjustedY + TEXT_LINE_HEIGHT, /*? if >=1.21.3 {*/class_9848.method_61334(color)/*?} else {*//*-16777216 | color*//*?}*/);
                }

                if (selectionEnd != selectionStart) {
                    int start = Math.min(selectionStart, selectionEnd);
                    int end = Math.max(selectionStart, selectionEnd);
                    int widthStart = this.field_22793.method_1727(message.substring(0, start)) - this.field_22793.method_1727(message) / 2;
                    int widthEnd = this.field_22793.method_1727(message.substring(0, end)) - this.field_22793.method_1727(message) / 2;
                    int startX = Math.min(widthStart, widthEnd);
                    int endX = Math.max(widthStart, widthEnd);
                    context.method_51739(
                            /*? if >=1.21.8 {*//*RenderPipelines.GUI_TEXT_HIGHLIGHT*//*?} else {*/class_1921.method_51786()/*?}*/,
                            startX,
                            adjustedY,
                            endX,
                            adjustedY + TEXT_LINE_HEIGHT,
                            /*? if >=1.21.1 {*/class_8012.field_52313/*?} else {*//*-16776961*//*?}*/
                    );
                }
            }
        }
    }

    private void setCurrentRowMessage(String message) {
        this.messages[this.currentRow] = message;
        this.text = this.text.method_49857(this.currentRow, class_2561.method_43470(message));
        this.blockEntity.setText(this.text);
    }

    private void finishEditing() {
        Objects.requireNonNull(this.field_22787).method_1507(null);
    }
}
