package net.pneumono.gravestones.api;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1657;
import net.minecraft.class_3218;
import net.minecraft.class_4208;
import net.minecraft.class_5321;

/**
 * Callback after a gravestone is placed.
 *
 * <p>Called after all other gravestone processing. At this point the player is dead.
 *
 * <p>{@code placementPos} may differ from {@code deathPos},
 * as Gravestones will attempt to move graves to nearby free space when possible,
 * and the position may have been redirected by another mod.
 *
 * <p>The {@code ServerWorld} provided represents the dimension in which the player died,
 * which may not be the dimension in which the gravestone was placed.
 * {@link net.minecraft.server.MinecraftServer#method_3847(class_5321) MinecraftServer.getWorld}
 * can be used to get the world in which the gravestone was placed.
 *
 * <p>Should not be used for inserting data into graves. If you need to insert data, see {@link GravestoneDataType}
 *
 * <p>Does not have any way to cancel gravestone placement. If you need to cancel placement, see {@link CancelGravestonePlacementCallback}
 *
 * @see GravestoneDataType
 * @see CancelGravestonePlacementCallback
 */
public interface GravestonePlacedCallback {
    Event<GravestonePlacedCallback> EVENT = EventFactory.createArrayBacked(GravestonePlacedCallback.class,
            listeners -> (world, player, deathPos, placementPos) -> {
                for (GravestonePlacedCallback listener : listeners) {
                    listener.afterGravestonePlace(world, player, deathPos, placementPos);
                }
            }
    );

    void afterGravestonePlace(class_3218 world, class_1657 player, class_4208 deathPos, class_4208 placementPos);
}
