package net.pneumono.gravestones.compat;

import com.google.gson.GsonBuilder;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_4208;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import net.pneumono.gravestones.Gravestones;
import net.pneumono.gravestones.gravestones.GravestoneDataSaving;
import net.pneumono.gravestones.gravestones.RecentGraveHistory;
import net.pneumono.gravestones.multiversion.VersionUtil;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

public class BackwardsCompat {
    public static void convertOldFiles(MinecraftServer server) {
        File gravestoneFile = new File(server.method_27050(class_5218.field_24188).toString(), "gravestone_data.json");
        if (!gravestoneFile.exists()) return;

        Gravestones.LOGGER.info("Old data detected! Converting to new format...");

        try {
            Reader reader = Files.newBufferedReader(gravestoneFile.toPath());
            GravestoneData data = (new GsonBuilder().setPrettyPrinting().create()).fromJson(reader, GravestoneData.class);
            reader.close();

            GravestoneDataSaving.writeData(
                    server,
                    data.data().stream().map(
                            playerData -> new RecentGraveHistory(
                                    playerData.owner(),
                                    playerData.firstGrave().convert(),
                                    playerData.secondGrave().convert(),
                                    playerData.thirdGrave().convert()
                            )
                    ).toList()
            );

            if (!gravestoneFile.delete()) {
                Gravestones.LOGGER.info("Failed to delete old data file!");
            }

        } catch (IOException e) {
            Gravestones.LOGGER.info("Old data file could not be read!");
        }
    }

    private record GravestoneData(List<PlayerGravestoneData> data) {

    }

    private record PlayerGravestoneData(UUID owner, GravestonePosition firstGrave, GravestonePosition secondGrave, GravestonePosition thirdGrave) {

    }

    private record GravestonePosition(class_2960 dimension, int posX, int posY, int posZ) {
        private Optional<class_4208> convert() {
            return Optional.of(VersionUtil.createGlobalPos(class_5321.method_29179(class_7924.field_41223, dimension()), new class_2338(this.posX, this.posY, this.posZ)));
        }
    }
}
