package net.pneumono.gravestones.gravestones;

import net.fabricmc.fabric.api.entity.FakePlayer;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import net.pneumono.gravestones.Gravestones;
import net.pneumono.gravestones.GravestonesConfig;
import net.pneumono.gravestones.api.GravestoneCollectedCallback;
import net.pneumono.gravestones.api.GravestonesApi;
import net.pneumono.gravestones.block.TechnicalGravestoneBlockEntity;
import net.pneumono.gravestones.multiversion.GraveOwner;
import net.pneumono.gravestones.multiversion.VersionUtil;

public class GravestoneCollection extends GravestoneManager {
    public static boolean collect(class_3218 world, class_1657 player, class_2338 pos) {
        if (world.method_8321(pos) instanceof TechnicalGravestoneBlockEntity gravestone) {

            info("----- Beginning Gravestone Collection -----");
            info("If you don't want to see this, disable 'Console Info' in the configs!");
            boolean success = collect(world, player, pos, gravestone);
            info("----- Finishing Gravestone Collection -----");

            return success;
        } else {
            return false;
        }
    }

    private static boolean collect(class_3218 world, class_1657 player, class_2338 pos, TechnicalGravestoneBlockEntity gravestone) {
        // Check the player is allowed to open the gravestone
        info("Performing checks...");
        if (player instanceof FakePlayer) {
            info("Player cannot collect gravestone because they are a FakePlayer");
            return false;
        }

        if (player.method_29504()) {
            info("Player cannot collect gravestone because they are dead");
            return false;
        }

        GraveOwner graveOwner = gravestone.getGraveOwner();
        if (graveOwner == null) {
            info("Player cannot collect gravestone because it has no owner");
            player.method_7353(class_2561.method_43471("gravestones.cannot_open_no_owner"), true);
            return false;
        }

        boolean isOwner = graveOwner.getUuid().equals(VersionUtil.getId(player.method_7334()));
        if (!isOwner && GravestonesConfig.GRAVESTONE_ACCESSIBLE_OWNER_ONLY.getValue()) {
            info("Player cannot collect gravestone because they are not the owner");
            player.method_7353(class_2561.method_43469("gravestones.cannot_open_wrong_player", graveOwner.getNotNullName()), true);
            return false;
        }
        info("All checks passed");

        // Return gravestone contents
        info("Returning gravestone contents...");
        GravestonesApi.onCollect(world, pos, player, gravestone.getDecay(), gravestone.getContents());
        class_2487 contents = gravestone.getContents();
        if (!contents.method_33133()) {
            warn("Some gravestone contents were not returned: {}", contents);
            return false;
        }
        gravestone.setContents(new class_2487());

        // Log grave collection
        String uuid = "";
        if (GravestonesConfig.CONSOLE_INFO.getValue()) {
            uuid = " (" + VersionUtil.getId(player.method_7334()) + ")";
        }
        if (isOwner) {
            Gravestones.LOGGER.info("{}{} has found their grave at {}", player.method_5477().getString(), uuid, GravestoneManager.posToString(pos));
        } else {
            Gravestones.LOGGER.info("{}{} has found {}{}'s grave at {}",
                    player.method_5477().getString(), uuid,
                    graveOwner.getNotNullName(), graveOwner.getUuid(),
                    pos.toString()
            );
        }

        // Broadcast chat message
        info("Broadcasting chat message...");
        if (GravestonesConfig.BROADCAST_COLLECT_IN_CHAT.getValue()) {
            class_5250 text;
            if (GravestonesConfig.BROADCAST_COORDINATES_IN_CHAT.getValue()) {
                if (isOwner) {
                    text = class_2561.method_43469("gravestones.player_collected_grave_at_coords", player.method_5477().getString(), GravestoneManager.posToString(pos));
                } else {
                    text = class_2561.method_43469("gravestones.player_collected_others_grave_at_coords", player.method_5477().getString(), graveOwner.getNotNullName(), GravestoneManager.posToString(pos));
                }
            } else {
                if (isOwner) {
                    text = class_2561.method_43469("gravestones.player_collected_grave", player.method_5477().getString());
                } else {
                    text = class_2561.method_43469("gravestones.player_collected_others_grave", player.method_5477().getString(), graveOwner.getNotNullName());
                }
            }
            world.method_8503().method_3760().method_43514(text, false);
        }

        // Break block
        info("Breaking gravestone...");
        world.method_22352(pos, true);

        GravestoneCollectedCallback.EVENT.invoker().afterGravestoneCollect(world, player, pos);

        return true;
    }
}
