package net.pneumono.gravestones.mixin;

import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_3218;
import net.pneumono.gravestones.gravestones.GravestoneCreation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1309.class)
public abstract class LivingEntityMixin {
    // The mod should really be injecting later (in dropInventory),
    // but Accessories injects in dropEquipment for some reason,
    // and we need to be sure this is called before any other mods do their inventory dropping independently
    @Inject(method = "drop", at = @At("HEAD"))
    //? if >=1.21.1 {
    public void spawnGravestone(class_3218 world, class_1282 damageSource, CallbackInfo ci) {
        if ((Object)this instanceof class_1657 player) {
            GravestoneCreation.create(player);
        }
    }
    //?} else {
    /*public void spawnGravestone(DamageSource source, CallbackInfo ci) {
        if ((Object)this instanceof PlayerEntity player) {
            GravestoneCreation.create(player);
        }
    }
    *///?}
}