package net.pneumono.gravestones.compat;

//? if trinkets {
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.emi.trinkets.api.*;
import dev.emi.trinkets.api.event.TrinketDropCallback;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_9701;
import net.pneumono.gravestones.api.GravestoneDataType;
import net.pneumono.gravestones.api.GravestonesApi;
import net.pneumono.gravestones.multiversion.VersionUtil;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TrinketsDataType extends GravestoneDataType {
    private static final String KEY = "trinkets";

    @Override
    public void writeData(class_2487 nbt, DynamicOps<class_2520> ops, class_1657 player) throws Exception {
        TrinketComponent component = TrinketsApi.getTrinketComponent(player).orElse(null);
        if (component == null) return;

        List<TrinketsSlot> storedTrinkets = new ArrayList<>();
        component.forEach((reference, stack) -> {
            if (shouldSkipTrinket(player, reference, stack)) return;

            storedTrinkets.add(new TrinketsSlot(reference, stack));
            reference.inventory().method_5441(reference.index());
        });

        VersionUtil.put(ops, nbt, KEY, TrinketsSlot.CODEC.listOf(), storedTrinkets);
    }

    @Override
    public void onBreak(class_2487 nbt, DynamicOps<class_2520> ops, class_1937 world, class_2338 pos, int decay) {
        List<TrinketsSlot> list = VersionUtil.get(ops, nbt, KEY, TrinketsSlot.CODEC.listOf()).orElseThrow();

        for (TrinketsSlot slot : list) {
            dropStack(world, pos, slot.stack());
        }
    }

    @Override
    public void onCollect(class_2487 nbt, DynamicOps<class_2520> ops, class_1937 world, class_2338 pos, class_1657 player, int decay) {
        List<TrinketsSlot> list = VersionUtil.get(ops, nbt, KEY, TrinketsSlot.CODEC.listOf()).orElseThrow();

        TrinketComponent trinketComponent = TrinketsApi.getTrinketComponent(player).orElse(null);
        Map<String, Map<String, TrinketInventory>> trinketInventories;
        if (trinketComponent == null) {
            trinketInventories = null;
        } else {
            trinketInventories = trinketComponent.getInventory();
        }

        List<TrinketsSlot> remainingSlots = new ArrayList<>();
        if (trinketInventories == null) {
            remainingSlots.addAll(list);
        } else {
            for (TrinketsSlot slot : list) {
                TrinketInventory inventory = trinketInventories.get(slot.groupName()).get(slot.slotName());

                if (inventory.method_5438(slot.index()).method_7960()) {
                    inventory.method_5447(slot.index(), slot.stack());
                    continue;
                }

                remainingSlots.add(slot);
            }
        }

        for (TrinketsSlot slot : remainingSlots) {
            class_1799 stack = slot.stack();
            dropStack(player, stack);
        }
    }

    public boolean shouldSkipTrinket(class_1657 player, SlotReference reference, class_1799 stack) {
        boolean shouldSkipItem = GravestonesApi.shouldSkipItem(player, stack);

        TrinketEnums.DropRule dropRule = TrinketsApi.getTrinket(stack.method_7909()).getDropRule(stack, reference, player);

        dropRule = TrinketDropCallback.EVENT.invoker().drop(dropRule, stack, reference, player);

        TrinketInventory inventory = reference.inventory();

        if (dropRule == TrinketEnums.DropRule.DEFAULT) {
            dropRule = inventory.getSlotType().getDropRule();
        }

        if (dropRule == TrinketEnums.DropRule.DEFAULT) {
            boolean vanishing =
            //? if >=1.21.1 {
            class_1890.method_60142(stack, class_9701.field_51655);
            //?} else {
            /*EnchantmentHelper.hasVanishingCurse(stack);
            *///?}
            if (vanishing) {
                dropRule = TrinketEnums.DropRule.DESTROY;
            } else {
                dropRule = TrinketEnums.DropRule.DROP;
            }
        }

        return stack.method_7960() || dropRule != TrinketEnums.DropRule.DROP || shouldSkipItem;
    }

    public record TrinketsSlot(String groupName, String slotName, int index, class_1799 stack) {
        public static final Codec<TrinketsSlot> CODEC = RecordCodecBuilder.create(builder -> builder.group(
                Codec.STRING.fieldOf("group").forGetter(TrinketsSlot::groupName),
                Codec.STRING.fieldOf("slot").forGetter(TrinketsSlot::slotName),
                Codec.INT.fieldOf("index").forGetter(TrinketsSlot::index),
                class_1799.field_24671.fieldOf("stack").forGetter(TrinketsSlot::stack)
        ).apply(builder, TrinketsSlot::new));

        public TrinketsSlot(SlotReference reference, class_1799 stack) {
            this(
                    reference.inventory().getSlotType().getGroup(),
                    reference.inventory().getSlotType().getName(),
                    reference.index(),
                    stack
            );
        }
    }
}
//?}