package net.pneumono.gravestones.gravestones;

import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.minecraft.class_4208;
import net.pneumono.gravestones.api.PositionValidationCallback;
import net.pneumono.gravestones.api.RedirectGravestonePositionCallback;
import net.pneumono.gravestones.content.GravestonesRegistry;
import net.pneumono.gravestones.multiversion.VersionUtil;
import org.jetbrains.annotations.Nullable;

public class GravestonePlacement extends GravestoneManager {
    public static final int RADIUS = 2;

    /**
     * Returns the placement position for a gravestone.
     *
     * <p>Checks {@link RedirectGravestonePositionCallback} listeners, and if none return a valid redirected position,
     * simply uses the result from {@link #getValidPos}.
     *
     * <p>Should not be called by {@link RedirectGravestonePositionCallback} listeners, for obvious reasons.
     *
     * @see RedirectGravestonePositionCallback
     */
    public static class_4208 getRedirectableValidPos(class_3218 world, class_1657 player, class_4208 deathPos) {
        class_4208 redirected = RedirectGravestonePositionCallback.EVENT.invoker().redirectPosition(world, player, deathPos);
        if (redirected != null) return redirected;

        class_2338 validPos = getValidPos(world, VersionUtil.getPos(deathPos), RADIUS);
        if (validPos == null) {
            return null;
        } else {
            return VersionUtil.createGlobalPos(VersionUtil.getDimension(deathPos), validPos);
        }
    }

    /**
     * Calculates and returns the best possible gravestone placement position within an area around the original position.
     *
     * <p>Searches positions in a cube of side length {@code (radius * 2) + 1}, centered on the {@code originalPos}.
     *
     * <p>May return null if it does not find a valid position,
     * such as if the original position is inside a bedrock cube.
     *
     * <p>Gravestones itself uses a radius of 2.
     */
    @Nullable
    public static class_2338 getValidPos(class_1937 world, class_2338 originalPos, int radius) {
        if (getCost(world, originalPos, originalPos) == 0) {
            return originalPos;
        }

        double bestCost = -1;
        class_2338 bestPos = null;

        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int x = -radius; x <= radius; ++x) for (int y = -radius; y <= radius; ++y) for (int z = -radius; z <= radius; ++z) {
            mutable.method_10101(originalPos.method_10069(x, y, z));

            double cost = getCost(world, mutable, originalPos);
            if (cost < bestCost || (bestCost == -1 && cost != -1)) {
                bestCost = cost;
                bestPos = mutable.method_25503();
            }
        }

        if (bestCost == -1) {
            return null;
        } else {
            return bestPos;
        }
    }

    /**
     * Returns {@code true} if the block state cannot be replaced by gravestones. Does not check {@link PositionValidationCallback} listeners.
     */
    public static boolean isInvalid(class_2680 state) {
        class_2248 block = state.method_26204();
        return block.method_36555() < 0 ||
                block.method_9520() >= 3600000 ||
                block == class_2246.field_10243 ||
                state.method_26164(GravestonesRegistry.BLOCK_GRAVESTONE_IRREPLACEABLE);
    }

    private static double getCost(class_1937 world, class_2338 newPos, class_2338 origin) {
        class_2680 state = world.method_8320(newPos);
        if (
                isInvalid(state) || !PositionValidationCallback.EVENT.invoker().isPositionValid(world, state, newPos)
        ) {
            return -1;
        }

        double cost = 0;
        if (!state.method_26227().method_15769()) {
            if (state.method_26227().method_15767(class_3486.field_15517)) {
                cost += 1.5;
            } else {
                cost += 5;
            }
        }
        if (!state.method_26215()) cost += state.method_45474() ? 0.5 : 5;
        if (world.method_8320(newPos.method_10074()).method_26215()) cost += 1.5;

        cost += origin.method_10262(newPos);

        return cost;
    }
}
