/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.gravestones.compat;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketEnums;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.api.event.TrinketDropCallback;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_9331;
import net.minecraft.class_9701;
import net.pneumono.gravestones.api.GravestoneDataType;
import net.pneumono.gravestones.api.GravestonesApi;
import net.pneumono.gravestones.multiversion.VersionUtil;

public class TrinketsDataType
extends GravestoneDataType {
    private static final String KEY = "trinkets";

    @Override
    public void writeData(class_2487 nbt, DynamicOps<class_2520> ops, class_1657 player) throws Exception {
        TrinketComponent component = TrinketsApi.getTrinketComponent((class_1309)player).orElse(null);
        if (component == null) {
            return;
        }
        ArrayList storedTrinkets = new ArrayList();
        component.forEach((reference, stack) -> {
            if (this.shouldSkipTrinket(player, (SlotReference)reference, (class_1799)stack)) {
                return;
            }
            storedTrinkets.add(new TrinketsSlot((SlotReference)reference, (class_1799)stack));
            reference.inventory().method_5441(reference.index());
        });
        VersionUtil.put(ops, nbt, KEY, TrinketsSlot.CODEC.listOf(), storedTrinkets);
    }

    @Override
    public void onBreak(class_2487 nbt, DynamicOps<class_2520> ops, class_1937 world, class_2338 pos, int decay) {
        List list = (List)VersionUtil.get(ops, nbt, KEY, TrinketsSlot.CODEC.listOf()).orElseThrow();
        for (TrinketsSlot slot : list) {
            this.dropStack(world, pos, slot.stack());
        }
    }

    @Override
    public void onCollect(class_2487 nbt, DynamicOps<class_2520> ops, class_1937 world, class_2338 pos, class_1657 player, int decay) {
        List list = (List)VersionUtil.get(ops, nbt, KEY, TrinketsSlot.CODEC.listOf()).orElseThrow();
        TrinketComponent trinketComponent = TrinketsApi.getTrinketComponent((class_1309)player).orElse(null);
        Map trinketInventories = trinketComponent == null ? null : trinketComponent.getInventory();
        ArrayList<TrinketsSlot> remainingSlots = new ArrayList<TrinketsSlot>();
        if (trinketInventories == null) {
            remainingSlots.addAll(list);
        } else {
            for (TrinketsSlot slot : list) {
                TrinketInventory inventory = (TrinketInventory)((Map)trinketInventories.get(slot.groupName())).get(slot.slotName());
                if (inventory.method_5438(slot.index()).method_7960()) {
                    inventory.method_5447(slot.index(), slot.stack());
                    continue;
                }
                remainingSlots.add(slot);
            }
        }
        for (TrinketsSlot slot : remainingSlots) {
            class_1799 stack = slot.stack();
            this.dropStack(player, stack);
        }
    }

    public boolean shouldSkipTrinket(class_1657 player, SlotReference reference, class_1799 stack) {
        boolean shouldSkipItem = GravestonesApi.shouldSkipItem(player, stack);
        TrinketEnums.DropRule dropRule = TrinketsApi.getTrinket((class_1792)stack.method_7909()).getDropRule(stack, reference, (class_1309)player);
        dropRule = ((TrinketDropCallback)TrinketDropCallback.EVENT.invoker()).drop(dropRule, stack, reference, (class_1309)player);
        TrinketInventory inventory = reference.inventory();
        if (dropRule == TrinketEnums.DropRule.DEFAULT) {
            dropRule = inventory.getSlotType().getDropRule();
        }
        if (dropRule == TrinketEnums.DropRule.DEFAULT) {
            boolean vanishing = class_1890.method_60142((class_1799)stack, (class_9331)class_9701.field_51655);
            dropRule = vanishing ? TrinketEnums.DropRule.DESTROY : TrinketEnums.DropRule.DROP;
        }
        return stack.method_7960() || dropRule != TrinketEnums.DropRule.DROP || shouldSkipItem;
    }

    public record TrinketsSlot(String groupName, String slotName, int index, class_1799 stack) {
        public static final Codec<TrinketsSlot> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.fieldOf("group").forGetter(TrinketsSlot::groupName), (App)Codec.STRING.fieldOf("slot").forGetter(TrinketsSlot::slotName), (App)Codec.INT.fieldOf("index").forGetter(TrinketsSlot::index), (App)class_1799.field_24671.fieldOf("stack").forGetter(TrinketsSlot::stack)).apply((Applicative)builder, TrinketsSlot::new));

        public TrinketsSlot(SlotReference reference, class_1799 stack) {
            this(reference.inventory().getSlotType().getGroup(), reference.inventory().getSlotType().getName(), reference.index(), stack);
        }
    }
}

