/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.gravestones.block;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2631;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.pneumono.gravestones.GravestonesConfig;
import net.pneumono.gravestones.block.AbstractGravestoneBlockEntity;
import net.pneumono.gravestones.block.TechnicalGravestoneBlock;
import net.pneumono.gravestones.content.GravestoneSkeletonEntity;
import net.pneumono.gravestones.content.GravestonesRegistry;
import net.pneumono.gravestones.gravestones.GravestoneDecay;
import net.pneumono.gravestones.multiversion.GraveOwner;
import net.pneumono.gravestones.multiversion.VersionUtil;
import org.jetbrains.annotations.Nullable;

public class TechnicalGravestoneBlockEntity
extends AbstractGravestoneBlockEntity {
    private class_2487 contents = new class_2487();
    @Nullable
    private GraveOwner graveOwner;
    private String spawnDateTime;
    private long spawnDateTicks;
    private int deathDamage = 0;
    private int ageDamage = 0;

    public TechnicalGravestoneBlockEntity(class_2338 pos, class_2680 state) {
        super(GravestonesRegistry.TECHNICAL_GRAVESTONE_ENTITY, pos, state);
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        VersionUtil.put(nbt, "contents", class_2487.field_25128, this.contents);
        if (this.graveOwner != null) {
            VersionUtil.put(nbt, "owner", GraveOwner.CODEC, this.graveOwner);
        }
        if (this.spawnDateTime != null) {
            nbt.method_10582("spawnDateTime", this.spawnDateTime);
        }
        if (this.spawnDateTicks != 0L) {
            nbt.method_10544("spawnDateTicks", this.spawnDateTicks);
        }
        nbt.method_10569("deathDamage", this.deathDamage);
        nbt.method_10569("ageDamage", this.ageDamage);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.contents = VersionUtil.get(nbt, "contents", class_2487.field_25128).orElse(new class_2487());
        this.setGraveOwner(VersionUtil.get(nbt, "owner", GraveOwner.CODEC).orElse(null));
        this.spawnDateTime = nbt.method_10558("spawnDateTime");
        this.spawnDateTicks = nbt.method_10537("spawnDateTicks");
        this.deathDamage = nbt.method_10550("deathDamage");
        this.ageDamage = nbt.method_10550("ageDamage");
    }

    public static void tick(class_1937 world, class_2338 blockPos, class_2680 state, TechnicalGravestoneBlockEntity entity) {
        if (world.method_8608() || world.method_8510() % 20L != 0L) {
            return;
        }
        GravestoneDecay.timeDecayGravestone(world, blockPos, state);
        if (((Boolean)GravestonesConfig.SPAWN_GRAVESTONE_SKELETONS.getValue()).booleanValue() && world.method_8510() % 900L == 0L && TechnicalGravestoneBlockEntity.isOwnerNearby(world, entity, blockPos)) {
            TechnicalGravestoneBlockEntity.spawnSkeletons(world, entity, blockPos);
        }
    }

    private static boolean isOwnerNearby(class_1937 world, TechnicalGravestoneBlockEntity entity, class_2338 blockPos) {
        GraveOwner graveOwner = entity.getGraveOwner();
        if (graveOwner == null) {
            return false;
        }
        class_238 box = class_238.method_54784((class_2338)blockPos.method_10087(30).method_10077(50).method_10088(50), (class_2338)blockPos.method_10086(30).method_10076(50).method_10089(50));
        for (class_1297 nearbyEntity : world.method_8335(null, box)) {
            class_1657 player;
            if (!(nearbyEntity instanceof class_1657) || !VersionUtil.getId((player = (class_1657)nearbyEntity).method_7334()).equals(graveOwner.getUuid())) continue;
            return true;
        }
        return false;
    }

    private static void spawnSkeletons(class_1937 world, TechnicalGravestoneBlockEntity entity, class_2338 blockPos) {
        int entityCount = entity.countEntities(world);
        if (entityCount >= 5) {
            return;
        }
        GravestoneSkeletonEntity spawned = new GravestoneSkeletonEntity(world);
        ArrayList<class_2338> possiblePos = new ArrayList<class_2338>();
        for (int x = -5; x < 6; ++x) {
            for (int y = -5; y < 6; ++y) {
                for (int z = -5; z < 6; ++z) {
                    possiblePos.add(new class_2338(entity.method_11016().method_10263() + x, entity.method_11016().method_10264() + y, entity.method_11016().method_10260() + z));
                }
            }
        }
        Random random = new Random();
        class_2338 finalPos = null;
        while (!possiblePos.isEmpty()) {
            int randInt = random.nextInt(possiblePos.size());
            class_2338 possible = (class_2338)possiblePos.get(randInt);
            possiblePos.remove(randInt);
            boolean tooFar = false;
            while (world.method_8320(possible.method_10074()).method_26215() && !tooFar) {
                if (possible.method_10074().method_10264() < blockPos.method_10087(5).method_10264()) {
                    tooFar = true;
                }
                possible = possible.method_10074();
            }
            if (tooFar || !world.method_8320(possible).method_26215() || !world.method_8320(possible.method_10084()).method_26215()) continue;
            finalPos = possible;
            break;
        }
        if (finalPos == null) {
            finalPos = blockPos;
        }
        spawned.method_23327((double)finalPos.method_10263() + 0.5, (double)finalPos.method_10264() + 0.1, (double)finalPos.method_10260() + 0.5);
        spawned.method_6092(new class_1293(class_1294.field_5918, -1));
        if ((double)random.nextFloat() > 0.5) {
            spawned.method_5673(class_1304.field_6173, class_1802.field_8102.method_7854());
            spawned.method_5673(class_1304.field_6169, class_1802.field_8267.method_7854());
        } else {
            spawned.method_5673(class_1304.field_6169, class_1802.field_8743.method_7854());
        }
        spawned.method_5946(class_1304.field_6173, 0.0f);
        spawned.method_5946(class_1304.field_6169, 0.0f);
        world.method_8649((class_1297)spawned);
        TechnicalGravestoneBlock.createSoulParticles(world, finalPos);
        TechnicalGravestoneBlock.createSoulParticles(world, blockPos);
    }

    private int countEntities(class_1937 world) {
        class_238 box = class_238.method_54784((class_2338)this.method_11016().method_10087(15).method_10077(15).method_10088(15), (class_2338)this.method_11016().method_10086(15).method_10076(15).method_10089(15));
        List entities = world.method_8335(null, box);
        int entityCount = 0;
        for (class_1297 nearbyEntity : entities) {
            if (!(nearbyEntity instanceof GravestoneSkeletonEntity)) continue;
            ++entityCount;
        }
        return entityCount;
    }

    public int getDecay() {
        return TechnicalGravestoneBlockEntity.getDecay(Objects.requireNonNull(this.method_10997()).method_8320(this.method_11016()));
    }

    public static int getDecay(class_2680 state) {
        return (Integer)state.method_11654((class_2769)TechnicalGravestoneBlock.DAMAGE);
    }

    public class_2487 getContents() {
        return this.contents;
    }

    public void setContents(class_2487 contents) {
        this.contents = contents;
        this.method_5431();
    }

    public void setGraveOwner(@Nullable GraveOwner graveOwner) {
        this.graveOwner = graveOwner;
        if (this.graveOwner != null && !class_156.method_51894((String)this.graveOwner.getName()) && !class_2631.method_52586((GameProfile)this.graveOwner.getProfile())) {
            class_2631.method_52580((String)this.graveOwner.getName()).thenAcceptAsync(profile -> {
                this.graveOwner.setProfile(profile.orElse(this.graveOwner.getProfile()));
                this.method_5431();
            }, class_2631.field_45147);
        } else {
            this.method_5431();
        }
    }

    public int getTotalDamage() {
        return this.ageDamage + this.deathDamage;
    }

    public int getAgeDamage() {
        return this.ageDamage;
    }

    public void setAgeDamage(int ageDamage) {
        if (this.getAgeDamage() != ageDamage) {
            this.ageDamage = ageDamage;
            this.method_5431();
        }
    }

    public int getDeathDamage() {
        return this.deathDamage;
    }

    public void setDeathDamage(int deathDamage) {
        this.deathDamage = deathDamage;
        this.method_5431();
    }

    @Nullable
    public GraveOwner getGraveOwner() {
        return this.graveOwner;
    }

    public void setSpawnDate(String spawnDateTime, long spawnDateTicks) {
        this.spawnDateTime = spawnDateTime;
        this.spawnDateTicks = spawnDateTicks;
        this.method_5431();
    }

    public String getSpawnDateTime() {
        return this.spawnDateTime;
    }

    public long getSpawnDateTicks() {
        return this.spawnDateTicks;
    }

    @Override
    public class_2350 getGravestoneDirection() {
        return class_2350.field_11043;
    }
}

