package net.pneumono.gravestones;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_5616;
import net.minecraft.class_5619;
import net.minecraft.class_638;
import net.minecraft.class_946;
import net.pneumono.gravestones.block.AestheticGravestoneBlockEntity;
import net.pneumono.gravestones.content.AestheticGravestoneBlockEntityRenderer;
import net.pneumono.gravestones.content.AestheticGravestoneEditScreen;
import net.pneumono.gravestones.content.GravestonesRegistry;
import net.pneumono.gravestones.content.TechnicalGravestoneBlockEntityRenderer;
import net.pneumono.gravestones.networking.GravestoneEditorOpenS2CPayload;

public class GravestonesClient implements ClientModInitializer {
    @Override
    public void onInitializeClient() {
        //? if >=1.21.9 {
        class_5619.method_32173(GravestonesRegistry.GRAVESTONE_SKELETON_ENTITY_TYPE, class_946::new);
        //?} else {
        /*EntityRendererRegistry.register(GravestonesRegistry.GRAVESTONE_SKELETON_ENTITY_TYPE, SkeletonEntityRenderer::new);
        *///?}
        class_5616.method_32144(GravestonesRegistry.TECHNICAL_GRAVESTONE_ENTITY, TechnicalGravestoneBlockEntityRenderer::new);
        class_5616.method_32144(GravestonesRegistry.AESTHETIC_GRAVESTONE_ENTITY, AestheticGravestoneBlockEntityRenderer::new);

        //? if >=1.20.6 {
        ClientPlayNetworking.registerGlobalReceiver(GravestoneEditorOpenS2CPayload.PAYLOAD_ID, (payload, context) -> {
            class_310 client = context.client();
            class_638 world = client.field_1687;
            if (world == null) {
                return;
            }

            class_2338 pos = payload.pos();
            class_2586 entity = world.method_8321(pos);
            if (entity instanceof AestheticGravestoneBlockEntity gravestone) {
                client.method_1507(new AestheticGravestoneEditScreen(gravestone, client.method_33883()));
            }
        });
        //?} else {
        /*ClientPlayNetworking.registerGlobalReceiver(GravestoneEditorOpenS2CPayload.ID, (client, handler, buf, sender) -> {
            ClientWorld world = client.world;
            if (world == null) {
                return;
            }

            GravestoneEditorOpenS2CPayload payload = GravestoneEditorOpenS2CPayload.read(buf);
            BlockPos pos = payload.pos();
            BlockEntity entity = world.getBlockEntity(pos);
            if (entity instanceof AestheticGravestoneBlockEntity gravestone) {
                client.execute(() -> client.setScreen(new AestheticGravestoneEditScreen(gravestone, client.shouldFilterText())));
            }
        });
        *///?}
    }
}