package net.pneumono.gravestones.gravestones;

import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import net.pneumono.gravestones.multiversion.VersionUtil;
import net.pneumono.pneumonocore.util.MultiVersionUtil;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.*;

public class GravestoneDataSaving extends GravestoneManager {
    protected static void saveBackup(class_2487 contents, class_1657 player) {
        saveBackup(contents, player, new Date());
    }

    @SuppressWarnings("ResultOfMethodCallIgnored")
    protected static void saveBackup(class_2487 contents, class_1657 player, Date date) {
        String uuidString = VersionUtil.getId(player.method_7334()).toString();
        File deathsFile = new File(
                getOrCreateGravestonesFolder(Objects.requireNonNull(MultiVersionUtil.getWorld(player).method_8503())), uuidString
        );

        deathsFile.mkdirs();

        Path path = deathsFile.toPath().resolve(GravestoneTime.FILE_SAVING.format(date) + ".dat");
        int count = 1;
        while (path.toFile().exists()) {
            count++;
            path = deathsFile.toPath().resolve(GravestoneTime.FILE_SAVING.format(date) + "_" + count + ".dat");
        }

        class_2487 deathData = new class_2487();
        deathData.method_10566("contents", contents);

        try {
            //? if >=1.20.4 {
            class_2507.method_30614(deathData, path);
            //?} else {
            /*NbtIo.writeCompressed(deathData, path.toFile());
            *///?}
        } catch (IOException e) {
            error("Failed to write Gravestone Contents Data", e);
        }
    }

    public static List<RecentGraveHistory> readHistories(MinecraftServer server) {
        Path path = getOrCreateGravestonesDataFile(server);

        class_2487 compound = new class_2487();
        try {
            compound = class_2507.method_30613(path/*? if >=1.20.4 {*/, class_2505.method_53898()/*?} else {*//*.toFile()*//*?}*/);
        } catch (IOException e) {
            error("Failed to read Gravestone Data", e);
        }

        return VersionUtil.get(compound, "data", RecentGraveHistory.CODEC.listOf()).orElse(new ArrayList<>());
    }

    public static void writeData(MinecraftServer server, List<RecentGraveHistory> histories) {
        Path path = getOrCreateGravestonesDataFile(server);

        class_2487 compound = new class_2487();
        VersionUtil.put(compound, "data", RecentGraveHistory.CODEC.listOf(), histories);

        try {
            //? if >=1.20.4 {
            class_2507.method_30614(compound, path);
             //?} else {
            /*NbtIo.writeCompressed(compound, path.toFile());
            *///?}
        } catch (IOException e) {
            error("Failed to write Gravestone Data", e);
        }
    }

    public static Path getOrCreateGravestonesDataFile(MinecraftServer server) {
        File gravestoneFile = getOrCreateGravestonesFolder(server);

        return gravestoneFile.toPath().resolve("data.dat");
    }

    @SuppressWarnings("ResultOfMethodCallIgnored")
    public static File getOrCreateGravestonesFolder(MinecraftServer server) {
        File gravestonesFile = new File(server.method_27050(class_5218.field_24188).toString(), "gravestones");

        gravestonesFile.mkdirs();

        return gravestonesFile;
    }
}
