/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.gravestones.api;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.pneumono.gravestones.Gravestones;
import net.pneumono.gravestones.GravestonesConfig;
import net.pneumono.gravestones.api.GravestoneDataType;
import net.pneumono.gravestones.api.InsertGravestoneItemCallback;
import net.pneumono.gravestones.block.TechnicalGravestoneBlockEntity;
import net.pneumono.gravestones.multiversion.VersionUtil;

public class GravestonesApi {
    private static final Map<class_2960, GravestoneDataType> DATA_TYPES = new HashMap<class_2960, GravestoneDataType>();
    private static final List<BiPredicate<class_1657, class_1799>> ITEM_SKIP_PREDICATES = new ArrayList<BiPredicate<class_1657, class_1799>>();

    public static void registerDataType(class_2960 identifier, GravestoneDataType dataType) {
        DATA_TYPES.put(identifier, dataType);
    }

    @Deprecated
    public static void registerItemSkipPredicate(BiPredicate<class_1657, class_1799> predicate) {
        ITEM_SKIP_PREDICATES.add(predicate);
    }

    public static class_2487 getDataToInsert(class_1657 player) {
        class_2487 contents = new class_2487();
        for (Map.Entry<class_2960, GravestoneDataType> entry : DATA_TYPES.entrySet()) {
            class_2487 data = new class_2487();
            try {
                class_2509 ops = class_2509.field_11560;
                entry.getValue().writeData(data, (DynamicOps<class_2520>)ops, player);
            }
            catch (Exception e) {
                Gravestones.LOGGER.error("Gravestones Data Type '{}' failed to write data:", (Object)entry.getKey().toString(), (Object)e);
            }
            contents.method_10566(entry.getKey().toString(), (class_2520)data);
        }
        return contents;
    }

    public static void onBreak(class_3218 world, class_2338 pos, int decay, TechnicalGravestoneBlockEntity entity) {
        GravestonesApi.onBreak(world, pos, decay, entity.getContents());
    }

    public static void onBreak(class_3218 world, class_2338 pos, int decay, class_2487 contents) {
        if (contents.method_33133()) {
            return;
        }
        for (Map.Entry<class_2960, GravestoneDataType> entry : DATA_TYPES.entrySet()) {
            String key = entry.getKey().toString();
            try {
                class_2509 ops = class_2509.field_11560;
                entry.getValue().onBreak(VersionUtil.getCompoundOrEmpty(contents, key), (DynamicOps<class_2520>)ops, (class_1937)world, pos, decay);
            }
            catch (Exception e) {
                Gravestones.LOGGER.error("Gravestones Data Type '{}' failed to drop contents:", (Object)key, (Object)e);
            }
        }
    }

    public static void onCollect(class_3218 world, class_2338 pos, class_1657 player, int decay, class_2487 contents) {
        for (Map.Entry<class_2960, GravestoneDataType> entry : DATA_TYPES.entrySet()) {
            String key = entry.getKey().toString();
            try {
                class_2509 ops = class_2509.field_11560;
                entry.getValue().onCollect(VersionUtil.getCompoundOrEmpty(contents, key), (DynamicOps<class_2520>)ops, (class_1937)world, pos, player, decay);
                contents.method_10551(key);
            }
            catch (Exception e) {
                Gravestones.LOGGER.error("Gravestones Data Type '{}' failed to return contents:", (Object)key, (Object)e);
            }
        }
    }

    public static boolean shouldDecayAffectGameplay() {
        return (Boolean)GravestonesConfig.AESTHETIC_DECAY.getValue() == false;
    }

    public static boolean shouldSkipItem(class_1657 player, class_1799 stack) {
        if (((InsertGravestoneItemCallback)InsertGravestoneItemCallback.EVENT.invoker()).insertItem(player, stack)) {
            return true;
        }
        for (BiPredicate<class_1657, class_1799> predicate : ITEM_SKIP_PREDICATES) {
            if (!predicate.test(player, stack)) continue;
            return true;
        }
        return false;
    }

    public static int getDecayedExperience(int experience, int decay) {
        if (((Boolean)GravestonesConfig.EXPERIENCE_DECAY.getValue()).booleanValue() && GravestonesApi.shouldDecayAffectGameplay()) {
            return experience / (decay + 1);
        }
        return experience;
    }
}

