package net.pneumono.gravestones.gravestones;

import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_4208;
import net.pneumono.gravestones.GravestonesConfig;
import net.pneumono.gravestones.multiversion.VersionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GravestoneManager {
    protected static final Logger LOGGER = LoggerFactory.getLogger("Gravestones Debug");
    private static boolean consoleInfo = false;

    public static void checkConsoleInfoConfig() {
        consoleInfo = GravestonesConfig.CONSOLE_INFO.getValue();
    }

    public static boolean isUsingDebug() {
        return consoleInfo;
    }

    public static void info(String string) {
        if (consoleInfo) {
            LOGGER.info(string);
        }
    }

    public static void info(String string, Object... objects) {
        if (consoleInfo) {
            LOGGER.info(string, objects);
        }
    }

    public static void warn(String string) {
        if (consoleInfo) {
            LOGGER.warn(string);
        }
    }

    public static void warn(String string, Object... objects) {
        if (consoleInfo) {
            LOGGER.warn(string, objects);
        }
    }

    public static void error(String string) {
        if (consoleInfo) {
            LOGGER.error(string);
        }
    }

    public static void error(String string, Object... objects) {
        if (consoleInfo) {
            LOGGER.error(string, objects);
        }
    }

    public static void error(String string, Throwable t) {
        if (consoleInfo) {
            LOGGER.error(string, t);
        }
    }

    public static String posToString(class_2338 pos) {
        return "(" + pos.method_23854() + ")";
    }

    public static String posToString(class_4208 global) {
        return posToString(VersionUtil.getPos(global)) + " in " + VersionUtil.getDimension(global).method_29177().toString();
    }

    public static class_2561 posToText(class_4208 global) {
        class_2338 pos = VersionUtil.getPos(global);
        return class_2561.method_43469("gravestones.position", pos.method_10263(), pos.method_10264(), pos.method_10260(), VersionUtil.getDimension(global).method_29177().toString());
    }
}
