/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.gravestones.block;

import java.util.Arrays;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2190;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2626;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5244;
import net.minecraft.class_5712;
import net.minecraft.class_5953;
import net.minecraft.class_7699;
import net.minecraft.class_8232;
import net.minecraft.class_8233;
import net.minecraft.class_8234;
import net.minecraft.class_8242;
import net.pneumono.gravestones.GravestonesConfig;
import net.pneumono.gravestones.block.AbstractGravestoneBlock;
import net.pneumono.gravestones.block.AestheticGravestoneBlockEntity;
import net.pneumono.gravestones.content.GravestonesRegistry;
import net.pneumono.gravestones.networking.GravestoneEditorOpenS2CPayload;
import net.pneumono.pneumonocore.util.MultiVersionUtil;
import org.jetbrains.annotations.Nullable;

public class AestheticGravestoneBlock
extends AbstractGravestoneBlock {
    public AestheticGravestoneBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1269 result = this.onUseWithItem(player.method_5998(hand), state, world, pos, player, hand, hit);
        if (result == class_1269.field_5811) {
            return this.onUse(state, world, pos, player, hit);
        }
        return result;
    }

    protected class_1269 onUseWithItem(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1747 blockItem;
        class_2586 blockEntity = world.method_8321(pos);
        if (!(blockEntity instanceof AestheticGravestoneBlockEntity)) {
            return class_1269.field_5811;
        }
        AestheticGravestoneBlockEntity gravestone = (AestheticGravestoneBlockEntity)blockEntity;
        class_1792 item = stack.method_7909();
        boolean waxed = gravestone.isWaxed();
        if (!waxed && item instanceof class_1747 && (blockItem = (class_1747)item).method_7711() instanceof class_2190 && gravestone.getHeadStack().method_7960()) {
            if (!world.method_8608()) {
                world.method_45447(null, blockEntity.method_11016(), GravestonesRegistry.SOUND_BLOCK_GRAVESTONE_ADD_SKULL, class_3419.field_15245);
                gravestone.setHeadStack((class_1309)player, stack);
            }
            return class_1269.field_5812;
        }
        if (!world.method_8608()) {
            if (item instanceof class_8234) {
                class_8234 signChangingItem = (class_8234)item;
                if (player.method_7294() && !waxed && AestheticGravestoneBlock.noOtherPlayerEditing(player, gravestone) && signChangingItem.method_49801(gravestone.getText(), player) && AestheticGravestoneBlock.tryTextChange(world, item, gravestone)) {
                    gravestone.runCommandClickEvent(player, world, pos);
                    player.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
                    world.method_43276(class_5712.field_28733, gravestone.method_11016(), class_5712.class_7397.method_43286((class_1297)player, (class_2680)gravestone.method_11010()));
                    if (!player.method_7337()) {
                        stack.method_7934(1);
                    }
                    return class_1269.field_5812;
                }
            }
            return class_1269.field_5811;
        }
        if (!(item instanceof class_8234 && player.method_7294() || waxed)) {
            return class_1269.field_21466;
        }
        return class_1269.field_5812;
    }

    private static boolean tryTextChange(class_1937 world, class_1792 item, AestheticGravestoneBlockEntity gravestone) {
        if (item instanceof class_1769) {
            class_1769 dyeItem = (class_1769)item;
            if (gravestone.changeText(text -> text.method_49862(dyeItem.method_7802()))) {
                world.method_8396(null, gravestone.method_11016(), class_3417.field_28391, class_3419.field_15245, 1.0f, 1.0f);
                return true;
            }
            return false;
        }
        if (item instanceof class_8232) {
            if (gravestone.changeText(text -> text.method_49867(true))) {
                world.method_8396(null, gravestone.method_11016(), class_3417.field_28392, class_3419.field_15245, 1.0f, 1.0f);
                return true;
            }
            return false;
        }
        if (item instanceof class_8233) {
            if (gravestone.changeText(text -> text.method_49867(false))) {
                world.method_8396(null, gravestone.method_11016(), class_3417.field_28397, class_3419.field_15245, 1.0f, 1.0f);
                return true;
            }
            return false;
        }
        if (item instanceof class_5953) {
            if (gravestone.setWaxed(true)) {
                world.method_8444(null, 3003, gravestone.method_11016(), 0);
                return true;
            }
            return false;
        }
        return false;
    }

    public class_1269 onUse(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        class_2586 class_25862 = world.method_8321(pos);
        if (!(class_25862 instanceof AestheticGravestoneBlockEntity)) {
            return class_1269.field_5811;
        }
        AestheticGravestoneBlockEntity blockEntity = (AestheticGravestoneBlockEntity)class_25862;
        if (world.method_8608()) {
            class_156.method_22320((Throwable)new IllegalStateException("Expected to only call this on server"));
        }
        class_1799 headStack = blockEntity.getHeadStack();
        if (!blockEntity.isWaxed() && !headStack.method_7960()) {
            world.method_45447(null, blockEntity.method_11016(), GravestonesRegistry.SOUND_BLOCK_GRAVESTONE_REMOVE_SKULL, class_3419.field_15245);
            if (!player.method_7270(headStack)) {
                player.method_7328(headStack, false);
            }
            blockEntity.setHeadStack((class_1309)player, class_1799.field_8037);
            return class_1269.field_5812;
        }
        boolean ranCommand = blockEntity.runCommandClickEvent(player, world, pos);
        if (blockEntity.isWaxed()) {
            world.method_45447(null, blockEntity.method_11016(), GravestonesRegistry.SOUND_BLOCK_WAXED_GRAVESTONE_INTERACT_FAIL, class_3419.field_15245);
            return class_1269.field_5812;
        }
        if (ranCommand) {
            return class_1269.field_5812;
        }
        if (AestheticGravestoneBlock.noOtherPlayerEditing(player, blockEntity) && player.method_7294() && this.isTextLiteralOrEmpty(player, blockEntity)) {
            this.openEditScreen(player, blockEntity);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof AestheticGravestoneBlockEntity) {
            AestheticGravestoneBlockEntity blockEntity = (AestheticGravestoneBlockEntity)class_25862;
            class_1264.method_5449((class_1937)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)blockEntity.getHeadStack());
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    public void openEditScreen(class_1657 player, AestheticGravestoneBlockEntity blockEntity) {
        blockEntity.setEditor(player.method_5667());
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            class_2338 pos = blockEntity.method_11016();
            serverPlayer.field_13987.method_14364((class_2596)new class_2626((class_1922)MultiVersionUtil.getWorld((class_1297)serverPlayer), pos));
            GravestoneEditorOpenS2CPayload payload = new GravestoneEditorOpenS2CPayload(pos);
            ServerPlayNetworking.send((class_3222)serverPlayer, (class_2960)payload.comp_1678(), (class_2540)payload.write());
        }
    }

    private static boolean noOtherPlayerEditing(class_1657 player, AestheticGravestoneBlockEntity blockEntity) {
        UUID uUID = blockEntity.getEditor();
        return uUID == null || uUID.equals(player.method_5667());
    }

    private boolean isTextLiteralOrEmpty(class_1657 player, AestheticGravestoneBlockEntity blockEntity) {
        class_8242 signText = blockEntity.getText();
        return Arrays.stream(signText.method_49877(player.method_33793())).allMatch(message -> message.equals((Object)class_5244.field_39003) || message.method_10851() instanceof class_2585);
    }

    public boolean method_45382(class_7699 enabledFeatures) {
        return (Boolean)GravestonesConfig.AESTHETIC_GRAVESTONES.getValue() != false && super.method_45382(enabledFeatures);
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new AestheticGravestoneBlockEntity(pos, state);
    }
}

