package net.pneumono.gravestones.compat;

//? if accessories {
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.slot.SlotReference;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.server.MinecraftServer;
import net.pneumono.gravestones.api.GravestoneDataType;
import net.pneumono.gravestones.api.GravestonesApi;
import net.pneumono.gravestones.multiversion.VersionUtil;
import net.pneumono.pneumonocore.util.MultiVersionUtil;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

//? if >=1.21.5 {
/*import io.wispforest.accessories.api.core.Accessory;
import io.wispforest.accessories.api.core.AccessoryRegistry;
import io.wispforest.accessories.api.slot.SlotPredicateRegistry;
import io.wispforest.accessories.impl.core.ExpandedContainer;
*///?} else if >=1.21.3 {
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.AccessoryRegistry;
import io.wispforest.accessories.api.slot.SlotPredicateRegistry;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
//?} else {
/*import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
*///?}

//? if >=1.21.4 {
import io.wispforest.accessories.Accessories;
//?}

public class AccessoriesDataType extends GravestoneDataType {
    private static final String KEY = "accessories";

    //? if >=1.21.4 {
    @SuppressWarnings("UnstableApiUsage")
    //?}
    @Override
    public void writeData(class_2487 nbt, DynamicOps<class_2520> ops, class_1657 player) throws Exception {
        MinecraftServer server = MultiVersionUtil.getWorld(player).method_8503();
        if (server == null /*? if >=1.21.4 {*/|| server.method_3767().method_8355(Accessories.RULE_KEEP_ACCESSORY_INVENTORY)/*?}*/) {
            return;
        }

        AccessoriesCapability capability = AccessoriesCapability.get(player);
        if (capability == null) {
            throw new IllegalStateException("Player {} does not have an AccessoriesCapability");
        }

        List<SlotReferencePrimitive> list = new ArrayList<>();
        for (Map.Entry<String, AccessoriesContainer> entry : capability.getContainers().entrySet()) {
            String name = entry.getKey();
            AccessoriesContainer container = entry.getValue();

            //? if >=1.21.5 {
            /*ExpandedContainer accessories = container.getAccessories();
            *///?} else {
            ExpandedSimpleContainer accessories = container.getAccessories();
            //?}
            for (int index = 0; index < accessories.method_5439(); ++index) {
                class_1799 stack = accessories.method_5438(index);
                if (!GravestonesApi.shouldSkipItem(player, stack) && !stack.method_7960()) {
                    accessories.method_5441(index);
                    list.add(new SlotReferencePrimitive(stack, name, index, false));
                }
            }

            //? if >=1.21.5 {
            /*ExpandedContainer cosmetics = container.getCosmeticAccessories();
            *///?} else {
            ExpandedSimpleContainer cosmetics = container.getCosmeticAccessories();
            //?}
            for (int index = 0; index < cosmetics.method_5439(); ++index) {
                class_1799 stack = cosmetics.method_5438(index);
                if (!GravestonesApi.shouldSkipItem(player, stack) && !stack.method_7960()) {
                    cosmetics.method_5441(index);
                    list.add(new SlotReferencePrimitive(stack, name, index, true));
                }
            }
        }

        VersionUtil.put(ops, nbt, KEY, SlotReferencePrimitive.CODEC.listOf(), list);
    }

    @Override
    public void onBreak(class_2487 nbt, DynamicOps<class_2520> ops, class_1937 world, class_2338 pos, int decay) {
        List<SlotReferencePrimitive> list = VersionUtil.get(ops, nbt, KEY, SlotReferencePrimitive.CODEC.listOf()).orElse(null);
        if (list == null || list.isEmpty()) return;

        dropStacks(world, pos, list.stream().map(SlotReferencePrimitive::stack).toList());
    }

    @Override
    public void onCollect(class_2487 nbt, DynamicOps<class_2520> ops, class_1937 world, class_2338 pos, class_1657 player, int decay) {
        List<SlotReferencePrimitive> list = VersionUtil.get(ops, nbt, KEY, SlotReferencePrimitive.CODEC.listOf()).orElse(null);
        if (list == null || list.isEmpty()) return;

        AccessoriesCapability capability = AccessoriesCapability.get(player);
        if (capability == null) {
            warn("Player {} does not have an AccessoriesCapability. Any accessories will be dropped on the ground", player.method_5477().getString());
            dropStacks(world, pos, list.stream().map(SlotReferencePrimitive::stack).toList());
            return;
        }

        List<class_1799> remaining = new ArrayList<>();
        for (SlotReferencePrimitive primitive : list) {
            class_1799 newStack = primitive.stack;
            if (newStack.method_7960()) continue;
            int index = primitive.index;

            AccessoriesContainer container = capability.getContainers().get(primitive.slotName());
            if (container == null || container.getSize() <= 0) {
                remaining.add(newStack);
                continue;
            }

            SlotReference reference = SlotReference.of(player, primitive.slotName(), primitive.index());

            boolean canInsert =
            //? if >=1.21.3 {
            SlotPredicateRegistry.canInsertIntoSlot(newStack, reference);
            //?} else {
            /*AccessoriesAPI.canInsertIntoSlot(newStack, reference);
            *///?}
            if (!canInsert) {
                remaining.add(newStack);
                continue;
            }

            //? if >=1.21.5 {
            /*ExpandedContainer accessories = primitive.cosmetic ? container.getCosmeticAccessories() : container.getAccessories();
            *///?} else {
            ExpandedSimpleContainer accessories = container.getAccessories();
            //?}

            class_1799 oldStack = accessories.method_5438(index);

            boolean canUnequipOldStack =
            //? if >=1.21.3 {
            AccessoryRegistry.canUnequip(oldStack, reference);
            //?} else {
            /*AccessoriesAPI.canUnequip(oldStack, reference);
            *///?}
            boolean canInsertNewStack =
            //? if >=1.21.3 {
            SlotPredicateRegistry.canInsertIntoSlot(newStack, reference);
            //?} else {
            /*AccessoriesAPI.canInsertIntoSlot(newStack, reference);
            *///?}

            if (oldStack.method_7960() && canUnequipOldStack && canInsertNewStack
            ) {
                Accessory accessory =
                //? if >=1.21.3 {
                AccessoryRegistry.getAccessoryOrDefault(oldStack);
                //?} else {
                /*AccessoriesAPI.getOrDefaultAccessory(oldStack);
                *///?}
                class_1799 splitStack = newStack.method_7971(accessory.maxStackSize(newStack));
                accessories.method_5447(index, splitStack);
                if (!newStack.method_7960()) {
                    remaining.add(newStack);
                }
            }
        }

        dropStacks(world, pos, remaining);
    }

    public record SlotReferencePrimitive(class_1799 stack, String slotName, int index, boolean cosmetic) {
        public static final Codec<SlotReferencePrimitive> CODEC = RecordCodecBuilder.create(instance -> instance.group(
                class_1799.field_24671.fieldOf("stack").forGetter(SlotReferencePrimitive::stack),
                Codec.STRING.fieldOf("slot_name").forGetter(SlotReferencePrimitive::slotName),
                Codec.INT.fieldOf("index").forGetter(SlotReferencePrimitive::index),
                Codec.BOOL.fieldOf("cosmetic").forGetter(SlotReferencePrimitive::cosmetic)
        ).apply(instance, SlotReferencePrimitive::new));
    }
}
//?}
